/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model;

import com.grenton.om.cipher.b;
import com.grenton.om.model.ApplicationInstance;
import com.grenton.om.model.DefinedFeature;
import com.grenton.om.model.EmbeddedFeature;
import com.grenton.om.model.Event;
import com.grenton.om.model.IClu;
import com.grenton.om.model.MethodSignature;
import com.grenton.om.model.PeripheryCLU;
import com.grenton.om.model.Script;
import com.grenton.om.model.interfaces.IDeviceObject;
import com.grenton.om.model.interfaces.ISpecificTreeObject;
import com.grenton.om.model.iomodules.ModuleDevice;
import com.grenton.om.model.iomodules.ModuleObject;
import com.grenton.om.model.iomodules.UnknownInputOutput;
import com.grenton.om.model.service.TreeModel;
import com.grenton.om.utils.u;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;

public class CLU
implements IClu,
IDeviceObject,
ISpecificTreeObject,
Comparable<CLU> {
    private static final Logger log = Logger.getLogger(CLU.class);
    private String name;
    private String ipAddress;
    private String nameOnCLU;
    private transient boolean active;
    private transient boolean emergencyMode;
    private List<DefinedFeature> definedFeaturesList = new ArrayList<DefinedFeature>();
    private List<EmbeddedFeature> embeddedFeaturesList = new ArrayList<EmbeddedFeature>();
    private List<Event> eventsList = new ArrayList<Event>();
    private final List<ModuleObject> iosList = new ArrayList<ModuleObject>();
    private List<Script> scripts = new ArrayList<Script>();
    private List<PeripheryCLU> peripheryList = new ArrayList<PeripheryCLU>();
    private List<ApplicationInstance> applicationsList = new ArrayList<ApplicationInstance>();
    private transient Exception confDownloadException = null;
    private boolean isRemoved;
    private boolean visible = true;
    private transient boolean sendingConfiguration = false;
    private final List<ModuleDevice> modulesList = new LinkedList<ModuleDevice>();
    private boolean validConfigurationOnCLU;
    private String configurationErrorMessage;
    private String configurationWarningMessage;
    private String firmwareVersion = "0";
    private String firmwareType = "0";
    private String hardwareVersion = "0";
    private String hardwareType = "0";
    private String serialNumber = "";
    private String macAddress = "";
    private b cipherKeyType;
    private byte[] iv;
    private byte[] privateKey;
    private boolean encrypted = true;
    private Boolean supportWiFi;
    @Deprecated
    private final List<MethodSignature> methodsList = new ArrayList<MethodSignature>();

    public CLU() {
    }

    public CLU(String string, String string2) {
        this.name = string;
        this.ipAddress = string2;
        this.encrypted = TreeModel.getInstance().getProjectProperties().isEncyptedClu(string2);
    }

    public CLU(String string, String string2, String string3) {
        this.name = string;
        this.ipAddress = string2;
        this.encrypted = TreeModel.getInstance().getProjectProperties().isEncyptedClu(string2);
    }

    public void setDefinedFeaturesList(List<DefinedFeature> list) {
        this.definedFeaturesList = list;
    }

    public List<DefinedFeature> getDefinedFeaturesList() {
        return this.definedFeaturesList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public void setIpAddress(String string) {
        this.ipAddress = string;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isEmergencyMode() {
        return this.emergencyMode;
    }

    public void setEmergencyMode(boolean bl) {
        this.emergencyMode = bl;
    }

    @Override
    public String getNameOnCLU() {
        return this.nameOnCLU;
    }

    public void setNameOnCLU(String string) {
        this.nameOnCLU = string;
    }

    public List<ModuleObject> getIOList(boolean bl) {
        LinkedList<ModuleObject> linkedList = new LinkedList<ModuleObject>();
        for (ModuleObject moduleObject : this.iosList) {
            if (!bl && moduleObject.isRemoved()) continue;
            linkedList.add(moduleObject);
        }
        return linkedList;
    }

    public Optional<ModuleObject> getIOByModuleId(long l2) {
        for (ModuleObject moduleObject : this.iosList) {
            if (moduleObject.getModule().getSerialNumber() != l2) continue;
            return Optional.of(moduleObject);
        }
        return Optional.empty();
    }

    public List<ModuleObject> getSortedIOList(boolean bl) {
        LinkedList<ModuleObject> linkedList = new LinkedList<ModuleObject>();
        for (ModuleObject moduleObject : this.iosList) {
            if (!bl && moduleObject.isRemoved()) continue;
            linkedList.add(moduleObject);
        }
        linkedList.sort(u.a);
        return linkedList;
    }

    public List<ISpecificTreeObject> getSortedModulesAndPeripheries(boolean bl) {
        LinkedList<ISpecificTreeObject> linkedList = new LinkedList<ISpecificTreeObject>();
        for (ModuleObject iDeviceObject : this.iosList) {
            if (!bl && iDeviceObject.isRemoved()) continue;
            linkedList.add(iDeviceObject);
        }
        for (PeripheryCLU peripheryCLU : this.peripheryList) {
            if (!bl && peripheryCLU.isRemoved()) continue;
            linkedList.add(peripheryCLU);
        }
        linkedList.sort(u.g);
        return linkedList;
    }

    public ModuleObject getIoByName(String string) {
        for (ModuleObject moduleObject : this.iosList) {
            if (!moduleObject.getName().equals(string)) continue;
            return moduleObject;
        }
        return null;
    }

    public ModuleObject getIoByNameOnClu(String string) {
        for (ModuleObject moduleObject : this.iosList) {
            if (moduleObject.getNameOnCLU() == null || !moduleObject.getNameOnCLU().equals(string)) continue;
            return moduleObject;
        }
        return null;
    }

    public List<ModuleObject> getInactiveIOList() {
        ArrayList<ModuleObject> arrayList = new ArrayList<ModuleObject>();
        for (ModuleObject moduleObject : this.iosList) {
            if (moduleObject instanceof UnknownInputOutput || moduleObject.isActive()) continue;
            arrayList.add(moduleObject);
        }
        return arrayList;
    }

    public void removeIO(ModuleObject moduleObject) {
        if (this.iosList.remove(moduleObject) && this.getModuleIoList(moduleObject.getModule()).isEmpty()) {
            this.removeModuleWithIOs(moduleObject.getModule());
        }
    }

    public void addInputOutput(ModuleObject moduleObject) {
        this.iosList.add(moduleObject);
    }

    public void removeInputOutputs() {
        this.iosList.clear();
    }

    public boolean isConfigurationDownloaded() {
        return this.confDownloadException == null;
    }

    public void setConfigurationDownloadException(Exception exception) {
        this.confDownloadException = exception;
    }

    public Exception getConfigurationDownloadException() {
        return this.confDownloadException;
    }

    public void setEmbeddedFeaturesList(List<EmbeddedFeature> list) {
        this.embeddedFeaturesList = list;
    }

    @Override
    public Event getEventByName(String string) {
        for (Event event : this.eventsList) {
            if (!event.getName().equals(string)) continue;
            return event;
        }
        return null;
    }

    @Override
    public Event getEventByIndex(int n2) {
        for (Event event : this.eventsList) {
            if (event.getIndex() != n2) continue;
            return event;
        }
        return null;
    }

    @Override
    public List<Event> getEvents() {
        return this.eventsList;
    }

    @Override
    public void setEvents(List<Event> list) {
        this.eventsList = list;
    }

    public List<ModuleDevice> getModules() {
        return this.modulesList;
    }

    public void removeModuleWithIOs(long l2) {
        ModuleDevice moduleDevice = this.getModuleById(l2);
        this.iosList.removeAll(this.getModuleIoList(l2));
        this.modulesList.remove(moduleDevice);
    }

    public void removeModuleWithIOs(ModuleDevice moduleDevice) {
        this.iosList.removeAll(this.getModuleIoList(moduleDevice));
        this.modulesList.remove(moduleDevice);
    }

    public void updateModule(ModuleDevice moduleDevice, ModuleDevice moduleDevice2) {
        if (moduleDevice.getSerialNumber() == moduleDevice2.getSerialNumber()) {
            ModuleDevice moduleDevice3 = this.getModuleById(moduleDevice.getSerialNumber());
            boolean bl = this.modulesList.remove(moduleDevice3);
            if (bl) {
                this.modulesList.add(moduleDevice2);
            }
        } else {
            throw new RuntimeException("Cannot update module, module identifiers inconsistency");
        }
    }

    public ModuleDevice getModuleById(long l2) {
        for (ModuleDevice moduleDevice : this.modulesList) {
            if (moduleDevice.getSerialNumber() != l2) continue;
            return moduleDevice;
        }
        return null;
    }

    public List<ModuleObject> getModuleIoList(long l2) {
        LinkedList<ModuleObject> linkedList = new LinkedList<ModuleObject>();
        for (ModuleObject moduleObject : this.iosList) {
            if (moduleObject.getModule().getSerialNumber() != l2) continue;
            linkedList.add(moduleObject);
        }
        return linkedList;
    }

    public List<ModuleObject> getModuleIoList(ModuleDevice moduleDevice) {
        LinkedList<ModuleObject> linkedList = new LinkedList<ModuleObject>();
        for (ModuleObject moduleObject : this.iosList) {
            if (moduleObject.getModule() != moduleDevice) continue;
            linkedList.add(moduleObject);
        }
        return linkedList;
    }

    public void addInputOutputDefinition(ModuleDevice moduleDevice) {
        this.modulesList.add(moduleDevice);
    }

    public void removeInputOutputDefinitions() {
        this.modulesList.clear();
    }

    public void setModuleActve(long l2, boolean bl) {
        ModuleDevice moduleDevice = this.getModuleById(l2);
        if (moduleDevice != null) {
            moduleDevice.setActive(bl);
        }
    }

    public boolean isModuleActve(long l2) {
        ModuleDevice moduleDevice = this.getModuleById(l2);
        return moduleDevice.isActive();
    }

    public List<PeripheryCLU> getPeripheryList(boolean bl) {
        return this.getPeripheryList(bl, false);
    }

    private List<PeripheryCLU> getPeripheryList(boolean bl, boolean bl2) {
        LinkedList<PeripheryCLU> linkedList = new LinkedList<PeripheryCLU>();
        for (PeripheryCLU peripheryCLU : this.peripheryList) {
            if (!bl && peripheryCLU.isRemoved()) continue;
            linkedList.add(peripheryCLU);
        }
        if (bl2) {
            linkedList.sort(u.f);
        }
        return linkedList;
    }

    public PeripheryCLU getPeripheryByName(String string) {
        for (PeripheryCLU peripheryCLU : this.peripheryList) {
            if (!peripheryCLU.getName().equals(string)) continue;
            return peripheryCLU;
        }
        return null;
    }

    public PeripheryCLU getPeripheryByNameOnCLU(String string) {
        for (PeripheryCLU peripheryCLU : this.peripheryList) {
            if (!peripheryCLU.getNameOnCLU().equals(string)) continue;
            return peripheryCLU;
        }
        return null;
    }

    public void setPeripheryList(List<PeripheryCLU> list) {
        this.peripheryList = list;
    }

    public void addPeriphery(PeripheryCLU peripheryCLU) {
        this.peripheryList.add(peripheryCLU);
    }

    public void removePeriphery(PeripheryCLU peripheryCLU) {
        this.peripheryList.remove(peripheryCLU);
    }

    public void removeAllPeripheries() {
        this.peripheryList.clear();
    }

    public List<ISpecificTreeObject> getCluObjects(boolean bl) {
        LinkedList<ISpecificTreeObject> linkedList = new LinkedList<ISpecificTreeObject>();
        linkedList.addAll(this.getIOList(bl));
        linkedList.addAll(this.getPeripheryList(bl));
        return linkedList;
    }

    public ISpecificTreeObject getCluObjectByName(String string) {
        ModuleObject moduleObject = this.getIoByName(string);
        if (moduleObject != null) {
            return moduleObject;
        }
        return this.getPeripheryByName(string);
    }

    public List<ApplicationInstance> getApplicationsList(boolean bl) {
        LinkedList<ApplicationInstance> linkedList = new LinkedList<ApplicationInstance>();
        for (ApplicationInstance applicationInstance : this.applicationsList) {
            if (!bl && applicationInstance.isRemoved()) continue;
            linkedList.add(applicationInstance);
        }
        return linkedList;
    }

    public void setApplicationsList(List<ApplicationInstance> list) {
        this.applicationsList = list;
    }

    public void addApplication(ApplicationInstance applicationInstance) {
        this.applicationsList.add(applicationInstance);
    }

    public void removeApplication(ApplicationInstance applicationInstance) {
        this.applicationsList.remove(applicationInstance);
    }

    public void removeAllApplications() {
        this.applicationsList.clear();
    }

    public ApplicationInstance getApplicationByName(String string) {
        for (ApplicationInstance applicationInstance : this.applicationsList) {
            if (!applicationInstance.getName().equals(string)) continue;
            return applicationInstance;
        }
        return null;
    }

    public void setHwTypeHex(String string) {
        this.hardwareType = string;
    }

    public String getHwTypeHex() {
        return this.hardwareType;
    }

    public long getHwType() {
        return Long.parseLong(this.hardwareType, 16);
    }

    public void setHwVersionHex(String string) {
        this.hardwareVersion = string;
    }

    public String getHwVersionHex() {
        return this.hardwareVersion;
    }

    public long getHwVersion() {
        return Long.parseLong(this.hardwareVersion, 16);
    }

    public void setFwTypeHex(String string) {
        this.firmwareType = string;
    }

    public String getFwTypeHex() {
        return this.firmwareType;
    }

    public long getFwType() {
        return Long.parseLong(this.firmwareType, 16);
    }

    public void setFwApiVersionHex(String string) {
        this.firmwareVersion = string;
    }

    public String getFwApiVersionHex() {
        return this.firmwareVersion;
    }

    public Long getFwApiVersion() {
        return Long.parseLong(this.firmwareVersion, 16);
    }

    public void setSerialNumberHex(String string) {
        this.serialNumber = string;
    }

    public String getSerialNumberHex() {
        return this.serialNumber;
    }

    @Override
    public Long getSerialNumber() {
        return Long.parseLong(this.serialNumber, 16);
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String string) {
        this.macAddress = string;
    }

    @Override
    public void setEmbeddedFeatures(List<EmbeddedFeature> list) {
        this.embeddedFeaturesList.clear();
        this.embeddedFeaturesList.addAll(list);
    }

    @Override
    public List<EmbeddedFeature> getEmbeddedFeatures() {
        return this.embeddedFeaturesList;
    }

    @Override
    public EmbeddedFeature getEmbeddedFeatureByIndex(int n2) {
        for (EmbeddedFeature embeddedFeature : this.getEmbeddedFeatures()) {
            if (embeddedFeature.getIndex() != n2) continue;
            return embeddedFeature;
        }
        return null;
    }

    @Override
    public EmbeddedFeature getEmbeddedFeatureByName(String string) {
        for (EmbeddedFeature embeddedFeature : this.getEmbeddedFeatures()) {
            if (!embeddedFeature.getName().equals(string)) continue;
            return embeddedFeature;
        }
        return null;
    }

    public EmbeddedFeature getEmbeddedFeatureByIName(String string) {
        for (EmbeddedFeature embeddedFeature : this.getEmbeddedFeatures()) {
            if (!embeddedFeature.getName().equalsIgnoreCase(string.toLowerCase())) continue;
            return embeddedFeature;
        }
        return null;
    }

    public DefinedFeature getDefinedFeatureByName(String string) {
        for (DefinedFeature definedFeature : this.getDefinedFeaturesList()) {
            if (!definedFeature.getName().equals(string)) continue;
            return definedFeature;
        }
        return null;
    }

    public DefinedFeature getDefinedFeatureByIName(String string) {
        for (DefinedFeature definedFeature : this.getDefinedFeaturesList()) {
            if (!definedFeature.getName().equalsIgnoreCase(string.toLowerCase())) continue;
            return definedFeature;
        }
        return null;
    }

    public List<Script> getScripts(boolean bl) {
        LinkedList<Script> linkedList = new LinkedList<Script>();
        for (Script script : this.scripts) {
            if (!bl && script.isRemoved()) continue;
            linkedList.add(script);
        }
        return linkedList;
    }

    public Script getScriptByName(String string) {
        for (Script script : this.scripts) {
            if (!script.getName().equals(string)) continue;
            return script;
        }
        return null;
    }

    public Script getScriptByIName(String string) {
        for (Script script : this.scripts) {
            if (!script.getName().equalsIgnoreCase(string.toLowerCase())) continue;
            return script;
        }
        return null;
    }

    public void setScripts(List<Script> list) {
        this.scripts = list;
    }

    public void addScript(Script script) {
        this.scripts.add(script);
    }

    public void removeScript(Script script) {
        this.scripts.remove(script);
    }

    public void removeAllScripts() {
        this.scripts.clear();
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    @Override
    public void setRemoved(boolean bl) {
        this.isRemoved = bl;
    }

    public boolean isSendingConfiguration() {
        return this.sendingConfiguration;
    }

    public void setSendingConfiguration(boolean bl) {
        this.sendingConfiguration = bl;
    }

    public boolean isValidConfigurationOnCLU() {
        return this.validConfigurationOnCLU;
    }

    public void setValidConfigurationOnCLU(boolean bl) {
        if (bl) {
            this.configurationErrorMessage = null;
        }
        this.validConfigurationOnCLU = bl;
    }

    public String getConfigurationErrorMessage() {
        return this.configurationErrorMessage;
    }

    public void setConfigurationErrorMessage(String string) {
        this.configurationErrorMessage = string;
    }

    public String getConfigurationWaringMessage() {
        return this.configurationWarningMessage;
    }

    public void setConfigurationWaringMessage(String string) {
        this.configurationWarningMessage = string;
    }

    public void setCipherKeyType(b b2) {
        this.cipherKeyType = b2;
    }

    public b getCipherKeyType() {
        return this.cipherKeyType;
    }

    public void setIv(byte[] byArray) {
        this.iv = byArray;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            this.privateKey = byArray;
        }
    }

    public Boolean getSupportWiFi() {
        if (Boolean.TRUE == this.supportWiFi) {
            return true;
        }
        return false;
    }

    public void setSupportWiFi(Boolean bl) {
        this.supportWiFi = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CLU cLU = (CLU)object;
        return !(this.serialNumber == null ? cLU.serialNumber != null : !this.serialNumber.equals(cLU.serialNumber));
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.applicationsList == null ? 0 : this.applicationsList.hashCode());
        n2 = 31 * n2 + (this.configurationErrorMessage == null ? 0 : this.configurationErrorMessage.hashCode());
        n2 = 31 * n2 + (this.definedFeaturesList == null ? 0 : this.definedFeaturesList.hashCode());
        n2 = 31 * n2 + (this.embeddedFeaturesList == null ? 0 : this.embeddedFeaturesList.hashCode());
        n2 = 31 * n2 + (this.eventsList == null ? 0 : this.eventsList.hashCode());
        n2 = 31 * n2 + (this.firmwareType == null ? 0 : this.firmwareType.hashCode());
        n2 = 31 * n2 + (this.firmwareVersion == null ? 0 : this.firmwareVersion.hashCode());
        n2 = 31 * n2 + (this.hardwareType == null ? 0 : this.hardwareType.hashCode());
        n2 = 31 * n2 + (this.hardwareVersion == null ? 0 : this.hardwareVersion.hashCode());
        n2 = 31 * n2 + (this.iosList == null ? 0 : this.iosList.hashCode());
        n2 = 31 * n2 + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        n2 = 31 * n2 + (this.isRemoved ? 1231 : 1237);
        n2 = 31 * n2 + (this.macAddress == null ? 0 : this.macAddress.hashCode());
        n2 = 31 * n2 + (this.methodsList == null ? 0 : this.methodsList.hashCode());
        n2 = 31 * n2 + (this.modulesList == null ? 0 : this.modulesList.hashCode());
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = 31 * n2 + (this.nameOnCLU == null ? 0 : this.nameOnCLU.hashCode());
        n2 = 31 * n2 + (this.peripheryList == null ? 0 : this.peripheryList.hashCode());
        n2 = 31 * n2 + (this.scripts == null ? 0 : this.scripts.hashCode());
        n2 = 31 * n2 + (this.serialNumber == null ? 0 : this.serialNumber.hashCode());
        n2 = 31 * n2 + (this.validConfigurationOnCLU ? 1231 : 1237);
        return n2;
    }

    public String toString() {
        return MessageFormat.format("CLU [name={0}, ipAddress={1}, isRemoved={2}, firmwareVersion={3}, firmwareType={4}, hardwareVersion={5}, hardwareType={6}]\nModules Count: {7}", this.name, this.ipAddress, this.isRemoved, this.firmwareVersion, this.firmwareType, this.hardwareVersion, this.hardwareType, this.modulesList.size());
    }

    @Override
    public String getAccessPath() {
        return this.getName();
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    @Override
    public int compareTo(CLU cLU) {
        return this.name.compareTo(cLU.getName());
    }

    public Boolean isLogLevelParameterPresent() {
        EmbeddedFeature embeddedFeature = this.getEmbeddedFeatureByName("TelnetLogLevel");
        if (embeddedFeature != null) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }
}

