/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model;

import com.grenton.om.cluInterface.IfFeature;
import com.grenton.om.model.AbstractFeature;
import com.grenton.om.model.ParamTypeDescriptor;
import com.grenton.om.model.interfaces.IIndexed;
import com.grenton.om.model.types.AccessTypes;
import java.util.Objects;

public class EmbeddedFeature
extends AbstractFeature
implements IIndexed {
    public static final String PREVIOUS_VALUE = "PREVIOUS_VALUE";
    private ParamTypeDescriptor type;
    private AccessTypes accessType = AccessTypes.READ;
    private String initValue;
    private String defaultInitValue;
    private String unit = "";
    private float divisor = 1.0f;
    private int index = -1;
    private String constrainAsString;
    @Deprecated
    private IfFeature ifFeature;

    public EmbeddedFeature() {
        this.setVisible(true);
    }

    @Override
    public ParamTypeDescriptor getType() {
        return this.type;
    }

    public void setType(ParamTypeDescriptor paramTypeDescriptor) {
        this.type = paramTypeDescriptor;
    }

    @Override
    public AccessTypes getAccessType() {
        return this.accessType;
    }

    public void setAccessType(AccessTypes accessTypes) {
        this.accessType = accessTypes;
    }

    public String getInitValue() {
        return this.initValue;
    }

    public void setInitValue(String string) {
        this.initValue = string;
    }

    public String getDefaultInitValue() {
        return this.defaultInitValue;
    }

    public void setDefaultInitValue(String string) {
        this.defaultInitValue = string;
    }

    public String getUnit() {
        if (this.unit == null) {
            return "";
        }
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public float getDivisor() {
        return this.divisor;
    }

    public void setDivisor(float f2) {
        if (f2 != 0.0f) {
            this.divisor = f2;
        }
    }

    public EmbeddedFeature getCopy() {
        EmbeddedFeature embeddedFeature = new EmbeddedFeature();
        embeddedFeature.setAccessType(this.getAccessType());
        embeddedFeature.setInitValue(this.getInitValue());
        embeddedFeature.setDefaultInitValue(this.getDefaultInitValue());
        embeddedFeature.setUnit(this.getUnit());
        embeddedFeature.setDivisor(this.getDivisor());
        embeddedFeature.setName(this.getName());
        embeddedFeature.setType(this.getType());
        embeddedFeature.setValue(this.getValue());
        embeddedFeature.setHint(this.getHint());
        embeddedFeature.setIndex(this.getIndex());
        embeddedFeature.setVisible(this.isVisible());
        return embeddedFeature;
    }

    public String toString() {
        return String.valueOf(this.getType().toString()) + " " + this.getName() + " " + this.getValue() + " [" + (Object)((Object)this.getAccessType()) + "]";
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public void setRemoved(boolean bl) {
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        EmbeddedFeature embeddedFeature = (EmbeddedFeature)object;
        if (!embeddedFeature.getAccessType().equals((Object)this.getAccessType())) {
            return false;
        }
        if (!embeddedFeature.getName().equals(this.getName())) {
            return false;
        }
        if (!this.getHint().equals(embeddedFeature.getHint())) {
            return false;
        }
        if (!Objects.equals(embeddedFeature.getType(), this.getType())) {
            return false;
        }
        if (!embeddedFeature.getUnit().equals(this.getUnit())) {
            return false;
        }
        if (Float.compare(embeddedFeature.getDivisor(), this.getDivisor()) != 0) {
            return false;
        }
        String string = embeddedFeature.getDefaultInitValue();
        if (string == null && this.getDefaultInitValue() != null) {
            return false;
        }
        if (string != null && !string.equals(this.getDefaultInitValue())) {
            return false;
        }
        return embeddedFeature.isVisible() == this.isVisible();
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.accessType == null ? 0 : this.accessType.hashCode());
        n2 = 31 * n2 + (this.defaultInitValue == null ? 0 : this.defaultInitValue.hashCode());
        n2 = 31 * n2 + Float.floatToIntBits(this.divisor);
        n2 = 31 * n2 + (this.initValue == null ? 0 : this.initValue.hashCode());
        n2 = 31 * n2 + (this.type == null ? 0 : this.type.hashCode());
        n2 = 31 * n2 + (this.unit == null ? 0 : this.unit.hashCode());
        return n2;
    }

    @Override
    public String getAccessPath() {
        return this.getName();
    }

    public void setIndex(int n2) {
        this.index = n2;
    }

    @Override
    public int getIndex() {
        if (this.ifFeature != null) {
            return this.ifFeature.d();
        }
        return this.index;
    }

    public void setConstrainAsString(String string) {
        this.constrainAsString = string;
    }

    public String getConstrainAsString() {
        return this.constrainAsString;
    }
}

