/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model;

import com.grenton.om.exceptions.f;
import com.grenton.om.model.interfaces.IIndexed;
import com.grenton.om.model.interfaces.ISpecificTreeObject;
import com.grenton.om.model.types.ParamTypes;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class Event
implements IIndexed,
ISpecificTreeObject,
Cloneable {
    private String name = "";
    private List<ParamTypes> argList = new LinkedList<ParamTypes>();
    private List<String> commands = new LinkedList<String>();
    private List<String> customSchemeCommands = new LinkedList<String>();
    private String hint = "";
    private static final Logger log = Logger.getLogger(Event.class);
    private int index;
    private Boolean visible = Boolean.TRUE;
    @Deprecated
    private String vector = null;

    public Event() {
        this.visible = Boolean.TRUE;
    }

    public Event(String string) {
        this.setName(string);
    }

    public Event(String string, List<String> list) {
        this(string);
        this.setCommands(list);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public List<ParamTypes> getArgList() {
        return this.argList;
    }

    public void setArgList(List<ParamTypes> list) {
        if (list == null) {
            this.argList.clear();
        } else {
            this.argList = list;
        }
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> list) {
        boolean bl = false;
        boolean bl2 = false;
        while (list.contains(null)) {
            list.remove(null);
            bl = true;
        }
        while (list.contains("")) {
            list.remove("");
            bl2 = true;
        }
        if (bl) {
            log.error((Object)"Trying add null as the CLU command.", (Throwable)new f(null));
        }
        if (bl2) {
            log.error((Object)"Trying add an empty command.", (Throwable)new f(""));
        }
        this.commands = list;
    }

    public void addCommand(String string) {
        if (string == null) {
            log.error((Object)"Trying add null as the CLU command.", (Throwable)new f(string));
            return;
        }
        if (string.isEmpty()) {
            log.error((Object)"Trying add an empty command.", (Throwable)new f(string));
        }
        this.commands.add(string);
    }

    public void clearCommands() {
        this.commands.clear();
    }

    @Override
    public int getIndex() {
        if (this.vector != null) {
            return Integer.parseInt(this.vector);
        }
        return this.index;
    }

    public void setIndex(int n2) {
        this.index = n2;
    }

    public List<String> getCustomSchemeCommands() {
        return this.customSchemeCommands;
    }

    public void setCustomSchemeCommands(List<String> list) {
        this.customSchemeCommands = list;
    }

    public void clearCustomSchemeCommands() {
        this.customSchemeCommands.clear();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.commands) {
            stringBuilder.append(string).append('|');
        }
        return String.valueOf(this.getName()) + " (" + stringBuilder + ") [" + this.getIndex() + "]";
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public void setRemoved(boolean bl) {
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Event event = (Event)object;
        if (!event.getName().equals(this.getName())) {
            return false;
        }
        if (event.getIndex() != this.getIndex()) {
            return false;
        }
        if (event.getArgList().size() != this.getArgList().size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.getArgList().size()) {
            if (!event.getArgList().get(n2).equals((Object)this.getArgList().get(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.argList == null ? 0 : this.argList.hashCode());
        n2 = 31 * n2 + (this.commands == null ? 0 : this.commands.hashCode());
        n2 = 31 * n2 + (this.customSchemeCommands == null ? 0 : this.customSchemeCommands.hashCode());
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = 31 * n2 + (this.vector == null ? 0 : this.vector.hashCode());
        return n2;
    }

    public Event clone() {
        Event event = new Event();
        event.setArgList(new LinkedList<ParamTypes>(this.getArgList()));
        event.setCommands(new LinkedList<String>(this.getCommands()));
        event.setCustomSchemeCommands(new LinkedList<String>(this.getCustomSchemeCommands()));
        event.setName(this.getName());
        event.setHint(this.getHint());
        event.setRemoved(this.isRemoved());
        event.setIndex(this.getIndex());
        event.setVisible(this.isVisible());
        return event;
    }

    @Override
    public String getAccessPath() {
        return this.getName();
    }

    @Override
    public String getHint() {
        if (this.hint == null) {
            this.hint = "";
        }
        return this.hint;
    }

    public void setHint(String string) {
        this.hint = string;
    }

    @Override
    public boolean isVisible() {
        if (this.visible == null) {
            return true;
        }
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }
}

