/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model;

import com.grenton.om.model.CLU;
import com.grenton.om.model.FirmwareExclusion;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class FirmwareModel {
    private String firmwareVersion;
    private String firmwareFile;
    private Pair<String, String> firmwareTypeRange = new ImmutablePair((Object)"*", (Object)"*");
    private Pair<String, String> firmwareVersionRange = new ImmutablePair((Object)"*", (Object)"*");
    private Pair<String, String> hardwareTypeRange = new ImmutablePair((Object)"*", (Object)"*");
    private Pair<String, String> hardwareVersionRange = new ImmutablePair((Object)"*", (Object)"*");
    private final List<FirmwareExclusion> exclusions = new ArrayList<FirmwareExclusion>();

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String string) {
        this.firmwareVersion = string;
    }

    public String getFirmwareFile() {
        return this.firmwareFile;
    }

    public void setFirmwareFile(String string) {
        this.firmwareFile = string;
    }

    public Pair<String, String> getFirmwareTypeRange() {
        return this.firmwareTypeRange;
    }

    public void setFirmwareTypeRange(Pair<String, String> pair) {
        this.firmwareTypeRange = pair;
    }

    public Pair<String, String> getFirmwareVersionRange() {
        return this.firmwareVersionRange;
    }

    public void setFirmwareVersionRange(Pair<String, String> pair) {
        this.firmwareVersionRange = pair;
    }

    public Pair<String, String> getHardwareTypeRange() {
        return this.hardwareTypeRange;
    }

    public void setHardwareTypeRange(Pair<String, String> pair) {
        this.hardwareTypeRange = pair;
    }

    public Pair<String, String> getHardwareVersionRange() {
        return this.hardwareVersionRange;
    }

    public void setHardwareVersionRange(Pair<String, String> pair) {
        this.hardwareVersionRange = pair;
    }

    public List<FirmwareExclusion> getExclusions() {
        return this.exclusions;
    }

    public void addExclusion(FirmwareExclusion firmwareExclusion) {
        this.exclusions.add(firmwareExclusion);
    }

    public boolean isCompatible(CLU cLU) {
        if (!(this.isInRange(this.firmwareTypeRange, cLU.getFwTypeHex()) && this.isInRange(this.firmwareVersionRange, cLU.getFwApiVersionHex()) && this.isInRange(this.hardwareTypeRange, cLU.getHwTypeHex()) && this.isInRange(this.hardwareVersionRange, cLU.getHwVersionHex()))) {
            return false;
        }
        for (FirmwareExclusion firmwareExclusion : this.exclusions) {
            if (!firmwareExclusion.isExcluded(cLU)) continue;
            return false;
        }
        return true;
    }

    private boolean isInRange(Pair<String, String> pair, String string) {
        String string2 = (String)pair.getLeft();
        String string3 = (String)pair.getRight();
        long l2 = Long.parseLong(string, 16);
        if ("*".equals(string2) || string2.isEmpty()) {
            string2 = "0";
        }
        if ("*".equals(string3) || string3.isEmpty()) {
            string3 = String.valueOf(l2 + 1L);
        }
        long l3 = Long.parseLong(string2, 16);
        long l4 = Long.parseLong(string3, 16);
        return l2 >= l3 && l2 <= l4;
    }
}

