/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model;

import com.grenton.om.cluInterface.CLUIOMInterface;
import com.grenton.om.cluInterface.IfCluType;
import com.grenton.om.cluInterface.IfFeature;
import com.grenton.om.cluInterface.IfInterface;
import com.grenton.om.cluInterface.IfMethod;
import com.grenton.om.cluInterface.IfModuleObject;
import com.grenton.om.cluInterface.a;
import com.grenton.om.cluInterface.m;
import com.grenton.om.exceptions.UnsupportedCLUException;
import com.grenton.om.exceptions.UnsupportedNameInInterfacesBase;
import com.grenton.om.model.AbstractFeature;
import com.grenton.om.model.CLU;
import com.grenton.om.model.CLUCommand;
import com.grenton.om.model.DefinedFeature;
import com.grenton.om.model.MethodParametrizedParameter;
import com.grenton.om.model.MethodParametrizedParameter$Parametrization;
import com.grenton.om.model.MethodSignature;
import com.grenton.om.model.ParamTypeDescriptor;
import com.grenton.om.model.PeripheryCLU;
import com.grenton.om.model.Script;
import com.grenton.om.model.ScriptParameter;
import com.grenton.om.model.TreeObject;
import com.grenton.om.model.interfaces.IDeviceObject;
import com.grenton.om.model.interfaces.ISpecificTreeObject;
import com.grenton.om.model.iomodules.Input;
import com.grenton.om.model.iomodules.ModuleObject;
import com.grenton.om.model.iomodules.Output;
import com.grenton.om.model.service.ObjectManagerModel;
import com.grenton.om.model.service.TreeModel;
import com.grenton.om.model.types.OMLCommandType;
import com.grenton.om.model.types.ObjectType;
import com.grenton.om.model.types.ParamTypes;
import com.grenton.om.model.types.RestrictionTypes;
import com.grenton.om.scripts.lua.preprocessing.OMLtoLUA;
import com.grenton.om.utils.S;
import com.grenton.om.utils.u;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;

public class OMLCommand
implements Serializable {
    private static final long serialVersionUID = -5175275433220940906L;
    private static final String TOKEN_SIGN = "#";
    private String cluName;
    private String featureName;
    private String cluObjectName;
    private String callFunctionName;
    private String textBefore = "";
    private String textAfter = "";
    private String featureSetValue;
    private List<String> callParams;
    private OMLCommandType type;
    private final String oryginal;
    private final String oryginalWithoutStrings;
    private final List<String> stringsOccures = new LinkedList<String>();
    private static Logger log = Logger.getLogger(OMLCommand.class);

    public OMLCommand(String string) {
        if (string != null) {
            this.oryginal = new String(string);
            string = this.createStringOccureTokens(string);
            this.oryginalWithoutStrings = new String(string);
            this.parse(string);
        } else {
            this.oryginal = null;
            this.oryginalWithoutStrings = null;
        }
    }

    private void parse(String string) {
        if (!this.isValid(string = this.cutDefinedFeatureValueSuffix(string))) {
            return;
        }
        String string2 = this.findFirstCommandOccure(string);
        int n2 = string.indexOf(string2);
        this.textBefore = string.substring(0, n2);
        String[] stringArray = string2.split("->");
        boolean bl = stringArray.length > 2;
        string = string.substring(n2 + string2.length()).trim();
        this.cluName = stringArray[0];
        if (bl) {
            this.cluObjectName = stringArray[1];
        }
        if (!string.isEmpty() && string.charAt(0) == '(') {
            this.type = OMLCommandType.INVOKE;
            this.callFunctionName = stringArray[stringArray.length - 1];
            Integer[] integerArray = this.getTextPositionsBeetwenBrackets(string);
            this.callParams = this.getParametersSeparateComma(string.substring(1));
            if (this.isScriptInvoke()) {
                Script script = this.getCLU().getScriptByName(this.callFunctionName);
                while (script.getParameters().size() > this.callParams.size()) {
                    this.callParams.add("");
                }
                int n3 = 0;
                while (n3 < script.getParameters().size()) {
                    String string3 = script.getParameters().get(n3).getName();
                    int n4 = 0;
                    while (n4 < this.callParams.size()) {
                        if (this.callParams.get(n4).startsWith(String.valueOf(string3) + "=")) {
                            Collections.swap(this.callParams, n4, n3);
                            String string4 = this.callParams.get(n3).substring(string3.length() + 1);
                            this.callParams.set(n3, string4);
                            break;
                        }
                        ++n4;
                    }
                    ++n3;
                }
            }
            this.textAfter = string.substring(integerArray[1] + 1);
        } else if (string.matches("\\s*[\\+\\-\\*/]?=\\s*.+") && !string.matches("\\s*[=<>~]=\\s*.+")) {
            this.type = OMLCommandType.SETTER;
            this.featureName = stringArray[stringArray.length - 1];
            n2 = string.indexOf("=");
            String string5 = string.substring(0, n2).trim();
            string = string.substring(n2 + 1).trim();
            int n5 = 0;
            n2 = 0;
            while (n2 < string.length()) {
                char c2 = string.charAt(n2);
                if (c2 == '(') {
                    ++n5;
                } else if (c2 == ')') {
                    --n5;
                }
                if (n5 < 0) break;
                ++n2;
            }
            this.featureSetValue = string.substring(0, n2);
            this.callParams = new LinkedList<String>();
            this.callParams.add(this.featureSetValue);
            if (!string5.isEmpty()) {
                this.featureSetValue = String.valueOf(string2) + string5 + this.featureSetValue;
            }
            this.textAfter = string.substring(n2);
        } else {
            this.type = OMLCommandType.GETTER;
            this.featureName = stringArray[stringArray.length - 1];
            this.textAfter = string;
        }
    }

    private String cutDefinedFeatureValueSuffix(String string) {
        String[] stringArray;
        String string2 = string;
        if (string.endsWith("->Value") && (stringArray = string.split("->")).length >= 2) {
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            CLU cLU = ObjectManagerModel.getInstance().getCluByName(string3);
            if (cLU != null && cLU.getDefinedFeatureByName(string4) != null) {
                string2 = string.substring(0, string.lastIndexOf("->Value"));
            }
        }
        return string2;
    }

    private List<String> getParametersSeparateComma(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            if (c2 == '(') {
                ++n2;
            } else if (c2 == ')') {
                --n2;
            } else if (c2 == '{') {
                bl = true;
            } else if (c2 == '}') {
                bl = false;
            } else if (c2 == ',' && n2 == 0 && !bl) {
                linkedList.add(string.substring(0, n3).trim());
                string = string.substring(n3 + 1).trim();
                n3 = -1;
                if (")".equals(string)) {
                    n3 = 0;
                    break;
                }
            }
            if (n2 < 0) break;
            ++n3;
        }
        linkedList.add(string.substring(0, n3));
        return linkedList;
    }

    private Integer[] getTextPositionsBeetwenBrackets(String string) {
        int n2 = 0;
        Integer[] integerArray = new Integer[]{-1, -1};
        int n3 = 0;
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            if (integerArray[0] == -1) {
                if (c2 == '(') {
                    integerArray[0] = n3 + 1;
                }
            } else {
                if (c2 == '(') {
                    ++n2;
                } else if (c2 == ')') {
                    --n2;
                }
                if (n2 < 0) {
                    integerArray[1] = n3;
                    break;
                }
            }
            ++n3;
        }
        return integerArray;
    }

    private boolean isValid(String string) {
        return string != null && !OMLCommand.isNilValue(string) && string.contains("->");
    }

    private boolean isValid() {
        return this.isValid(this.oryginal);
    }

    private String findFirstCommandOccure(String string) {
        int n2 = string.indexOf("->");
        if (n2 == -1) {
            return null;
        }
        Scanner scanner = new Scanner(string);
        scanner.findInLine("(\\w+)->((\\w+)->(\\w+\\%?)|(\\w+))");
        try {
            MatchResult matchResult = scanner.match();
            String string2 = matchResult.group(0);
            return string2;
        }
        catch (IllegalStateException illegalStateException) {
            String string3 = string;
            return string3;
        }
        finally {
            scanner.close();
        }
    }

    public CLU getCLU() {
        CLU cLU = null;
        if (this.cluName != null) {
            cLU = ObjectManagerModel.getInstance().getCluByName(this.cluName);
        }
        if (cLU != null) {
            return cLU;
        }
        TreeObject treeObject = TreeModel.getInstance().getObjectByName(this.cluName, ObjectType.CONTAINER);
        if (treeObject == null) {
            return null;
        }
        TreeObject treeObject2 = treeObject.getChildWithName(this.cluObjectName);
        if (treeObject2 != null && treeObject2.getSpecificObject() instanceof ModuleObject) {
            return ((ModuleObject)treeObject2.getSpecificObject()).getClu();
        }
        if (treeObject2 != null && treeObject2.getSpecificObject() instanceof PeripheryCLU) {
            return ((PeripheryCLU)treeObject2.getSpecificObject()).getClu();
        }
        return null;
    }

    public ISpecificTreeObject getCLUObject() {
        if (this.cluObjectName == null) {
            return null;
        }
        CLU cLU = this.getCLU();
        if (cLU == null) {
            return null;
        }
        ModuleObject moduleObject = cLU.getIoByName(this.cluObjectName);
        if (moduleObject != null) {
            return moduleObject;
        }
        return cLU.getPeripheryByName(this.cluObjectName);
    }

    public String getCLUObjectNameOnCLU() {
        ISpecificTreeObject iSpecificTreeObject = this.getCLUObject();
        if (iSpecificTreeObject == null) {
            return null;
        }
        if (iSpecificTreeObject instanceof ModuleObject) {
            return ((ModuleObject)iSpecificTreeObject).getNameOnCLU();
        }
        if (iSpecificTreeObject instanceof PeripheryCLU) {
            return ((PeripheryCLU)iSpecificTreeObject).getNameOnCLU();
        }
        return null;
    }

    public boolean isScriptInvoke() {
        if (this.type != OMLCommandType.INVOKE) {
            return false;
        }
        CLU cLU = this.getCLU();
        if (cLU == null) {
            return false;
        }
        return cLU.getScriptByName(this.callFunctionName) != null && this.getCLUObject() == null;
    }

    public boolean isUserFeatureRefer() {
        if (this.type == OMLCommandType.INVOKE || this.featureName == null) {
            return false;
        }
        CLU cLU = this.getCLU();
        if (cLU == null) {
            return false;
        }
        return cLU.getDefinedFeatureByName(this.featureName) != null;
    }

    public boolean isLogicalValid() {
        if (!this.isValid()) {
            return false;
        }
        try {
            OMLtoLUA.translateExpression(new OMLCommand(this.oryginal));
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private String createStringOccureTokens(String string) {
        List<Integer[]> list = this.getStringsOccursList(string);
        int n2 = 0;
        int n3 = 0;
        for (Integer[] integerArray : list) {
            String string2 = string.substring(integerArray[0] - n2, integerArray[1] - n2);
            this.stringsOccures.add(string2);
            String string3 = TOKEN_SIGN + n3 + TOKEN_SIGN;
            String string4 = string.substring(0, integerArray[0] - n2);
            String string5 = string.substring(integerArray[1] - n2);
            string = String.valueOf(string4) + string3 + string5;
            n2 += string2.length() - string3.length();
            ++n3;
        }
        return string;
    }

    public String restoreStrings(String string) {
        int n2 = 0;
        for (String string2 : this.stringsOccures) {
            string = string.replace(TOKEN_SIGN + n2 + TOKEN_SIGN, string2);
            ++n2;
        }
        return string;
    }

    private List<Integer[]> getStringsOccursList(String string) {
        LinkedList<Integer[]> linkedList = new LinkedList<Integer[]>();
        int n2 = -1;
        char c2 = '\u0000';
        int n3 = 0;
        while (n3 < string.length()) {
            if (this.isQuoteOccure(string, n3)) {
                if (n2 == -1) {
                    c2 = string.charAt(n3);
                    n2 = n3;
                } else if (c2 == string.charAt(n3)) {
                    linkedList.add(new Integer[]{n2, n3 + 1});
                    n2 = -1;
                    c2 = '\u0000';
                }
            }
            ++n3;
        }
        return linkedList;
    }

    private boolean isQuoteOccure(String string, int n2) {
        if (this.isQuoteChar(string.charAt(n2))) {
            if (n2 <= 0) {
                return true;
            }
            int n3 = 0;
            if (n2 >= 0 && string.charAt(--n2) == '\\') {
                ++n3;
            }
            return n3 % 2 == 0;
        }
        return false;
    }

    private boolean isQuoteChar(char c2) {
        return c2 == '\"' || c2 == '\'';
    }

    public String getCluName() {
        return this.cluName;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getCluObjectName() {
        return this.cluObjectName;
    }

    public String getCallFunctionName() {
        return this.callFunctionName;
    }

    public String getTextBefore() {
        return this.restoreStrings(this.textBefore);
    }

    public String getTextAfter() {
        return this.restoreStrings(this.textAfter);
    }

    public void setTextBefore(String string) {
        this.textBefore = string;
    }

    public void setTextAfter(String string) {
        this.textAfter = string;
    }

    public String getFeatureSetValue() {
        if (this.featureSetValue == null) {
            return null;
        }
        return this.restoreStrings(this.featureSetValue);
    }

    public List<String> getCallParams() {
        if (this.callParams == null) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this.callParams) {
            linkedList.add(this.restoreStrings(string));
        }
        return linkedList;
    }

    public OMLCommandType getType() {
        return this.type;
    }

    public String getOryginal() {
        return this.oryginal;
    }

    public String getOryginalWithoutStrings() {
        return this.oryginalWithoutStrings;
    }

    public List<String> getStringsOccures() {
        return this.stringsOccures;
    }

    public static List<String> getAllOMLHeaderCommands(boolean bl, boolean bl2, String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : OMLCommand.getAllOMLHeaderCommands(bl, bl2)) {
            if (!string2.startsWith(string) || string2.equals(string)) continue;
            linkedList.add(string2);
        }
        return linkedList;
    }

    public static List<String> getAllOMLHeaderCommands(boolean bl, boolean bl2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (TreeObject object82 : ObjectManagerModel.getInstance().getAllCluObjectList(false, false, true)) {
            Object object2;
            CLU cLU = (CLU)object82.getSpecificObject();
            for (AbstractFeature abstractFeature : cLU.getEmbeddedFeatures()) {
                if (S.a(abstractFeature)) continue;
                linkedList.add(String.valueOf(cLU.getName()) + "->" + abstractFeature.getName());
            }
            LinkedList<String> linkedList2 = new LinkedList<String>();
            for (AbstractFeature abstractFeature : cLU.getDefinedFeaturesList()) {
                linkedList2.add(String.valueOf(cLU.getName()) + "->" + abstractFeature.getName());
            }
            Collections.sort(linkedList2, u.c);
            linkedList.addAll(linkedList2);
            List<MethodSignature> list = CLUIOMInterface.getInstance().b((IDeviceObject)cLU);
            for (Object object2 : list) {
                if (bl && ((MethodSignature)object2).getReturnType() == null || S.a((ISpecificTreeObject)object2)) continue;
                linkedList.add(String.valueOf(cLU.getName()) + "->" + ((MethodSignature)object2).getName() + "()");
            }
            object2 = new LinkedList();
            for (Script script : cLU.getScripts(false)) {
                if (bl) continue;
                object2.add(script.getAccessPath());
            }
            Collections.sort(object2, u.c);
            linkedList.addAll((Collection<String>)object2);
            LinkedList<String> linkedList3 = new LinkedList<String>();
            for (ISpecificTreeObject iSpecificTreeObject : cLU.getSortedModulesAndPeripheries(false)) {
                Object object32;
                Object object4;
                if (iSpecificTreeObject instanceof ModuleObject) {
                    object4 = (ModuleObject)iSpecificTreeObject;
                    for (AbstractFeature abstractFeature : ((ModuleObject)object4).getEmbeddedFeatures()) {
                        if (S.a(abstractFeature)) continue;
                        linkedList3.add(String.valueOf(((ModuleObject)object4).getAccessPath()) + "->" + abstractFeature.getName());
                    }
                    List<MethodSignature> list2 = CLUIOMInterface.getInstance().b((IDeviceObject)object4);
                    for (Object object32 : list2) {
                        if (bl && ((MethodSignature)object32).getReturnType() == null || S.a((ISpecificTreeObject)object32)) continue;
                        String string = String.valueOf(((ModuleObject)object4).getAccessPath()) + "->" + ((MethodSignature)object32).getName() + "(";
                        String string2 = OMLCommand.getDefaultValuesForCommand(((MethodSignature)object32).getParameters());
                        string = String.valueOf(string) + string2 + ")";
                        linkedList3.add(string);
                    }
                    continue;
                }
                if (!(iSpecificTreeObject instanceof PeripheryCLU)) continue;
                object4 = (PeripheryCLU)iSpecificTreeObject;
                object32 = ((PeripheryCLU)object4).getEmbeddedFeatures().iterator();
                while (object32.hasNext()) {
                    AbstractFeature abstractFeature = object32.next();
                    if (S.a(abstractFeature)) continue;
                    linkedList3.add(String.valueOf(((PeripheryCLU)object4).getAccessPath()) + "->" + abstractFeature.getName());
                }
                List<MethodSignature> list3 = CLUIOMInterface.getInstance().b((IDeviceObject)object4);
                for (Object object32 : list3) {
                    if (bl && ((MethodSignature)object32).getReturnType() == null || S.a((ISpecificTreeObject)object32)) continue;
                    linkedList3.add(String.valueOf(((PeripheryCLU)object4).getAccessPath()) + "->" + ((MethodSignature)object32).getName() + "()");
                }
            }
            linkedList.addAll(linkedList3);
        }
        List<TreeObject> list = TreeModel.getInstance().getRootTree().getChildsWithType(ObjectType.CONTAINER);
        Collections.sort(list, u.e);
        for (Object treeObject : list) {
            List<TreeObject> list4 = ((TreeObject)treeObject).getChildren();
            Collections.sort(list4, u.e);
            for (TreeObject treeObject2 : list4) {
                ISpecificTreeObject iSpecificTreeObject = treeObject2.getSpecificObject();
                if (!(iSpecificTreeObject instanceof Input) && !(iSpecificTreeObject instanceof Output)) continue;
                ModuleObject moduleObject = (ModuleObject)iSpecificTreeObject;
                for (AbstractFeature abstractFeature : moduleObject.getEmbeddedFeatures()) {
                    if (S.a(abstractFeature)) continue;
                    linkedList.add(String.valueOf(moduleObject.getAccessPath()) + "->" + abstractFeature.getName());
                }
                List<MethodSignature> list5 = CLUIOMInterface.getInstance().b(moduleObject);
                for (Object object4 : list5) {
                    if (bl && ((MethodSignature)object4).getReturnType() == null || S.a((ISpecificTreeObject)object4)) continue;
                    linkedList.add(String.valueOf(moduleObject.getAccessPath()) + "->" + ((MethodSignature)object4).getName() + "()");
                }
            }
        }
        return linkedList;
    }

    private static String getDefaultValuesForCommand(List<ScriptParameter> list) {
        String string = "";
        if (list != null && !list.isEmpty()) {
            int n2 = 0;
            while (n2 < list.size()) {
                string = String.valueOf(string) + (n2 > 0 ? "," : "");
                if (list.get(n2) instanceof MethodParametrizedParameter) {
                    MethodParametrizedParameter methodParametrizedParameter = (MethodParametrizedParameter)list.get(n2);
                    string = String.valueOf(string) + OMLCommand.getDefaultValuesForCommand(methodParametrizedParameter);
                } else {
                    string = String.valueOf(string) + OMLCommand.getDefaultValuesForCommand(list.get(n2));
                }
                ++n2;
            }
        }
        return string;
    }

    private static String getDefaultValuesForCommand(ScriptParameter scriptParameter) {
        String string = "";
        ParamTypeDescriptor paramTypeDescriptor = scriptParameter.getType();
        if (paramTypeDescriptor != null && paramTypeDescriptor.getRestrictionValues() != null) {
            string = String.valueOf(string) + paramTypeDescriptor.getRestrictionValues()[0];
        } else if (paramTypeDescriptor != null && paramTypeDescriptor.getParamType().equals((Object)ParamTypes.NUMBER)) {
            string = String.valueOf(string) + 0;
        }
        return string;
    }

    private static String getDefaultValuesForCommand(MethodParametrizedParameter methodParametrizedParameter) {
        String string = "";
        List<MethodParametrizedParameter$Parametrization> list = methodParametrizedParameter.getParametrizations();
        if (list != null && !list.isEmpty()) {
            string = list.get(0).getValue();
        }
        return string;
    }

    public static String[] getFeatureRangeInCommandIfExists(OMLCommand oMLCommand) {
        CLU cLU = oMLCommand.getCLU();
        if (cLU == null) {
            return null;
        }
        if (oMLCommand.getCluObjectName() == null) {
            return OMLCommand.getOMFeatureRangeInCommandIfExists(oMLCommand);
        }
        return OMLCommand.getOMObjectFeatureRangeInCommandIfExists(oMLCommand);
    }

    private static String[] getOMFeatureRangeInCommandIfExists(OMLCommand oMLCommand) {
        String[] stringArray;
        DefinedFeature definedFeature;
        CLU cLU = oMLCommand.getCLU();
        IfInterface ifInterface = CLUIOMInterface.getInstance().b(cLU);
        if (ifInterface == null) {
            log.warn((Object)"Trying get min and max restriction range for unsupported CLU command");
            return null;
        }
        String[] stringArray2 = OMLCommand.getMinMaxFromFeatureOrMethod(oMLCommand, ifInterface);
        if (stringArray2 == null && (definedFeature = cLU.getDefinedFeatureByName(oMLCommand.getFeatureName())) != null && definedFeature.getType().getParamType() == ParamTypes.NUMBER && (stringArray = definedFeature.getType().getRestrictionValues()) != null && stringArray.length > 1) {
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    private static String[] getOMObjectFeatureRangeInCommandIfExists(OMLCommand oMLCommand) {
        CLU cLU = oMLCommand.getCLU();
        ModuleObject moduleObject = cLU.getIoByName(oMLCommand.getCluObjectName());
        PeripheryCLU peripheryCLU = cLU.getPeripheryByName(oMLCommand.getCluObjectName());
        m m2 = null;
        if (moduleObject != null) {
            m2 = CLUIOMInterface.getInstance().a(moduleObject);
        } else if (peripheryCLU != null) {
            IfCluType ifCluType;
            try {
                ifCluType = CLUIOMInterface.getInstance().getClu(cLU);
            }
            catch (UnsupportedCLUException unsupportedCLUException) {
                log.warn((Object)"Trying get min and max restriction range for unsupported CLU command", (Throwable)unsupportedCLUException);
                return null;
            }
            m2 = ifCluType.e(peripheryCLU.getTypeName());
            if (m2 == null) {
                log.warn((Object)"Trying get min and max restriction range for unknown periphery");
                return null;
            }
        }
        if (m2 == null) {
            return null;
        }
        return OMLCommand.getMinMaxFromFeatureOrMethod(oMLCommand, m2);
    }

    private static String[] getMinMaxFromFeatureOrMethod(OMLCommand oMLCommand, IfInterface ifInterface) {
        Object object;
        Object object2 = null;
        Object object3 = null;
        Object object4 = ifInterface.getMethods().iterator();
        while (object4.hasNext()) {
            object = object4.next();
            if (!((IfMethod)object).getName().equals(oMLCommand.getCallFunctionName())) continue;
            object2 = object;
            if (((IfMethod)object2).a() != a.a) break;
            object3 = ((IfMethod)object2).d();
            object2 = null;
            if (object3 != null) break;
            log.warn((Object)("Method which settings value to feature does no have a feature. Command: " + oMLCommand));
            break;
        }
        if (object3 == null) {
            object4 = ifInterface.getFeatures().iterator();
            while (object4.hasNext()) {
                object = (IfFeature)object4.next();
                if (!((IfFeature)object).getName().equals(oMLCommand.getFeatureName())) continue;
                object3 = object;
            }
        }
        if (object2 != null) {
            if (((IfMethod)object2).getParameters().isEmpty()) {
                return null;
            }
            object = ((IfMethod)object2).getParameters().get(0).getType();
            if (((ParamTypeDescriptor)object).getParamType() == ParamTypes.NUMBER && (object4 = ((ParamTypeDescriptor)object).getRestrictionValues()) != null && ((Iterator<Object>)object4).length > 1) {
                return object4;
            }
        } else if (object3 != null && ((IfFeature)object3).getType() == ParamTypes.NUMBER && ((IfFeature)object3).b() == RestrictionTypes.RANGE && (object = ((IfFeature)object3).i()) != null && object.size() > 1) {
            object4 = "" + object.get(0);
            String string = "" + object.get(1);
            if (Float.compare(((IfFeature)object3).h(), 1.0f) != 0) {
                object4 = OMLtoLUA.a((String)object4, ((IfFeature)object3).h());
                string = OMLtoLUA.a(string, ((IfFeature)object3).h());
            }
            return new String[]{object4, string};
        }
        return null;
    }

    public static List<Pair<Integer, CLUCommand>> buildGroupPoolCLUCommandFromOMLRequests(List<OMLCommand> list, String string, int n2, int n3, boolean bl) {
        if (list.isEmpty()) {
            log.warn((Object)"Can't build command from empty list");
            return new LinkedList<Pair<Integer, CLUCommand>>();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (OMLCommand object2 : list) {
            if (object2.getType() != OMLCommandType.GETTER) {
                log.warn((Object)("Can't grab object or feature name to build pool request from command " + object2));
                continue;
            }
            String string2 = OMLCommand.getTableFromOMLCommand(object2);
            if (string2 == null) continue;
            linkedList.add(string2);
        }
        List<Pair<Integer, CLUCommand>> list2 = OMLCommand.buildRegisterCommandFromValues(linkedList, string, n2, n3, bl);
        return list2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTableFromOMLCommand(OMLCommand oMLCommand) {
        if (OMLCommand.isNilValue(oMLCommand.getOryginal())) {
            return "nil";
        }
        String string = null;
        String string2 = oMLCommand.getFeatureName();
        ISpecificTreeObject iSpecificTreeObject = oMLCommand.getCLUObject();
        try {
            Object object;
            if (oMLCommand.isUserFeatureRefer()) {
                return "\"" + string2 + "\"";
            }
            if (iSpecificTreeObject == null) {
                object = oMLCommand.getCLU();
                IfInterface ifInterface = CLUIOMInterface.getInstance().b((CLU)object);
                try {
                    IfFeature ifFeature = ifInterface.a(string2);
                    int n2 = ifFeature.d();
                    string = String.valueOf(((CLU)object).getNameOnCLU()) + "," + n2;
                    return "{" + string + "}";
                }
                catch (UnsupportedNameInInterfacesBase unsupportedNameInInterfacesBase) {
                    string = oMLCommand.getCluObjectName();
                }
                return "{" + string + "}";
            } else {
                Object object2;
                if (iSpecificTreeObject == null) return "{" + string + "}";
                if (iSpecificTreeObject instanceof ModuleObject) {
                    object = CLUIOMInterface.getInstance().a((ModuleObject)iSpecificTreeObject);
                } else {
                    object2 = oMLCommand.getCLU();
                    if (object2 == null) {
                        return null;
                    }
                    IfCluType ifCluType = CLUIOMInterface.getInstance().getClu((CLU)object2);
                    object = ifCluType.e(((PeripheryCLU)iSpecificTreeObject).getTypeName());
                }
                object2 = ((IfInterface)object).a(string2);
                int n3 = ((IfFeature)object2).d();
                string = String.valueOf(oMLCommand.getCLUObjectNameOnCLU()) + "," + n3;
            }
            return "{" + string + "}";
        }
        catch (Exception exception) {
            log.warn((Object)("Can't grab io or object feature name from interface to build pool request from command " + oMLCommand), (Throwable)exception);
            return null;
        }
    }

    public static boolean isNilValue(String string) {
        if (string != null && string.endsWith("->Value")) {
            string = string.substring(0, string.lastIndexOf("->Value"));
        }
        return "nil".equals(string);
    }

    public boolean isNil() {
        return OMLCommand.isNilValue(this.oryginal);
    }

    public static OMLCommand getOMLCommand(String string, String string2) throws NumberFormatException, UnsupportedNameInInterfacesBase {
        String string3 = string2;
        String[] stringArray = string.split(",");
        CLU cLU = ObjectManagerModel.getInstance().getCluByName(string2);
        if (stringArray.length == 1) {
            String string4 = stringArray[0].substring(1, stringArray[0].length() - 1);
            return new OMLCommand(String.valueOf(cLU.getAccessPath()) + "->" + string4 + "->" + "Value");
        }
        String string5 = stringArray[0].substring(1);
        String string6 = stringArray[1].substring(0, stringArray[1].length() - 1);
        ModuleObject moduleObject = cLU.getIoByNameOnClu(string5);
        if (moduleObject != null) {
            IfModuleObject ifModuleObject = CLUIOMInterface.getInstance().a(moduleObject);
            IfFeature ifFeature = ifModuleObject.a(Integer.valueOf(string6));
            string3 = String.valueOf(moduleObject.getAccessPath()) + "->" + ifFeature.getName();
            return new OMLCommand(string3);
        }
        return null;
    }

    public static List<Pair<Integer, CLUCommand>> buildRegisterCommandFromValues(List<String> list, String string, int n2, int n3, boolean bl) {
        int n4 = 1300;
        if (list.isEmpty()) {
            log.warn((Object)"Can't build command from empty list");
            return new LinkedList<Pair<Integer, CLUCommand>>();
        }
        LinkedList<Pair<Integer, CLUCommand>> linkedList = new LinkedList<Pair<Integer, CLUCommand>>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SYSTEM:clientRegister(\"").append(string).append("\",").append(String.valueOf(n2)).append(",").append(String.valueOf(n3++)).append(",{");
        int n5 = 0;
        for (String string2 : list) {
            if (stringBuilder.length() > n4) {
                stringBuilder = stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.append("})");
                linkedList.add((Pair<Integer, CLUCommand>)new ImmutablePair((Object)n5, (Object)new CLUCommand(stringBuilder.toString())));
                stringBuilder = new StringBuilder();
                stringBuilder.append("SYSTEM:clientRegister(\"").append(string).append("\",").append(String.valueOf(n2)).append(",").append(String.valueOf(n3++)).append(",{");
                n5 = 0;
            }
            stringBuilder.append(string2).append(",");
            ++n5;
        }
        if (n5 > 0) {
            stringBuilder = stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append("})");
            linkedList.add((Pair<Integer, CLUCommand>)new ImmutablePair((Object)n5, (Object)new CLUCommand(stringBuilder.toString())));
        }
        return linkedList;
    }

    public static CLUCommand buildDestroyCommand(String string, int n2, int n3) {
        String string2 = "SYSTEM:clientDestroy(\"" + string + "\"," + n2 + "," + n3 + ")";
        return new CLUCommand(string2);
    }

    public static List<Pair<Integer, CLUCommand>> buildFetchValuesCommandFromOmlCommands(List<OMLCommand> list) {
        if (list.isEmpty()) {
            log.warn((Object)"Can't build command from empty list");
            return new LinkedList<Pair<Integer, CLUCommand>>();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (OMLCommand oMLCommand : list) {
            if (oMLCommand.getType() != OMLCommandType.GETTER) {
                log.warn((Object)("Can't grab object or feature name to build pool request from command " + oMLCommand));
                continue;
            }
            String string = OMLCommand.getTableFromOMLCommand(oMLCommand);
            if (string == null) continue;
            linkedList.add(string);
        }
        return OMLCommand.buildFetchValuesCommandFromValues(linkedList);
    }

    public static List<Pair<Integer, CLUCommand>> buildFetchValuesCommandFromValues(List<String> list) {
        int n2 = 1300;
        if (list.isEmpty()) {
            log.warn((Object)"Can't build command from empty list");
            return new LinkedList<Pair<Integer, CLUCommand>>();
        }
        LinkedList<Pair<Integer, CLUCommand>> linkedList = new LinkedList<Pair<Integer, CLUCommand>>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SYSTEM:fetchValues({");
        int n3 = 0;
        for (String string : list) {
            if (stringBuilder.length() > n2) {
                stringBuilder = stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.append("})");
                linkedList.add((Pair<Integer, CLUCommand>)new ImmutablePair((Object)n3, (Object)new CLUCommand(stringBuilder.toString())));
                stringBuilder = new StringBuilder();
                stringBuilder.append("SYSTEM:fetchValues({");
                n3 = 0;
            }
            stringBuilder.append(string).append(",");
            ++n3;
        }
        if (n3 > 0) {
            stringBuilder = stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append("})");
            linkedList.add((Pair<Integer, CLUCommand>)new ImmutablePair((Object)n3, (Object)new CLUCommand(stringBuilder.toString())));
        }
        return linkedList;
    }

    public String toString() {
        return this.oryginal != null ? this.oryginal : "";
    }

    public static String deleteFirstAndLastQuotation(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        char c2 = string.charAt(0);
        char c3 = string.charAt(string.length() - 1);
        if ('\"' == c2 && '\"' == c3 && string.length() > 1) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        OMLCommand oMLCommand = (OMLCommand)object;
        return this.oryginalWithoutStrings.equals(oMLCommand.getOryginalWithoutStrings());
    }
}

