/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model;

import com.google.common.base.Objects;
import com.grenton.om.m.g;
import com.grenton.om.model.types.ParamTypes;
import com.grenton.om.model.types.RestrictionTypes;
import java.util.Arrays;

public class ParamTypeDescriptor {
    private ParamTypes paramType;
    private String[] restrictionValues;
    private String[] restrictionValuesName;
    private RestrictionTypes restrictionType;

    public ParamTypeDescriptor() {
    }

    public ParamTypeDescriptor(ParamTypes paramTypes) {
        this.paramType = paramTypes;
    }

    public ParamTypeDescriptor(ParamTypes paramTypes, RestrictionTypes restrictionTypes, String[] stringArray) {
        this.paramType = paramTypes;
        this.restrictionType = restrictionTypes;
        this.restrictionValues = stringArray;
    }

    public static boolean isValueCorrect(String string, ParamTypeDescriptor paramTypeDescriptor) {
        return ParamTypeDescriptor.validateValue(string, paramTypeDescriptor) == g.a;
    }

    public static g validateValue(String string, ParamTypeDescriptor paramTypeDescriptor) {
        try {
            if (paramTypeDescriptor == null) {
                return g.c;
            }
            if (paramTypeDescriptor.paramType == ParamTypes.TABLE) {
                return g.a;
            }
            if (paramTypeDescriptor.paramType == ParamTypes.STRING) {
                int n2 = string.trim().length();
                if (paramTypeDescriptor.restrictionType == RestrictionTypes.RANGE && paramTypeDescriptor.restrictionValues.length == 2) {
                    Double d2 = Double.valueOf(paramTypeDescriptor.restrictionValues[0]);
                    Double d3 = Double.valueOf(paramTypeDescriptor.restrictionValues[1]);
                    if ((double)n2 >= d2 && (double)n2 <= d3) {
                        return g.a;
                    }
                    if (n2 == 0) {
                        return g.b;
                    }
                    return g.g;
                }
                if (paramTypeDescriptor.restrictionType == RestrictionTypes.ENUMERATE && paramTypeDescriptor.restrictionValues.length > 0) {
                    String[] stringArray = paramTypeDescriptor.restrictionValues;
                    int n3 = paramTypeDescriptor.restrictionValues.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string2 = stringArray[n4];
                        if (Double.compare(Double.valueOf(string2), string.trim().length()) == 0) {
                            return g.a;
                        }
                        ++n4;
                    }
                }
                if (n2 == 0) {
                    return g.b;
                }
                return g.a;
            }
            if (paramTypeDescriptor.paramType == ParamTypes.NUMBER) {
                if (string.trim().length() == 0) {
                    return g.b;
                }
                double d4 = Double.parseDouble(string);
                if (paramTypeDescriptor.restrictionType == RestrictionTypes.RANGE && paramTypeDescriptor.restrictionValues.length == 2) {
                    Double d5 = Double.valueOf(paramTypeDescriptor.restrictionValues[0]);
                    Double d6 = Double.valueOf(paramTypeDescriptor.restrictionValues[1]);
                    if (d4 >= d5 && d4 <= d6) {
                        return g.a;
                    }
                    return g.f;
                }
                if (paramTypeDescriptor.restrictionType == RestrictionTypes.ENUMERATE && paramTypeDescriptor.restrictionValues.length > 0) {
                    String[] stringArray = paramTypeDescriptor.restrictionValues;
                    int n5 = paramTypeDescriptor.restrictionValues.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String string3 = stringArray[n6];
                        if (Double.compare(Double.valueOf(string3), d4) == 0) {
                            return g.a;
                        }
                        ++n6;
                    }
                } else {
                    return g.a;
                }
                return g.d;
            }
            if (paramTypeDescriptor.paramType == ParamTypes.BOOLEAN) {
                if (string.trim().length() == 0) {
                    return g.b;
                }
                if ("true".equals(string) || "false".equals(string)) {
                    return g.a;
                }
                return g.e;
            }
            return g.d;
        }
        catch (NumberFormatException numberFormatException) {
            return g.c;
        }
        catch (Exception exception) {
            return g.d;
        }
    }

    public static ParamTypeDescriptor getTypeForCleanName(String string, String string2) {
        if (string.indexOf("-") > 0) {
            return ParamTypeDescriptor.getTypeForName(String.valueOf(string2) + "[" + string + "]");
        }
        if (string.indexOf(",") > 0) {
            return ParamTypeDescriptor.getTypeForName(String.valueOf(string2) + "{" + string + "}");
        }
        return ParamTypeDescriptor.getTypeForName(string);
    }

    public static ParamTypeDescriptor getTypeForName(String string) {
        if (string != null) {
            try {
                int n2;
                String[] stringArray = null;
                RestrictionTypes restrictionTypes = null;
                if (string.contains("[") && string.contains("]")) {
                    n2 = string.indexOf("[");
                    restrictionTypes = RestrictionTypes.RANGE;
                    stringArray = ParamTypeDescriptor.extractRanges(string.substring(n2));
                    string = string.substring(0, n2);
                } else if (string.contains("{") && string.contains("}")) {
                    n2 = string.indexOf("{");
                    restrictionTypes = RestrictionTypes.ENUMERATE;
                    stringArray = ParamTypeDescriptor.extractEnumerates(string.substring(n2));
                    string = string.substring(0, n2);
                }
                ParamTypeDescriptor paramTypeDescriptor = new ParamTypeDescriptor(ParamTypes.valueOf(string.toUpperCase()));
                if (restrictionTypes != null) {
                    paramTypeDescriptor.setRestriction(restrictionTypes, stringArray);
                }
                return paramTypeDescriptor;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }

    private static String[] extractRanges(String string) {
        String[] stringArray = new String[2];
        String[] stringArray2 = (string = string.substring(1, string.length() - 1)).split("-");
        if (stringArray2.length != 2) {
            return null;
        }
        stringArray[0] = stringArray2[0];
        stringArray[1] = stringArray2[1];
        return stringArray;
    }

    private static String[] extractEnumerates(String string) {
        string = string.substring(1, string.length() - 1);
        String[] stringArray = string.split(",");
        return stringArray;
    }

    public void setRestriction(RestrictionTypes restrictionTypes, String[] stringArray) {
        this.restrictionType = restrictionTypes;
        this.restrictionValues = stringArray;
    }

    public String[] getRestrictionValuesName() {
        return this.restrictionValuesName;
    }

    public void setRestrictionValuesName(String[] stringArray) {
        this.restrictionValuesName = stringArray;
    }

    public String[] getRestrictionValues() {
        return this.restrictionValues;
    }

    public ParamTypes getParamType() {
        return this.paramType;
    }

    public void setParamType(ParamTypes paramTypes) {
        this.paramType = paramTypes;
    }

    public RestrictionTypes getRestrictionType() {
        return this.restrictionType;
    }

    public void setRestrictionType(RestrictionTypes restrictionTypes) {
        this.restrictionType = restrictionTypes;
    }

    public String getRestrictionValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.restrictionType == RestrictionTypes.RANGE) {
            stringBuilder.append('[');
            stringBuilder.append(this.restrictionValues[0]).append("-").append(this.restrictionValues[1]);
            stringBuilder.append(']');
        } else if (this.restrictionType == RestrictionTypes.ENUMERATE) {
            stringBuilder.append('{');
            String[] stringArray = this.restrictionValues;
            int n2 = this.restrictionValues.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                stringBuilder.append(string).append(",");
                ++n3;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public String getCleanRestrictionValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.restrictionType == RestrictionTypes.RANGE) {
            stringBuilder.append(this.restrictionValues[0]).append("-").append(this.restrictionValues[1]);
        } else if (this.restrictionType == RestrictionTypes.ENUMERATE) {
            String[] stringArray = this.restrictionValues;
            int n2 = this.restrictionValues.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                stringBuilder.append(string).append(",");
                ++n3;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public String getRestrictionValueForLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.restrictionType == RestrictionTypes.RANGE) {
            stringBuilder.append('[');
            if (this.restrictionValues[0].equals(this.restrictionValues[1])) {
                stringBuilder.append(this.restrictionValues[0]);
            } else {
                stringBuilder.append(this.restrictionValues[0]).append("-").append(this.restrictionValues[1]);
            }
            stringBuilder.append(']');
        } else if (this.restrictionType == RestrictionTypes.ENUMERATE) {
            String[] stringArray = this.restrictionValues;
            int n2 = this.restrictionValues.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                stringBuilder.append(string).append(",");
                ++n3;
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.paramType != null) {
            stringBuilder.append(this.paramType.toString());
        }
        stringBuilder.append(this.getRestrictionValue());
        return stringBuilder.toString();
    }

    public String getRan() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.paramType != null) {
            stringBuilder.append(this.paramType.toString());
        }
        stringBuilder.append(this.getRestrictionValue());
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        int n2;
        if (object == null) {
            return false;
        }
        ParamTypeDescriptor paramTypeDescriptor = (ParamTypeDescriptor)object;
        if (paramTypeDescriptor.getParamType() == null && this.getParamType() != null) {
            return false;
        }
        if (paramTypeDescriptor.getParamType() != null && !paramTypeDescriptor.getParamType().equals((Object)this.getParamType())) {
            return false;
        }
        if (paramTypeDescriptor.getRestrictionType() == null && this.getRestrictionType() != null) {
            return false;
        }
        if (paramTypeDescriptor.getRestrictionType() != null && !paramTypeDescriptor.getRestrictionType().equals((Object)this.getRestrictionType())) {
            return false;
        }
        if (paramTypeDescriptor.getRestrictionValues() == null && this.getRestrictionValues() != null) {
            return false;
        }
        if (this.getRestrictionValues() == null && paramTypeDescriptor.getRestrictionValues() != null) {
            return false;
        }
        if (paramTypeDescriptor.getRestrictionValues() != null && this.getRestrictionValues() != null) {
            if (paramTypeDescriptor.getRestrictionValues().length != this.getRestrictionValues().length) {
                return false;
            }
            n2 = 0;
            while (n2 < paramTypeDescriptor.getRestrictionValues().length) {
                if (!paramTypeDescriptor.getRestrictionValues()[n2].equals(this.getRestrictionValues()[n2])) {
                    return false;
                }
                ++n2;
            }
        }
        if (paramTypeDescriptor.getRestrictionValuesName() == null && this.getRestrictionValuesName() != null) {
            return false;
        }
        if (this.getRestrictionValuesName() == null && paramTypeDescriptor.getRestrictionValuesName() != null) {
            return false;
        }
        if (paramTypeDescriptor.getRestrictionValuesName() != null && this.getRestrictionValuesName() != null) {
            if (paramTypeDescriptor.getRestrictionValuesName().length != this.getRestrictionValuesName().length) {
                return false;
            }
            n2 = 0;
            while (n2 < paramTypeDescriptor.getRestrictionValuesName().length) {
                String string;
                String string2 = paramTypeDescriptor.getRestrictionValuesName()[n2];
                if (!Objects.equal((Object)string2, (Object)(string = this.getRestrictionValuesName()[n2]))) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.paramType == null ? 0 : this.paramType.hashCode());
        n2 = 31 * n2 + (this.restrictionType == null ? 0 : this.restrictionType.hashCode());
        n2 = 31 * n2 + Arrays.hashCode(this.restrictionValues);
        n2 = 31 * n2 + Arrays.hashCode(this.restrictionValuesName);
        return n2;
    }
}

