/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model;

import com.grenton.Messages;
import com.grenton.om.cluInterface.m;
import com.grenton.om.model.CLU;
import com.grenton.om.model.DefinedFeature;
import com.grenton.om.model.EmbeddedFeature;
import com.grenton.om.model.Event;
import com.grenton.om.model.HardwarePeripheryCLU;
import com.grenton.om.model.MethodSignature;
import com.grenton.om.model.PeripheryObjects;
import com.grenton.om.model.ProgrammablePeripheryCLU;
import com.grenton.om.model.TreeObject;
import com.grenton.om.model.interfaces.IDeviceObject;
import com.grenton.om.model.interfaces.ISpecificTreeObject;
import com.grenton.om.model.iomodules.ModuleObject;
import com.grenton.om.model.service.ObjectManagerModel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class PeripheryCLU
implements IDeviceObject,
ISpecificTreeObject {
    private static Logger LOGGER = Logger.getLogger(PeripheryCLU.class);
    private CLU clu;
    private String name = "";
    private String nameOnCLU;
    private String typeName = "";
    private String typeId;
    private String typeVersion;
    private boolean existsOnCLU = false;
    private List<EmbeddedFeature> features = new LinkedList<EmbeddedFeature>();
    private List<Event> events = new LinkedList<Event>();
    private boolean isRemoved;
    private Set<String> configErrors = new HashSet<String>();
    private boolean visible = true;
    @Deprecated
    private List<MethodSignature> methods = new LinkedList<MethodSignature>();
    @Deprecated
    private String typeSignature = null;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getNameOnCLU() {
        return this.nameOnCLU;
    }

    public void setNameOnCLU(String string) {
        this.nameOnCLU = string;
    }

    public List<EmbeddedFeature> getFeatures() {
        return this.features;
    }

    public void addFeature(EmbeddedFeature embeddedFeature) {
        this.features.add(embeddedFeature);
    }

    public void setFeatures(List<EmbeddedFeature> list) {
        this.features = list;
    }

    @Deprecated
    public List<MethodSignature> getMethods() {
        return this.methods;
    }

    @Override
    public List<Event> getEvents() {
        return this.events;
    }

    @Override
    public void setEvents(List<Event> list) {
        this.events = list;
    }

    @Override
    public void setEmbeddedFeatures(List<EmbeddedFeature> list) {
        this.features.clear();
        this.features.addAll(list);
    }

    @Override
    public List<EmbeddedFeature> getEmbeddedFeatures() {
        return this.features;
    }

    @Override
    public EmbeddedFeature getEmbeddedFeatureByName(String string) {
        for (EmbeddedFeature embeddedFeature : this.getEmbeddedFeatures()) {
            if (!embeddedFeature.getName().equals(string)) continue;
            return embeddedFeature;
        }
        return null;
    }

    @Override
    public EmbeddedFeature getEmbeddedFeatureByIndex(int n2) {
        for (EmbeddedFeature embeddedFeature : this.getEmbeddedFeatures()) {
            if (embeddedFeature.getIndex() != n2) continue;
            return embeddedFeature;
        }
        return null;
    }

    @Override
    public Event getEventByName(String string) {
        for (Event event : this.events) {
            if (!event.getName().equals(string)) continue;
            return event;
        }
        return null;
    }

    @Override
    public Event getEventByIndex(int n2) {
        for (Event event : this.events) {
            if (event.getIndex() != n2) continue;
            return event;
        }
        return null;
    }

    public CLU getClu() {
        return this.clu;
    }

    public void setClu(CLU cLU) {
        this.clu = cLU;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public String getTypeSignature() {
        if (this.typeSignature != null) {
            return this.typeSignature;
        }
        int n2 = -1;
        int n3 = -1;
        if (this.typeId != null) {
            n2 = Integer.parseInt(this.typeId, 16);
        }
        if (this.typeVersion != null) {
            n3 = Integer.parseInt(this.typeVersion, 16);
        }
        return String.valueOf(this.typeName.toUpperCase()) + "-" + n2 + "-" + n3;
    }

    public boolean isExistsOnCLU() {
        return this.existsOnCLU;
    }

    public void setExistsOnCLU(boolean bl) {
        this.existsOnCLU = bl;
    }

    public static PeripheryCLU createEmptyPeripheryObject(m m2) {
        PeripheryCLU peripheryCLU = m2.j() ? new ProgrammablePeripheryCLU() : new HardwarePeripheryCLU();
        return peripheryCLU;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " [" + this.getTypeName() + "]";
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    @Override
    public void setRemoved(boolean bl) {
        this.isRemoved = bl;
    }

    @Override
    public String getAccessPath() {
        return String.valueOf(this.getClu().getName()) + "->" + this.getName();
    }

    public boolean isThermostat() {
        return PeripheryObjects.THERMOSTAT.name().equalsIgnoreCase(this.typeName) || PeripheryObjects.MULTIFANACTHERMOSTAT.name().equalsIgnoreCase(this.typeName);
    }

    public boolean isMultiFanACThermostat() {
        return PeripheryObjects.MULTIFANACTHERMOSTAT.name().equalsIgnoreCase(this.typeName);
    }

    public boolean isConfigurationValid() {
        this.configErrors = new HashSet<String>();
        if (!this.isThermostat()) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = this.getThermostatSourceName();
        String string2 = this.getThermostatControlName();
        String string3 = this.getThermostatLowFanControlName();
        for (TreeObject treeObject : ObjectManagerModel.getInstance().getAllCluObjectList(false, false)) {
            CLU cLU = (CLU)treeObject.getSpecificObject();
            if (!bl && this.isFeatureOrIOExistsOnClu(string, cLU)) {
                bl = true;
            }
            if (!bl2 && this.isFeatureOrIOExistsOnClu(string2, cLU)) {
                bl2 = true;
            }
            if (bl3 || !this.isFeatureOrIOExistsOnClu(string3, cLU)) continue;
            bl3 = true;
        }
        if (!bl2) {
            this.configErrors.add(String.format(Messages.feature_val_not_found, "Control", string2 != null && string2.isEmpty() ? null : string2));
        }
        if (!bl) {
            this.configErrors.add(String.format(Messages.feature_val_not_found, "Source", string != null && string.isEmpty() ? null : string));
        }
        if (this.isMultiFanACThermostat()) {
            if (!bl3) {
                this.configErrors.add(String.format(Messages.feature_val_not_found, "FanLowControl", string3 != null && string3.isEmpty() ? null : string3));
            }
            return bl2 && bl && bl3;
        }
        return bl2 && bl;
    }

    private boolean isFeatureOrIOExistsOnClu(String string, CLU cLU) {
        boolean bl;
        ModuleObject moduleObject = cLU.getIoByName(string);
        DefinedFeature definedFeature = cLU.getDefinedFeatureByIName(string);
        boolean bl2 = moduleObject != null && !moduleObject.isRemoved();
        boolean bl3 = bl = definedFeature != null && !definedFeature.isRemoved();
        return bl2 || bl;
    }

    public String getThermostatSourceName() {
        return this.parseThermostatSCName(this.getEmbeddedFeatureByName("Source"));
    }

    public String getThermostatControlName() {
        return this.parseThermostatSCName(this.getEmbeddedFeatureByName("Control"));
    }

    public String getThermostatLowFanControlName() {
        return this.parseThermostatSCName(this.getEmbeddedFeatureByName("FanLowControl"));
    }

    public String getThermostatMediumFanControlName() {
        return this.parseThermostatSCName(this.getEmbeddedFeatureByName("FanMediumControl"));
    }

    public String getThermostatHighFanControlName() {
        return this.parseThermostatSCName(this.getEmbeddedFeatureByName("FanHighControl"));
    }

    public String getConfigurationErrors() {
        return String.join((CharSequence)"\n", this.configErrors);
    }

    private String parseThermostatSCName(EmbeddedFeature embeddedFeature) {
        if (this.isThermostat() && embeddedFeature != null && embeddedFeature.getInitValue() != null) {
            String string = embeddedFeature.getInitValue();
            if (string.endsWith("->Value")) {
                string = string.substring(0, string.lastIndexOf("->Value"));
            }
            String[] stringArray = string.split("->");
            return stringArray[stringArray.length - 1];
        }
        return "";
    }

    public void setTypeId(String string) {
        this.typeId = string;
    }

    public String getTypeId() {
        String[] stringArray;
        if ((this.typeId == null || this.typeId.isEmpty()) && this.typeSignature != null && !this.typeSignature.isEmpty() && (stringArray = this.typeSignature.split("-")).length == 3) {
            return this.toHexString(stringArray[1]);
        }
        return this.typeId;
    }

    public void setTypeVersion(String string) {
        this.typeVersion = string;
    }

    public String getTypeVersion() {
        String[] stringArray;
        if ((this.typeVersion == null || this.typeVersion.isEmpty()) && this.typeSignature != null && !this.typeSignature.isEmpty() && (stringArray = this.typeSignature.split("-")).length == 3) {
            return this.toHexString(stringArray[2]);
        }
        return this.typeVersion;
    }

    private String toHexString(String string) {
        try {
            return String.format("%01x", Long.parseLong(string));
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }
}

