/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model;

import com.grenton.om.model.ParamTypeDescriptor;
import com.grenton.om.model.interfaces.IFeature;
import com.grenton.om.model.interfaces.ISpecificTreeObject;
import com.grenton.om.model.types.AccessTypes;

public class ScriptParameter
implements IFeature,
ISpecificTreeObject {
    private String name;
    private String value;
    private String defaultValue;
    private ParamTypeDescriptor extendParamType;
    private String unit = "";
    private float divisor = 1.0f;
    private boolean optional = false;

    public ScriptParameter() {
    }

    public ScriptParameter(String string, ParamTypeDescriptor paramTypeDescriptor) {
        this.setName(string);
        this.extendParamType = paramTypeDescriptor;
        this.value = "";
        this.defaultValue = "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    @Override
    public ParamTypeDescriptor getType() {
        return this.extendParamType;
    }

    public void setExtendParamType(ParamTypeDescriptor paramTypeDescriptor) {
        this.extendParamType = paramTypeDescriptor;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public boolean isDefault() {
        return this.defaultValue != null;
    }

    @Override
    public AccessTypes getAccessType() {
        return AccessTypes.ALL;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        if (string != null) {
            this.unit = string;
        }
    }

    public float getDivisor() {
        return this.divisor;
    }

    public void setDivisor(float f2) {
        if (f2 != 0.0f) {
            this.divisor = f2;
        }
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean bl) {
        this.optional = bl;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " (" + this.getDefaultValue() + ": " + this.getType() + ")";
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public void setRemoved(boolean bl) {
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        ScriptParameter scriptParameter = (ScriptParameter)object;
        if (!String.valueOf(scriptParameter.getName()).equals(String.valueOf(this.getName()))) {
            return false;
        }
        if (!String.valueOf(scriptParameter.getDefaultValue()).equals(String.valueOf(this.getDefaultValue()))) {
            return false;
        }
        if (!scriptParameter.getUnit().equals(this.getUnit())) {
            return false;
        }
        if (Float.compare(scriptParameter.getDivisor(), this.getDivisor()) != 0) {
            return false;
        }
        if (scriptParameter.isOptional() != this.isOptional()) {
            return false;
        }
        if (scriptParameter.getType() == null && this.getType() != null) {
            return false;
        }
        if (scriptParameter.getType() != null && !scriptParameter.getType().equals(this.getType())) {
            return false;
        }
        if (scriptParameter.getValue() == null && this.getValue() != null) {
            return false;
        }
        return scriptParameter.getValue() == null || scriptParameter.getValue().equals(this.getValue());
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        n2 = 31 * n2 + Float.floatToIntBits(this.divisor);
        n2 = 31 * n2 + (this.extendParamType == null ? 0 : this.extendParamType.hashCode());
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = 31 * n2 + (this.optional ? 1231 : 1237);
        n2 = 31 * n2 + (this.unit == null ? 0 : this.unit.hashCode());
        n2 = 31 * n2 + (this.value == null ? 0 : this.value.hashCode());
        return n2;
    }

    @Override
    public String getAccessPath() {
        return this.getName();
    }

    public ScriptParameter getCopy() {
        ScriptParameter scriptParameter = new ScriptParameter(this.name, this.extendParamType);
        scriptParameter.setValue(this.value);
        scriptParameter.setDefaultValue(this.defaultValue);
        scriptParameter.setUnit(this.unit);
        scriptParameter.setDivisor(this.divisor);
        scriptParameter.setOptional(this.optional);
        return scriptParameter;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void setVisible(boolean bl) {
    }
}

