/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model;

import com.grenton.om.model.interfaces.ISpecificTreeObject;
import com.grenton.om.model.service.TreeModel;
import com.grenton.om.model.types.ObjectType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TreeObject
implements Comparable<TreeObject> {
    private String name;
    private TreeObject parent;
    private List<TreeObject> children;
    private ObjectType type;
    private Integer id;
    private ISpecificTreeObject specificObject;
    private boolean selected;
    private boolean link;
    private boolean removedLink = false;
    private boolean isDirty;

    public TreeObject() {
    }

    public TreeObject(Integer n2, String string, ObjectType objectType) {
        this.id = n2;
        this.name = string;
        this.type = objectType;
        this.children = new ArrayList<TreeObject>();
        this.link = false;
        this.isDirty = false;
        if (-1 != n2) {
            TreeModel.getInstance().setTreeSaved(false);
        }
    }

    public boolean isLink() {
        return this.link;
    }

    public void setLink(boolean bl) {
        this.link = bl;
    }

    public void setNewParentForLink(TreeObject treeObject) {
        if (!this.isLink() || treeObject.isLink()) {
            return;
        }
        this.id = treeObject.getId();
        this.setSpecificObject(treeObject.getSpecificObject());
    }

    public ISpecificTreeObject getSpecificObject() {
        return this.specificObject;
    }

    public void setSpecificObject(ISpecificTreeObject iSpecificTreeObject) {
        this.specificObject = iSpecificTreeObject;
    }

    public ObjectType getType() {
        return this.type;
    }

    public void setType(ObjectType objectType) {
        this.type = objectType;
    }

    public String getName() {
        return this.name;
    }

    public String getActualName() {
        if (this.type == ObjectType.INPUT || this.type == ObjectType.OUTPUT || this.type == ObjectType.UNKNOWN_IO) {
            return this.getSpecificObject().getName();
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.getName();
    }

    public Integer getId() {
        return this.id;
    }

    public void addChild(TreeObject treeObject) {
        this.children.add(treeObject);
        treeObject.setParent(this);
    }

    public void addChildNoChangeParent(TreeObject treeObject) {
        this.children.add(treeObject);
    }

    public void addChildAtStartNoChangeParent(TreeObject treeObject) {
        this.children.add(0, treeObject);
    }

    public void removeChild(TreeObject treeObject) {
        this.children.remove(treeObject);
        treeObject.setParent(null);
    }

    public List<TreeObject> getChildren() {
        return this.children;
    }

    public void addChildren(List<TreeObject> list) {
        if (list != null) {
            for (TreeObject treeObject : list) {
                this.children.add(treeObject);
                treeObject.setParent(this);
            }
        }
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = 31 * n2 + (this.specificObject == null ? 0 : this.specificObject.hashCode());
        n2 = 31 * n2 + (this.link ? 1 : 0);
        n2 = 31 * n2 + (this.parent == null ? 0 : this.parent.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TreeObject treeObject = (TreeObject)object;
        if (this.name == null ? treeObject.name != null : !this.name.equals(treeObject.name)) {
            return false;
        }
        if (this.specificObject == null ? treeObject.specificObject != null : !this.specificObject.equals(treeObject.specificObject)) {
            return false;
        }
        if (this.link != treeObject.link) {
            return false;
        }
        return !this.link || !treeObject.link || this.parent == null || treeObject.parent == null || this.parent.equals(treeObject.parent);
    }

    public TreeObject getParent() {
        return this.parent;
    }

    public void setParent(TreeObject treeObject) {
        this.parent = treeObject;
    }

    public boolean hasChild(String string) {
        for (TreeObject treeObject : this.children) {
            if (!treeObject.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public TreeObject getFirstChildWithType(ObjectType objectType) {
        for (TreeObject treeObject : this.children) {
            if (treeObject.getType() != objectType) continue;
            return treeObject;
        }
        return null;
    }

    public List<TreeObject> getChildsWithType(ObjectType objectType) {
        LinkedList<TreeObject> linkedList = new LinkedList<TreeObject>();
        for (TreeObject treeObject : this.children) {
            if (treeObject.getType() != objectType) continue;
            linkedList.add(treeObject);
        }
        return linkedList;
    }

    public List<TreeObject> getAllChildsWithType(ObjectType objectType) {
        LinkedList<TreeObject> linkedList = new LinkedList<TreeObject>();
        for (TreeObject treeObject : this.children) {
            if (treeObject.getType() == objectType) {
                linkedList.add(treeObject);
            }
            linkedList.addAll(treeObject.getAllChildsWithType(objectType));
        }
        return linkedList;
    }

    public static boolean isObjectWithDirtyChilds(TreeObject treeObject) {
        if (treeObject.getChildren().isEmpty()) {
            return treeObject.isDirty();
        }
        for (TreeObject treeObject2 : treeObject.getChildren()) {
            if (TreeObject.isObjectWithDirtyChilds(treeObject2)) {
                return true;
            }
            treeObject2.setDirty(false);
        }
        return false;
    }

    private boolean isObjectOrChildsRemoved() {
        if (this.isRemoved()) {
            return true;
        }
        if (this.getChildren().isEmpty()) {
            return this.isRemoved();
        }
        for (TreeObject treeObject : this.getChildren()) {
            if (!treeObject.isObjectOrChildsRemoved()) continue;
            return true;
        }
        return false;
    }

    public boolean isObjectOrParentRemoved() {
        if (this.isRemoved()) {
            return true;
        }
        return this.getParent() != null && this.getParent().isObjectOrParentRemoved();
    }

    public boolean shouldObjectShowInTrash() {
        return this.isObjectOrParentOrChildRemoved();
    }

    private boolean isObjectOrParentOrChildRemoved() {
        if (this.isObjectOrParentRemoved()) {
            return true;
        }
        return this.isObjectOrChildsRemoved();
    }

    public void markChildsAsNotRemoved(boolean bl) {
        if (bl) {
            this.setRemoved(false);
        }
        for (TreeObject treeObject : this.getChildren()) {
            treeObject.markChildsAsNotRemoved(true);
        }
    }

    public TreeObject getChildWithName(String string) {
        for (TreeObject treeObject : this.children) {
            if (!treeObject.getName().equals(string)) continue;
            return treeObject;
        }
        return null;
    }

    public TreeObject getChildWithIName(String string) {
        for (TreeObject treeObject : this.children) {
            if (!treeObject.getName().toLowerCase().equals(string.toLowerCase())) continue;
            return treeObject;
        }
        return null;
    }

    public TreeObject getChildWithStartsName(String string) {
        for (TreeObject treeObject : this.children) {
            if (!treeObject.getName().startsWith(string)) continue;
            return treeObject;
        }
        return null;
    }

    public void removeAllChildrenWithType(ObjectType objectType) {
        Iterator<TreeObject> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TreeObject treeObject = iterator.next();
            if (treeObject.getType() != objectType) continue;
            treeObject.setParent(null);
            iterator.remove();
        }
    }

    public boolean hasRecursiveChild(TreeObject treeObject) {
        while (treeObject.getParent() != null) {
            if (treeObject == this) {
                return true;
            }
            treeObject = treeObject.getParent();
        }
        return false;
    }

    public TreeObject getParentWithObjectType(ObjectType objectType) {
        TreeObject treeObject = this.getParent();
        while (treeObject != null) {
            if (treeObject.getType() == objectType) {
                return treeObject;
            }
            treeObject = treeObject.getParent();
        }
        return null;
    }

    public TreeObject getParentWithObjectType(ObjectType objectType, boolean bl) {
        TreeObject treeObject;
        TreeObject treeObject2 = this;
        if (bl && (treeObject = TreeModel.getInstance().getLinkedObject(this)) != null) {
            treeObject2 = treeObject;
        }
        return treeObject2.getParentWithObjectType(objectType);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public TreeObject getChildWithSpecificObject(ISpecificTreeObject iSpecificTreeObject) {
        for (TreeObject treeObject : this.children) {
            if (treeObject.getSpecificObject() == null || !treeObject.getSpecificObject().equals(iSpecificTreeObject)) continue;
            return treeObject;
        }
        return null;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isRemoved() {
        if (this.link && this.removedLink) {
            return true;
        }
        if (this.specificObject == null) {
            return false;
        }
        return this.specificObject.isRemoved();
    }

    public void setRemoved(boolean bl) {
        if (this.link) {
            this.removedLink = bl;
            if (this.specificObject == null) {
                return;
            }
            if (!bl) {
                this.specificObject.setRemoved(false);
            }
            return;
        }
        if (this.specificObject == null) {
            return;
        }
        this.specificObject.setRemoved(bl);
    }

    @Override
    public int compareTo(TreeObject treeObject) {
        if (this == treeObject) {
            return 0;
        }
        return this.name.compareTo(treeObject.getName());
    }

    public boolean isInContainer() {
        TreeObject treeObject = this.getParentWithObjectType(ObjectType.CONTAINER);
        return treeObject != null && !"System".equals(treeObject.getName());
    }
}

