/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model.iomodules;

import com.grenton.om.cluInterface.CLUIOMInterface;
import com.grenton.om.cluInterface.IfModuleObject;
import com.grenton.om.model.CLU;
import com.grenton.om.model.EmbeddedFeature;
import com.grenton.om.model.Event;
import com.grenton.om.model.interfaces.IDeviceObject;
import com.grenton.om.model.interfaces.ISpecificTreeObject;
import com.grenton.om.model.iomodules.Input;
import com.grenton.om.model.iomodules.ModuleDevice;
import com.grenton.om.model.iomodules.Output;
import com.grenton.om.model.iomodules.UnknownInputOutput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class ModuleObject
implements IDeviceObject,
ISpecificTreeObject {
    private String name;
    private String nameOnCLU;
    private String type;
    private String description = "";
    private List<String> labels = new ArrayList<String>();
    private final List<EmbeddedFeature> features = new ArrayList<EmbeddedFeature>();
    private List<Event> events = new LinkedList<Event>();
    private CLU clu;
    private ModuleDevice module;
    private String classTypeId;
    private boolean isRemoved;
    private String schemeName;
    private int sourceReceiverTypeID = 0;
    private int number;
    private Boolean active = true;
    private Boolean statisticState = false;
    private long tfBusOrder = 0L;
    @Deprecated
    private String typeSignature;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getNameOnCLU() {
        return this.nameOnCLU;
    }

    public void setNameOnCLU(String string) {
        this.nameOnCLU = string;
    }

    public void setTypeName(String string) {
        this.type = string;
    }

    public String getTypeName() {
        return this.type;
    }

    public String getTypeSignature() {
        int n2 = Integer.parseInt(this.classTypeId, 16);
        return String.valueOf(this.type.toUpperCase()) + "-" + n2 + "-1";
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLabels(List<String> list) {
        if (list != null) {
            this.labels = list;
        }
    }

    public List<String> getLabels() {
        return this.labels;
    }

    @Override
    public Event getEventByName(String string) {
        for (Event event : this.events) {
            if (!event.getName().equals(string)) continue;
            return event;
        }
        return null;
    }

    @Override
    public Event getEventByIndex(int n2) {
        for (Event event : this.events) {
            if (event.getIndex() != n2) continue;
            return event;
        }
        return null;
    }

    @Override
    public List<Event> getEvents() {
        return this.events;
    }

    @Override
    public void setEvents(List<Event> list) {
        this.events = list;
    }

    public CLU getClu() {
        return this.clu;
    }

    public void setClu(CLU cLU) {
        this.clu = cLU;
    }

    public ModuleDevice getModule() {
        return this.module;
    }

    public void setModule(ModuleDevice moduleDevice) {
        this.module = moduleDevice;
    }

    public static ModuleObject createEmptyIO(String string, String string2, String string3, String string4, int n2) {
        boolean bl;
        ModuleObject moduleObject = null;
        boolean bl2 = bl = CLUIOMInterface.getInstance().a(string, string2, string3) == null;
        if (bl) {
            moduleObject = new UnknownInputOutput();
            moduleObject.setTypeName(CLUIOMInterface.getInstance().b(string));
            moduleObject.setTypeId("-1");
        } else {
            IfModuleObject ifModuleObject = CLUIOMInterface.getInstance().getModuleObject(string, string2, string3, string4);
            moduleObject = "in".equals(ifModuleObject.d()) ? new Input() : new Output();
            String string5 = ifModuleObject.e();
            moduleObject.setTypeName(string5);
            moduleObject.setTypeId(ifModuleObject.f());
        }
        moduleObject.setIndex(n2);
        return moduleObject;
    }

    public String toString() {
        String string = this.getClu() != null ? this.getClu().getName() : "null";
        return MessageFormat.format("{0} {1}  [{2}]", this.getTypeName(), this.getName(), string);
    }

    public boolean isActive() {
        if (!this.module.isActive()) {
            return this.module.isActive();
        }
        if (this.active == null) {
            return true;
        }
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public String getTypeId() {
        return this.classTypeId;
    }

    public void setTypeId(String string) {
        this.classTypeId = string;
    }

    @Override
    public List<EmbeddedFeature> getEmbeddedFeatures() {
        return this.features;
    }

    @Override
    public EmbeddedFeature getEmbeddedFeatureByName(String string) {
        for (EmbeddedFeature embeddedFeature : this.getEmbeddedFeatures()) {
            if (!embeddedFeature.getName().equals(string)) continue;
            return embeddedFeature;
        }
        return null;
    }

    @Override
    public EmbeddedFeature getEmbeddedFeatureByIndex(int n2) {
        for (EmbeddedFeature embeddedFeature : this.getEmbeddedFeatures()) {
            if (embeddedFeature.getIndex() != n2) continue;
            return embeddedFeature;
        }
        return null;
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    @Override
    public void setRemoved(boolean bl) {
        this.isRemoved = bl;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(String string) {
        this.schemeName = string;
    }

    public boolean isDefinedEventInUse() {
        return this.getSchemeName() != null;
    }

    public int getSourceReceiverTypeID() {
        return this.sourceReceiverTypeID;
    }

    public void setSourceReceiverTypeID(int n2) {
        this.sourceReceiverTypeID = n2;
    }

    @Override
    public String getAccessPath() {
        return String.valueOf(this.getClu().getName()) + "->" + this.getName();
    }

    public int getIndex() {
        return this.number;
    }

    public void setIndex(int n2) {
        this.number = n2;
    }

    public Boolean getStatisticState() {
        if (this.statisticState == null) {
            this.statisticState = false;
        }
        return this.statisticState;
    }

    public void setStatisticState(Boolean bl) {
        this.statisticState = bl;
    }

    public long getTfBusOrder() {
        return this.tfBusOrder;
    }

    public void setTfBusOrder(long l2) {
        this.tfBusOrder = l2;
    }

    @Override
    public void setEmbeddedFeatures(List<EmbeddedFeature> list) {
        this.features.clear();
        this.features.addAll(list);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void setVisible(boolean bl) {
    }
}

