/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model.service;

import com.google.common.base.Objects;
import com.grenton.Messages;
import com.grenton.om.b.b;
import com.grenton.om.cluInterface.CLUIOMInterface;
import com.grenton.om.cluInterface.IfCluType;
import com.grenton.om.cluInterface.m;
import com.grenton.om.configurations.FilesGeneratorFacade;
import com.grenton.om.configurations.h;
import com.grenton.om.exceptions.IncorrectCluCommandException;
import com.grenton.om.exceptions.UnsupportedCLUException;
import com.grenton.om.exceptions.UnsupportedNameInInterfacesBase;
import com.grenton.om.exceptions.e;
import com.grenton.om.exceptions.g;
import com.grenton.om.exceptions.j;
import com.grenton.om.model.ApplicationInstance;
import com.grenton.om.model.CLU;
import com.grenton.om.model.Container;
import com.grenton.om.model.Event;
import com.grenton.om.model.HardwarePeripheryCLU;
import com.grenton.om.model.MethodSignature;
import com.grenton.om.model.OMLCommand;
import com.grenton.om.model.PeripheryCLU;
import com.grenton.om.model.PeripheryObjects;
import com.grenton.om.model.Script;
import com.grenton.om.model.TreeObject;
import com.grenton.om.model.interfaces.IDeviceObject;
import com.grenton.om.model.interfaces.IObjectManagerModel;
import com.grenton.om.model.interfaces.ISpecificTreeObject;
import com.grenton.om.model.iomodules.Input;
import com.grenton.om.model.iomodules.ModuleDevice;
import com.grenton.om.model.iomodules.ModuleObject;
import com.grenton.om.model.iomodules.Output;
import com.grenton.om.model.service.TreeModel;
import com.grenton.om.model.types.ObjectType;
import com.grenton.om.model.util.DeviceObjects;
import com.grenton.om.s;
import com.grenton.om.scripts.lua.a.a;
import com.grenton.om.scripts.lua.preprocessing.OMLtoLUA;
import com.grenton.om.utils.LUAtoOML;
import com.grenton.om.utils.R;
import com.grenton.om.utils.b.c;
import com.grenton.om.utils.f.d;
import com.grenton.om.utils.u;
import com.grenton.scriptbuilder.model.VisualScriptDiagram;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorPart;

public class ObjectManagerModel
implements IObjectManagerModel {
    private static ObjectManagerModel model;
    private TreeObject objectsRootTree;
    private static Logger log;
    private final Object objectsRootTreeLock = new Object();

    static {
        log = Logger.getLogger(ObjectManagerModel.class);
    }

    private ObjectManagerModel() {
    }

    public static synchronized ObjectManagerModel getInstance() {
        if (model == null) {
            model = new ObjectManagerModel();
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeObject getObjectsRootTree() {
        Object object = this.objectsRootTreeLock;
        synchronized (object) {
            return this.objectsRootTree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectsRootTree(TreeObject treeObject) {
        Object object = this.objectsRootTreeLock;
        synchronized (object) {
            this.objectsRootTree = treeObject;
        }
    }

    public boolean containsCLU(CLU cLU) {
        for (TreeObject treeObject : this.getAllCluObjectList(true, true)) {
            CLU cLU2 = R.a(treeObject);
            if (!cLU2.equals(cLU)) continue;
            return true;
        }
        return false;
    }

    protected void clearModel() {
    }

    public boolean isConfigurationExists() {
        return !this.getAllCluObjectList(true, true).isEmpty();
    }

    public TreeObject addCLU(CLU cLU) {
        TreeModel.getInstance().incrementSeqValue();
        int n2 = TreeModel.getInstance().getSeqValue();
        TreeObject treeObject = new TreeObject(n2, cLU.getName(), ObjectType.CLU);
        treeObject.setSpecificObject(cLU);
        if (TreeModel.getInstance().getRootTree() == null) {
            TreeModel.getInstance().createRootTree();
        }
        TreeModel.getInstance().addObject(treeObject);
        this.getObjectsRootTree().addChild(treeObject);
        treeObject.addChild(this.createScriptsObject());
        treeObject.addChild(this.createApplicationsObject());
        this.addIOsToCLU(cLU.getIOList(true), treeObject);
        return treeObject;
    }

    private TreeObject createApplicationsObject() {
        TreeModel.getInstance().incrementSeqValue();
        TreeObject treeObject = new TreeObject(TreeModel.getInstance().getSeqValue(), Messages.tree_lblApplications, ObjectType.APPLICATIONS_CONTAINER);
        return treeObject;
    }

    private TreeObject createScriptsObject() {
        TreeModel.getInstance().incrementSeqValue();
        TreeObject treeObject = new TreeObject(TreeModel.getInstance().getSeqValue(), Messages.tree_lblScripts, ObjectType.SCRIPT_CONTAINER);
        return treeObject;
    }

    public boolean setIOsToCLU(List<ModuleObject> list, TreeObject treeObject) {
        if (!list.isEmpty()) {
            treeObject.removeAllChildrenWithType(ObjectType.INPUT);
            treeObject.removeAllChildrenWithType(ObjectType.OUTPUT);
            treeObject.removeAllChildrenWithType(ObjectType.UNKNOWN_IO);
            this.addIOsToCLU(list, treeObject);
            return true;
        }
        return false;
    }

    public List<TreeObject> addIOsToCLU(List<ModuleObject> list, TreeObject treeObject) {
        LinkedList<TreeObject> linkedList = new LinkedList<TreeObject>();
        for (ModuleObject moduleObject : list) {
            TreeObject treeObject2 = this.getExistingObject(treeObject, moduleObject.getName());
            if (treeObject2 == null) {
                linkedList.add(this.createInputOutput(moduleObject, treeObject));
                continue;
            }
            linkedList.add(treeObject2);
        }
        return linkedList;
    }

    public TreeObject addModuleObjectToClu(CLU cLU, ModuleObject moduleObject) {
        TreeObject treeObject = TreeModel.getInstance().getTreeObjectsWithSpecificObject(cLU).get(0);
        TreeObject treeObject2 = this.getExistingObject(treeObject, moduleObject.getName());
        if (treeObject2 == null) {
            return this.createInputOutput(moduleObject, treeObject);
        }
        return treeObject2;
    }

    private TreeObject getExistingObject(TreeObject treeObject, String string) {
        List<TreeObject> list = treeObject.getChildren();
        if (list != null) {
            for (TreeObject treeObject2 : list) {
                if (treeObject2 == null || !this.isInputOutput(treeObject2) || !Objects.equal((Object)treeObject2.getName(), (Object)string)) continue;
                return treeObject2;
            }
        }
        return null;
    }

    private boolean isInputOutput(TreeObject treeObject) {
        ObjectType objectType = treeObject.getType();
        return objectType != null && (objectType == ObjectType.INPUT || objectType == ObjectType.OUTPUT || objectType == ObjectType.UNKNOWN_IO);
    }

    private TreeObject createInputOutput(ModuleObject moduleObject, TreeObject treeObject) {
        TreeModel.getInstance().incrementSeqValue();
        if (treeObject != null && treeObject.getType() == ObjectType.CLU) {
            CLU cLU = (CLU)treeObject.getSpecificObject();
            moduleObject.setClu(cLU);
        }
        ObjectType objectType = moduleObject instanceof Input ? ObjectType.INPUT : (moduleObject instanceof Output ? ObjectType.OUTPUT : ObjectType.UNKNOWN_IO);
        int n2 = TreeModel.getInstance().getSeqValue();
        TreeObject treeObject2 = new TreeObject(n2, moduleObject.getName(), objectType);
        TreeModel.getInstance().addObject(treeObject2);
        if (treeObject != null) {
            treeObject.addChild(treeObject2);
        } else {
            this.getObjectsRootTree().addChild(treeObject2);
        }
        treeObject2.setSpecificObject(moduleObject);
        return treeObject2;
    }

    public PeripheryCLU addPeripheryToCLU(String string, String string2, CLU cLU) throws UnsupportedCLUException {
        String string3;
        IfCluType ifCluType = CLUIOMInterface.getInstance().getClu(cLU);
        m m2 = ifCluType.f(string);
        PeripheryCLU peripheryCLU = PeripheryCLU.createEmptyPeripheryObject(m2);
        peripheryCLU.setClu(cLU);
        peripheryCLU.setName(string2);
        peripheryCLU.setTypeName(m2.e());
        peripheryCLU.setTypeId(m2.f());
        peripheryCLU.setTypeVersion(m2.h());
        while (cLU.getPeripheryByNameOnCLU(string3 = DeviceObjects.generateObjectName(cLU, peripheryCLU.getTypeName())) != null) {
        }
        peripheryCLU.setNameOnCLU(string3);
        DeviceObjects.updateFeaturesAndEvents(peripheryCLU, m2);
        cLU.addPeriphery(peripheryCLU);
        return peripheryCLU;
    }

    public PeripheryCLU createPeriphery(m m2, CLU cLU) {
        String string;
        PeripheryCLU peripheryCLU = PeripheryCLU.createEmptyPeripheryObject(m2);
        peripheryCLU.setClu(cLU);
        peripheryCLU.setTypeName(m2.e());
        peripheryCLU.setTypeId(m2.f());
        peripheryCLU.setTypeVersion(m2.h());
        while (cLU.getPeripheryByNameOnCLU(string = DeviceObjects.generateObjectName(cLU, peripheryCLU.getTypeName())) != null) {
        }
        peripheryCLU.setNameOnCLU(string);
        DeviceObjects.updateFeaturesAndEvents(peripheryCLU, m2);
        return peripheryCLU;
    }

    public PeripheryCLU createPeriphery(String string, CLU cLU) {
        IfCluType ifCluType;
        try {
            ifCluType = CLUIOMInterface.getInstance().getClu(cLU);
        }
        catch (UnsupportedCLUException unsupportedCLUException) {
            log.error((Object)("Failed to find interface for classId: " + string));
            return null;
        }
        m m2 = ifCluType.f(string);
        return this.createPeriphery(m2, cLU);
    }

    public TreeObject addPeripheryToCLUObject(String string, String string2, TreeObject treeObject) throws UnsupportedCLUException {
        CLU cLU = (CLU)treeObject.getSpecificObject();
        PeripheryCLU peripheryCLU = this.addPeripheryToCLU(string, string2, cLU);
        return ObjectManagerModel.getInstance().addPeriphery(peripheryCLU, treeObject);
    }

    public TreeObject addPeriphery(PeripheryCLU peripheryCLU, TreeObject treeObject) {
        TreeModel.getInstance().incrementSeqValue();
        ObjectType objectType = peripheryCLU instanceof HardwarePeripheryCLU ? ObjectType.HARDWARE_PERIPHERY : ObjectType.PROGRAMMABLE_PERIPHERY;
        int n2 = TreeModel.getInstance().getSeqValue();
        TreeObject treeObject2 = new TreeObject(n2, peripheryCLU.getName(), objectType);
        treeObject2.setSpecificObject(peripheryCLU);
        TreeModel.getInstance().addObject(treeObject2);
        treeObject.addChild(treeObject2);
        return treeObject2;
    }

    public TreeObject addApplicationToCLUObject(ApplicationInstance applicationInstance, TreeObject treeObject) {
        CLU cLU = (CLU)treeObject.getSpecificObject();
        TreeModel.getInstance().incrementSeqValue();
        int n2 = TreeModel.getInstance().getSeqValue();
        TreeObject treeObject2 = new TreeObject(n2, applicationInstance.getName(), ObjectType.APPLICATION);
        treeObject2.setSpecificObject(applicationInstance);
        TreeObject treeObject3 = ObjectManagerModel.getInstance().getCluObjectByName(cLU.getName());
        TreeObject treeObject4 = treeObject3.getFirstChildWithType(ObjectType.APPLICATIONS_CONTAINER);
        treeObject4.addChild(treeObject2);
        TreeModel.getInstance().addObject(treeObject2);
        return treeObject2;
    }

    private List<TreeObject> getLogicalCopy(List<TreeObject> list) {
        if (list != null) {
            ArrayList<TreeObject> arrayList = new ArrayList<TreeObject>();
            for (TreeObject treeObject : list) {
                arrayList.add(treeObject);
            }
            return arrayList;
        }
        return null;
    }

    public TreeObject createLinkToObject(TreeObject treeObject) {
        TreeObject treeObject2 = new TreeObject(treeObject.getId(), treeObject.getName(), treeObject.getType());
        treeObject2.setSpecificObject(treeObject.getSpecificObject());
        treeObject2.setLink(true);
        TreeModel.getInstance().addObjectLink(treeObject2);
        List<TreeObject> list = this.getLogicalCopy(treeObject.getChildren());
        treeObject2.addChildren(list);
        return treeObject2;
    }

    public TreeObject createContainer(String string, TreeObject treeObject) {
        if (TreeModel.getInstance().getRootTree() == null) {
            TreeModel.getInstance().createRootTree();
        }
        TreeModel.getInstance().incrementSeqValue();
        TreeObject treeObject2 = new TreeObject(TreeModel.getInstance().getSeqValue(), string, ObjectType.CONTAINER);
        TreeModel.getInstance().addObject(treeObject2);
        if (treeObject != null) {
            treeObject.addChild(treeObject2);
        } else {
            this.getObjectsRootTree().addChild(treeObject2);
        }
        treeObject2.setSpecificObject(new Container());
        return treeObject2;
    }

    @Override
    public List<TreeObject> getAllCluObjectList(boolean bl, boolean bl2) {
        return this.getAllCluObjectList(bl, bl2, false);
    }

    public List<TreeObject> getAllCluObjectList(boolean bl, boolean bl2, boolean bl3) {
        ArrayList<TreeObject> arrayList = new ArrayList<TreeObject>();
        for (TreeObject treeObject : TreeModel.getInstance().getTreeObjectList()) {
            if (treeObject.getType() != ObjectType.CLU || !bl && treeObject.isObjectOrParentRemoved()) continue;
            arrayList.add(treeObject);
        }
        if (bl3) {
            Collections.sort(arrayList, u.e);
        }
        return arrayList;
    }

    public List<CLU> getAllCluList(boolean bl) {
        LinkedList<CLU> linkedList = new LinkedList<CLU>();
        for (TreeObject treeObject : TreeModel.getInstance().getTreeObjectList()) {
            if (treeObject.getType() != ObjectType.CLU || !bl && treeObject.isObjectOrParentRemoved()) continue;
            linkedList.add((CLU)treeObject.getSpecificObject());
        }
        return linkedList;
    }

    public Set<CLU> getAllInactiveCluSet() {
        List<CLU> list = TreeModel.getInstance().getAllClu();
        HashSet<CLU> hashSet = new HashSet<CLU>();
        for (CLU cLU : list) {
            if (cLU.isRemoved() || cLU.isActive()) continue;
            hashSet.add(cLU);
        }
        return hashSet;
    }

    public Set<CLU> getAllCluSet() {
        List<CLU> list = TreeModel.getInstance().getAllClu();
        return new HashSet<CLU>(list);
    }

    public CLU getCluByIp(String string) {
        if (string == null) {
            log.error((Object)"Trying get CLU by null ip!");
            return null;
        }
        for (CLU cLU : this.getAllCluList(true)) {
            if (!string.equals(cLU.getIpAddress())) continue;
            return cLU;
        }
        return null;
    }

    public CLU getCluByName(String string) {
        if (string == null) {
            log.error((Object)"Trying get CLU by null name!");
            return null;
        }
        for (CLU cLU : this.getAllCluList(true)) {
            if (!string.equals(cLU.getName())) continue;
            return cLU;
        }
        return null;
    }

    public TreeObject getCluObjectByName(String string) {
        if (string == null) {
            log.error((Object)"Trying get CLU Object by null name!");
            return null;
        }
        for (TreeObject treeObject : TreeModel.getInstance().getTreeObjectList()) {
            if (treeObject.getType() != ObjectType.CLU || !string.equals(((CLU)treeObject.getSpecificObject()).getName())) continue;
            return treeObject;
        }
        return null;
    }

    public CLU getCluByNameOnCLU(String string) {
        if (string == null) {
            log.error((Object)"Trying get CLU by null name on clu!");
            return null;
        }
        for (CLU cLU : this.getAllCluList(true)) {
            if (!string.equals(cLU.getNameOnCLU())) continue;
            return cLU;
        }
        return null;
    }

    public CLU getCluBySerialNumber(long l2) {
        for (CLU cLU : this.getAllCluList(true)) {
            if (l2 != cLU.getSerialNumber()) continue;
            return cLU;
        }
        return null;
    }

    public Set<String> getCluIpSet() {
        HashSet<String> hashSet = new HashSet<String>();
        List<TreeObject> list = this.getAllCluObjectList(true, false);
        if (list != null) {
            for (TreeObject treeObject : list) {
                CLU cLU = R.a(treeObject);
                hashSet.add(cLU.getIpAddress());
            }
        }
        return hashSet;
    }

    public List<TreeObject> getInactiveCluList() {
        ArrayList<TreeObject> arrayList = new ArrayList<TreeObject>();
        for (TreeObject treeObject : TreeModel.getInstance().getTreeObjectList()) {
            CLU cLU;
            if (treeObject.getType() != ObjectType.CLU || (cLU = R.a(treeObject)).isActive()) continue;
            arrayList.add(treeObject);
        }
        return arrayList;
    }

    public List<TreeObject> getScriptMethodsForObject(TreeObject treeObject) {
        TreeObject treeObject2;
        ArrayList<TreeObject> arrayList = new ArrayList<TreeObject>();
        if (treeObject.getType() == ObjectType.CLU && (treeObject2 = treeObject.getFirstChildWithType(ObjectType.SCRIPT_CONTAINER)) != null) {
            for (TreeObject treeObject3 : treeObject2.getChildren()) {
                Script script = R.b(treeObject3);
                if (script.isRemoved()) continue;
                String string = treeObject3.getName();
                string = FilenameUtils.getBaseName((String)string);
                String string2 = String.valueOf(string) + c.a(script.getParameters());
                TreeObject treeObject4 = new TreeObject(-1, string2, ObjectType.SCRIPT);
                MethodSignature methodSignature = new MethodSignature();
                methodSignature.setName(string);
                methodSignature.setParameters(script.getParameters());
                methodSignature.setReturnType(null);
                treeObject4.setSpecificObject(methodSignature);
                arrayList.add(treeObject4);
            }
        }
        return arrayList;
    }

    public TreeObject getOwnerVisualScrptDiagram(VisualScriptDiagram visualScriptDiagram) {
        List<TreeObject> list = ObjectManagerModel.getInstance().getAllCluObjectList(false, false);
        for (TreeObject treeObject : list) {
            TreeObject treeObject2 = treeObject.getFirstChildWithType(ObjectType.SCRIPT_CONTAINER);
            for (TreeObject treeObject3 : treeObject2.getChildren()) {
                Script script = (Script)treeObject3.getSpecificObject();
                if (script.getDiagram() != visualScriptDiagram) continue;
                return treeObject3;
            }
        }
        log.error((Object)"Not found object of script, who contain diagram");
        return null;
    }

    public TreeObject getModuleTreeObject(ModuleObject moduleObject) {
        List<TreeObject> list = ObjectManagerModel.getInstance().getAllCluObjectList(false, false);
        for (TreeObject treeObject : list) {
            for (TreeObject treeObject2 : treeObject.getChildren()) {
                ISpecificTreeObject iSpecificTreeObject = treeObject2.getSpecificObject();
                if (iSpecificTreeObject != moduleObject) continue;
                return treeObject2;
            }
        }
        log.error((Object)"Not found object of module");
        return null;
    }

    public TreeObject getCluTreeObject(CLU cLU) {
        List<TreeObject> list = ObjectManagerModel.getInstance().getAllCluObjectList(false, false);
        for (TreeObject treeObject : list) {
            ISpecificTreeObject iSpecificTreeObject = treeObject.getSpecificObject();
            if (iSpecificTreeObject != cLU) continue;
            return treeObject;
        }
        log.error((Object)"Not found object of CLU");
        return null;
    }

    public VisualScriptDiagram getVisualScriptFromFile(String string) {
        VisualScriptDiagram visualScriptDiagram;
        block15: {
            IPath iPath = TreeModel.getInstance().getProject().getFile(string).getRawLocation();
            File file = iPath.toFile();
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    if (file.length() == 0L) {
                        visualScriptDiagram = new VisualScriptDiagram();
                        break block15;
                    }
                    objectInputStream = new ObjectInputStream(FileUtils.openInputStream((File)file));
                    visualScriptDiagram = (VisualScriptDiagram)objectInputStream.readObject();
                }
                catch (Exception exception) {
                    visualScriptDiagram = s.b(file);
                    if (visualScriptDiagram == null) {
                        log.error((Object)"Error on reading visual diagram", (Throwable)exception);
                    }
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        log.warn((Object)"Error while closing ObjectInputStream after reading script diagram from file", (Throwable)iOException);
                    }
                }
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    log.warn((Object)"Error while closing ObjectInputStream after reading script diagram from file", (Throwable)iOException);
                }
            }
        }
        return visualScriptDiagram;
    }

    public TreeObject createScript(String string, CLU cLU, TreeObject treeObject) {
        TreeModel.getInstance().incrementSeqValue();
        TreeObject treeObject2 = new TreeObject(TreeModel.getInstance().getSeqValue(), string, ObjectType.SCRIPT);
        Script script = new Script();
        script.setName(string);
        treeObject2.setSpecificObject(script);
        TreeModel.getInstance().addObject(treeObject2);
        cLU.addScript(script);
        treeObject.addChild(treeObject2);
        log.debug((Object)String.format("Creating script: %s on %s", script.getName(), cLU.getName()));
        return treeObject2;
    }

    protected void removeScript(TreeObject treeObject) {
        CLU cLU = (CLU)treeObject.getParent().getParent().getSpecificObject();
        Script script = (Script)treeObject.getSpecificObject();
        cLU.removeScript(script);
        int n2 = cLU.getScripts(true).size();
        cLU.removeScript(cLU.getScriptByName(script.getName()));
        if (n2 != cLU.getScripts(true).size()) {
            log.debug((Object)String.format("Removed twos instance duplicated scripts: %s on %s", script.getName(), cLU.getName()));
        }
    }

    protected void removePeriphery(TreeObject treeObject) {
        PeripheryCLU peripheryCLU = (PeripheryCLU)treeObject.getSpecificObject();
        peripheryCLU.getClu().removePeriphery(peripheryCLU);
    }

    protected void removeApplication(TreeObject treeObject) {
        ApplicationInstance applicationInstance = (ApplicationInstance)treeObject.getSpecificObject();
        applicationInstance.getClu().removeApplication(applicationInstance);
    }

    protected void removeIO(TreeObject treeObject) {
        ModuleObject moduleObject = (ModuleObject)treeObject.getSpecificObject();
        moduleObject.getClu().removeIO(moduleObject);
    }

    public boolean checkValidConfigurationOnCLU(CLU cLU) {
        String string;
        boolean bl;
        block24: {
            bl = true;
            LinkedList<String> linkedList = new LinkedList<String>();
            LinkedList<String> linkedList2 = new LinkedList<String>();
            LinkedList<String> linkedList3 = new LinkedList<String>();
            string = Messages.message_unknownerror_lblTitle;
            TreeObject treeObject = null;
            if (d.e() != null && d.e().getEditorInput() instanceof com.grenton.om.editors.b.a) {
                IEditorPart object22 = d.e();
                com.grenton.om.editors.b.a a2 = (com.grenton.om.editors.b.a)object22.getEditorInput();
                treeObject = a2.a();
            }
            try {
                for (Event event : cLU.getEvents()) {
                    for (String string2 : event.getCommands()) {
                        string = String.format(Messages.tree_tooltipWrongCommandInEvent, string2, cLU.getName(), event.getName());
                        OMLtoLUA.a(new OMLCommand(string2), cLU);
                    }
                }
                h h2 = new h(cLU);
                for (Script script : cLU.getScripts(false)) {
                    boolean bl2;
                    boolean bl3 = bl2 = treeObject != null && treeObject.getSpecificObject() == script;
                    if (!script.isManualEdit() && !bl2) {
                        com.grenton.scriptbuilder.e.a a3 = new com.grenton.scriptbuilder.e.a();
                        String string3 = a3.b(script.getDiagram());
                        if (string3 != null) continue;
                        g g2 = new g(cLU, script);
                        string = g2.getMessage();
                        throw g2;
                    }
                    try {
                        if (!script.isValid() && script.getDiagram() == null) {
                            cLU.removeScript(script);
                            log.error((Object)String.format("Invalid script %s. Null content. Script will be removed from CLU.", script.getName()));
                            continue;
                        }
                        h2.a(script.getContent(), script.getParameters());
                    }
                    catch (IncorrectCluCommandException incorrectCluCommandException) {
                        string = String.format(Messages.tree_tooltipWrongCommandInScript, incorrectCluCommandException.a(), cLU.getName(), "->", script.getName());
                        throw incorrectCluCommandException;
                    }
                    catch (e e2) {
                        string = String.format(Messages.message_error_invalidCommandContainingInactiveModuleInCondition, e2.a(), cLU.getName(), "->", script.getName());
                        throw e2;
                    }
                }
                for (ModuleObject moduleObject : cLU.getIOList(false)) {
                    for (Event event : moduleObject.getEvents()) {
                        for (String string3 : event.getCommands()) {
                            string = String.format(Messages.tree_tooltipWrongCommandInEvent, string3, moduleObject.getAccessPath(), event.getName());
                            OMLtoLUA.a(new OMLCommand(string3), cLU);
                        }
                    }
                }
                for (PeripheryCLU peripheryCLU : cLU.getPeripheryList(false)) {
                    for (Event event : peripheryCLU.getEvents()) {
                        for (String string3 : event.getCommands()) {
                            string = String.format(Messages.tree_tooltipWrongCommandInEvent, string3, peripheryCLU.getAccessPath(), event.getName());
                            OMLtoLUA.a(new OMLCommand(string3), cLU);
                        }
                    }
                }
                try {
                    string = Messages.tree_tooltipUnknownErrorWhileGenerateLUAConfiguration;
                    FilesGeneratorFacade.a(cLU, linkedList, linkedList2, linkedList3);
                    String string4 = FilesGeneratorFacade.b(cLU);
                    cLU.setConfigurationWaringMessage(string4);
                }
                catch (UnsupportedNameInInterfacesBase | j exception) {
                    string = exception.getMessage();
                    throw exception;
                }
                catch (Exception exception) {
                    if (exception.getMessage() != null) {
                        string = exception.getMessage();
                    }
                    throw exception;
                }
                for (ApplicationInstance applicationInstance : cLU.getApplicationsList(false)) {
                    if (b.b(applicationInstance)) continue;
                    string = String.format(Messages.tree_tooltipWrongInitializedApplication, applicationInstance.getAccessPath());
                    bl = false;
                    break;
                }
            }
            catch (Exception exception) {
                log.error((Object)"Exception during validation CLU configuration", (Throwable)exception);
                if (string.equals(Messages.message_unknownerror_lblTitle)) break block24;
                bl = false;
            }
        }
        if (!bl) {
            cLU.setConfigurationErrorMessage(string);
        }
        if (cLU.isValidConfigurationOnCLU() != bl) {
            cLU.setValidConfigurationOnCLU(bl);
        }
        return cLU.isValidConfigurationOnCLU();
    }

    public void translateLUAToOMLOnEveryCLU() {
        for (TreeObject treeObject : this.getAllCluObjectList(true, false)) {
            LUAtoOML lUAtoOML;
            LinkedList<String> linkedList;
            Object object2;
            CLU cLU = (CLU)treeObject.getSpecificObject();
            for (Event event : cLU.getEvents()) {
                object2 = new LinkedList<String>();
                for (String string : event.getCommands()) {
                    LUAtoOML lUAtoOML2 = new LUAtoOML(string, cLU);
                    object2.add((String)lUAtoOML2.translate());
                }
                event.setCommands((List<String>)object2);
            }
            for (ModuleObject moduleObject : cLU.getIOList(true)) {
                for (Object object2 : moduleObject.getEvents()) {
                    linkedList = new LinkedList();
                    for (String string : ((Event)object2).getCommands()) {
                        lUAtoOML = new LUAtoOML(string, cLU);
                        linkedList.add(lUAtoOML.translate());
                    }
                    ((Event)object2).setCommands(linkedList);
                }
            }
            for (PeripheryCLU peripheryCLU : cLU.getPeripheryList(true)) {
                for (Object object2 : peripheryCLU.getEvents()) {
                    linkedList = new LinkedList<String>();
                    for (String string : ((Event)object2).getCommands()) {
                        lUAtoOML = new LUAtoOML(string, cLU);
                        linkedList.add(lUAtoOML.translate());
                    }
                    ((Event)object2).setCommands(linkedList);
                }
            }
            for (Script script : cLU.getScripts(true)) {
                if (!script.isManualEdit()) continue;
                object2 = a.a(cLU, new StringBuilder(script.getContent()));
                script.setContent((String)object2);
            }
        }
    }

    public CLU getParentCLU(ISpecificTreeObject iSpecificTreeObject) {
        if (iSpecificTreeObject instanceof CLU) {
            return (CLU)iSpecificTreeObject;
        }
        if (iSpecificTreeObject instanceof Script) {
            for (CLU cLU : this.getAllCluList(true)) {
                for (Script script : cLU.getScripts(true)) {
                    if (script != iSpecificTreeObject) continue;
                    return cLU;
                }
            }
        } else if (iSpecificTreeObject instanceof Event) {
            for (CLU cLU : this.getAllCluList(true)) {
                LinkedList<IDeviceObject> linkedList = new LinkedList<IDeviceObject>();
                linkedList.add(cLU);
                for (ISpecificTreeObject iSpecificTreeObject2 : cLU.getCluObjects(true)) {
                    linkedList.add((IDeviceObject)((Object)iSpecificTreeObject2));
                }
                for (IDeviceObject iDeviceObject : linkedList) {
                    for (Event event : iDeviceObject.getEvents()) {
                        if (event != iSpecificTreeObject) continue;
                        return cLU;
                    }
                }
            }
        } else {
            if (iSpecificTreeObject instanceof PeripheryCLU) {
                return ((PeripheryCLU)iSpecificTreeObject).getClu();
            }
            if (iSpecificTreeObject instanceof ModuleObject) {
                return ((ModuleObject)iSpecificTreeObject).getClu();
            }
        }
        return null;
    }

    public List<ModuleObject> getAllModuleObjects() {
        LinkedList<ModuleObject> linkedList = new LinkedList<ModuleObject>();
        List<CLU> list = TreeModel.getInstance().getAllClu();
        for (CLU cLU : list) {
            List<ModuleObject> list2 = cLU.getIOList(false);
            for (ModuleObject moduleObject : list2) {
                linkedList.add(moduleObject);
            }
        }
        return linkedList;
    }

    public Set<ModuleObject> getAllInactiveModuleObjects() {
        HashSet<ModuleObject> hashSet = new HashSet<ModuleObject>();
        List<CLU> list = TreeModel.getInstance().getAllClu();
        for (CLU cLU : list) {
            List<ModuleObject> list2 = cLU.getIOList(false);
            for (ModuleObject moduleObject : list2) {
                if (moduleObject.isActive()) continue;
                hashSet.add(moduleObject);
            }
        }
        return hashSet;
    }

    public Set<ModuleObject> getAllModuleObjectsConsideredAsInactive() {
        HashSet<ModuleObject> hashSet = new HashSet<ModuleObject>();
        List<CLU> list = TreeModel.getInstance().getAllClu();
        for (CLU cLU : list) {
            List<ModuleObject> list2 = cLU.getIOList(false);
            if (!cLU.isActive()) {
                hashSet.addAll(list2);
                continue;
            }
            for (ModuleObject moduleObject : list2) {
                if (moduleObject.isActive()) continue;
                hashSet.add(moduleObject);
            }
        }
        return hashSet;
    }

    public ModuleObject getIoByName(String string) {
        for (ModuleObject moduleObject : this.getAllModuleObjects()) {
            if (!StringUtils.equals((CharSequence)moduleObject.getName(), (CharSequence)string)) continue;
            return moduleObject;
        }
        return null;
    }

    public ModuleObject getIoByNameOnClu(String string) {
        for (ModuleObject moduleObject : this.getAllModuleObjects()) {
            if (!StringUtils.equals((CharSequence)moduleObject.getNameOnCLU(), (CharSequence)string)) continue;
            return moduleObject;
        }
        return null;
    }

    public List<PeripheryCLU> getAllPeriphery() {
        LinkedList<PeripheryCLU> linkedList = new LinkedList<PeripheryCLU>();
        List<CLU> list = TreeModel.getInstance().getAllClu();
        for (CLU cLU : list) {
            linkedList.addAll(cLU.getPeripheryList(false));
        }
        return linkedList;
    }

    public List<PeripheryCLU> getAllPeripheryByType(PeripheryObjects peripheryObjects) {
        LinkedList<PeripheryCLU> linkedList = new LinkedList<PeripheryCLU>();
        for (PeripheryCLU peripheryCLU : this.getAllPeriphery()) {
            if (!peripheryCLU.getTypeName().equalsIgnoreCase(peripheryObjects.name())) continue;
            linkedList.add(peripheryCLU);
        }
        return linkedList;
    }

    public PeripheryCLU getPeripheryByAccessPath(String string) {
        for (PeripheryCLU peripheryCLU : this.getAllPeriphery()) {
            if (!peripheryCLU.getAccessPath().equalsIgnoreCase(string)) continue;
            return peripheryCLU;
        }
        return null;
    }

    public List<ModuleObject> getAllSourceModulesForThermostat(CLU cLU) {
        LinkedList<ModuleObject> linkedList = new LinkedList<ModuleObject>();
        for (ModuleObject moduleObject : this.getAllModuleObjects()) {
            if (!moduleObject.getClu().equals(cLU) || !"12".equals(moduleObject.getTypeId()) && !"20".equals(moduleObject.getTypeId()) && !"23".equals(moduleObject.getTypeId())) continue;
            linkedList.add(moduleObject);
        }
        Collections.sort(linkedList, u.a);
        return linkedList;
    }

    public List<ModuleObject> getAllControlModulesForThermostat() {
        LinkedList<ModuleObject> linkedList = new LinkedList<ModuleObject>();
        for (ModuleObject moduleObject : this.getAllModuleObjects()) {
            if (!"4".equals(moduleObject.getTypeId()) && !"13".equals(moduleObject.getTypeId()) && !"5".equals(moduleObject.getTypeId()) && !"52".equals(moduleObject.getTypeId()) && !"60".equals(moduleObject.getTypeId())) continue;
            linkedList.add(moduleObject);
        }
        Collections.sort(linkedList, u.b);
        return linkedList;
    }

    public List<ModuleObject> getIOByModuleIdAndType(long l2, String string) {
        LinkedList<ModuleObject> linkedList = new LinkedList<ModuleObject>();
        for (ModuleObject moduleObject : this.getAllModuleObjects()) {
            ModuleDevice moduleDevice = moduleObject.getModule();
            if (moduleDevice.getSerialNumber() != l2 || !moduleObject.getTypeName().equals(string)) continue;
            linkedList.add(moduleObject);
        }
        return linkedList;
    }

    public PeripheryCLU getPeripheryByName(String string) {
        for (PeripheryCLU peripheryCLU : this.getAllPeriphery()) {
            if (!StringUtils.equals((CharSequence)peripheryCLU.getName(), (CharSequence)string)) continue;
            return peripheryCLU;
        }
        return null;
    }
}

