/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model.service;

import com.grenton.om.commands.c.a;
import com.grenton.om.model.RecentProject;
import com.grenton.om.r;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;

public class RecentProjectsManager {
    private static final String REGEX_PROJECT_LINE = "^[(A-Za-z0-9_-|\\[|\\])]+[ \t]*=[ \t]*[(A-Za-z0-9_|\\-|\\\\|\\[|\\]|\\:|\\.|\\/)]+[( A-Za-z0-9_|\\-|\\\\|\\[|\\]|\\:|\\.|\\/)]+$";
    private LinkedList<RecentProject> recentProjects;
    private static RecentProjectsManager lastProjectsManager;
    private static Logger log;

    static {
        log = Logger.getLogger(RecentProjectsManager.class);
    }

    private RecentProjectsManager() {
    }

    public static synchronized RecentProjectsManager getInstance() {
        if (lastProjectsManager == null) {
            lastProjectsManager = new RecentProjectsManager();
        }
        return lastProjectsManager;
    }

    private void readRecentProjects() {
        String string;
        block17: {
            this.recentProjects = new LinkedList();
            BufferedReader bufferedReader = null;
            try {
                try {
                    IPath object = r.i().append("recent_projects.properties");
                    File file = object.toFile();
                    if (file.exists()) {
                        bufferedReader = new BufferedReader(new FileReader(file.toString()));
                        while ((string = bufferedReader.readLine()) != null) {
                            Pattern pattern = Pattern.compile(REGEX_PROJECT_LINE);
                            Matcher matcher = pattern.matcher(string);
                            if (!matcher.find()) continue;
                            this.addRecentProject(string);
                        }
                    }
                }
                catch (IOException iOException) {
                    log.error((Object)"Error while loading file with last opened projects: ", (Throwable)iOException);
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block17;
                    }
                    catch (IOException iOException2) {
                        log.warn((Object)"Error while closing BufferedReader after reading recent projects from file", (Throwable)iOException2);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    log.warn((Object)"Error while closing BufferedReader after reading recent projects from file", (Throwable)iOException);
                }
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                log.warn((Object)"Error while closing BufferedReader after reading recent projects from file", (Throwable)iOException);
            }
        }
        for (File file : com.grenton.om.utils.f.a.b()) {
            string = String.format("%s=%s", FilenameUtils.getBaseName((String)file.getName()), file.getPath());
            this.addRecentProject(string);
        }
    }

    private void addRecentProject(String string) {
        String string2 = string.split("=")[0].trim();
        String string3 = string.split("=")[1].trim().replace("\\\\", "\\");
        if (a.b(string3)) {
            return;
        }
        if (!new File(string3).exists()) {
            return;
        }
        for (RecentProject recentProject : this.recentProjects) {
            if (!recentProject.getName().equals(string2) || !recentProject.getPath().equals(string3)) continue;
            return;
        }
        this.recentProjects.add(new RecentProject(string));
    }

    private void saveRecentProjects() {
        FilterOutputStream filterOutputStream = null;
        try {
            try {
                IPath iPath = r.i().append("recent_projects.properties");
                File file = iPath.toFile();
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                for (RecentProject recentProject : this.recentProjects) {
                    String string = System.getProperty("line.separator");
                    filterOutputStream.write(new String(recentProject + string).replace("\\", "\\\\").getBytes());
                }
                ((BufferedOutputStream)filterOutputStream).flush();
            }
            catch (IOException iOException) {
                log.error((Object)"Error while saving file with last opened projects: ", (Throwable)iOException);
                try {
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    log.warn((Object)"Error while closing BufferedOutputStream after saveing recent projects list to file", (Throwable)iOException2);
                }
            }
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                log.warn((Object)"Error while closing BufferedOutputStream after saveing recent projects list to file", (Throwable)iOException);
            }
        }
    }

    protected void addProject(String string, String string2) {
        RecentProject recentProject;
        if (a.b(string2)) {
            return;
        }
        if (this.recentProjects == null) {
            this.readRecentProjects();
        }
        if (this.recentProjects.contains(recentProject = new RecentProject(string, string2))) {
            this.recentProjects.remove(recentProject);
        }
        this.recentProjects.addFirst(recentProject);
        this.saveRecentProjects();
    }

    public void removeProjectFromListByName(String string) {
        for (RecentProject recentProject : this.recentProjects) {
            if (!recentProject.getName().equals(string)) continue;
            this.recentProjects.remove(recentProject);
            break;
        }
        this.saveRecentProjects();
    }

    public List<RecentProject> getRecentProjects() {
        if (this.recentProjects == null) {
            this.readRecentProjects();
        }
        return this.recentProjects;
    }
}

