/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model.service;

import com.grenton.Messages;
import com.grenton.om.cipher.CipherKey;
import com.grenton.om.dialogs.customs.i;
import com.grenton.om.dialogs.customs.n;
import com.grenton.om.model.CLU;
import com.grenton.om.model.PeripheryCLU;
import com.grenton.om.model.ProjectProperties;
import com.grenton.om.model.TreeObject;
import com.grenton.om.model.interfaces.IDeviceObject;
import com.grenton.om.model.interfaces.ISpecificTreeObject;
import com.grenton.om.model.iomodules.ModuleObject;
import com.grenton.om.model.service.ObjectManagerModel;
import com.grenton.om.model.service.RecentProjectsManager;
import com.grenton.om.model.types.ObjectType;
import com.grenton.om.r;
import com.grenton.om.utils.R;
import com.grenton.om.utils.S;
import com.grenton.om.utils.b.e;
import com.grenton.om.utils.f.d;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;

public class TreeModel {
    public static final int FAKE_TREE_OBJECT_ID = -1;
    private static final String ENCODING = "UTF-8";
    private final Map<Integer, TreeObject> treeObjectMap = new ConcurrentHashMap<Integer, TreeObject>();
    private final Map<Integer, Set<TreeObject>> treeObjectLinkMap = new ConcurrentHashMap<Integer, Set<TreeObject>>();
    private ProjectProperties projectProperties = new ProjectProperties();
    private final ObjectManagerModel objectManagerModel = ObjectManagerModel.getInstance();
    private static TreeModel treeModel;
    private TreeObject rootTree;
    private TreeObject objectsRootTree;
    private TreeObject myGrentonInterfacesRootTree;
    private int lastSeqValue;
    private boolean treeSaved;
    private IProject project;
    private File originProjectFilePath;
    private Long lastCloudSync;
    private static Logger log;

    static {
        log = Logger.getLogger(TreeModel.class);
    }

    private TreeModel() {
    }

    public static synchronized TreeModel getInstance() {
        if (treeModel == null) {
            treeModel = new TreeModel();
        }
        return treeModel;
    }

    public synchronized void removeAll() {
        this.lastSeqValue = -1;
        this.treeObjectLinkMap.clear();
        this.treeObjectMap.clear();
        this.rootTree = this.createRootTree();
    }

    public synchronized TreeObject getObjectsRootTree() {
        return this.objectsRootTree;
    }

    public synchronized TreeObject getMyGrentonInterfacesRootTree() {
        return this.myGrentonInterfacesRootTree;
    }

    public synchronized TreeObject getRootTree() {
        return this.rootTree;
    }

    public synchronized Long getLastCloudSync() {
        return this.lastCloudSync;
    }

    public synchronized void setLastCloudSync(Long l2) {
        this.lastCloudSync = l2;
    }

    public synchronized TreeObject createRootTree() {
        this.incrementSeqValue();
        this.rootTree = new TreeObject(this.lastSeqValue, Messages.tree_lblSystem, ObjectType.CONTAINER);
        this.treeObjectMap.put(this.rootTree.getId(), this.rootTree);
        this.incrementSeqValue();
        this.objectsRootTree = new TreeObject(this.lastSeqValue, "Object Manager", ObjectType.OBJECT_MANAGER);
        this.treeObjectMap.put(this.objectsRootTree.getId(), this.objectsRootTree);
        this.rootTree.addChild(this.objectsRootTree);
        if (r.m()) {
            this.myGrentonInterfacesRootTree = this.createMobileInterfacesNode();
        }
        this.objectManagerModel.setObjectsRootTree(this.objectsRootTree);
        return this.rootTree;
    }

    private synchronized TreeObject createMobileInterfacesNode() {
        TreeObject treeObject = new TreeObject(this.incrementSeqValue(), "myGrenton", ObjectType.MYGRENTON_INTERFACES);
        this.treeObjectMap.put(treeObject.getId(), treeObject);
        this.rootTree.addChild(treeObject);
        return treeObject;
    }

    public synchronized int incrementSeqValue() {
        do {
            ++this.lastSeqValue;
        } while (this.treeObjectMap.containsKey(this.lastSeqValue));
        return this.lastSeqValue;
    }

    public synchronized int getSeqValue() {
        return this.lastSeqValue;
    }

    public synchronized void addObject(TreeObject treeObject) {
        if (this.treeObjectMap.containsKey(treeObject.getId())) {
            log.error((Object)"Detected object on the tree with the same ID. Will be assigned a new ID.");
            try {
                this.incrementSeqValue();
                Class<?> clazz = treeObject.getClass();
                Field field = clazz.getDeclaredField("id");
                field.setAccessible(true);
                field.set(treeObject, this.getSeqValue());
            }
            catch (Exception exception) {
                log.error((Object)"Can't assign new ID to the object.", (Throwable)exception);
            }
        }
        this.treeObjectMap.put(treeObject.getId(), treeObject);
    }

    protected synchronized void addObjectLink(TreeObject treeObject) {
        if (!this.treeObjectLinkMap.containsKey(treeObject.getId())) {
            this.treeObjectLinkMap.put(treeObject.getId(), new HashSet());
        }
        this.treeObjectLinkMap.get(treeObject.getId()).add(treeObject);
    }

    public synchronized TreeObject getTreeObjectById(Integer n2) {
        this.flatTree();
        if (n2 != null) {
            return this.treeObjectMap.get(n2);
        }
        return null;
    }

    public synchronized TreeObject getLinkedObject(TreeObject treeObject) {
        if (!treeObject.isLink()) {
            return null;
        }
        for (Integer n3 : this.treeObjectLinkMap.keySet()) {
            if (!this.treeObjectLinkMap.get(n3).stream().map(TreeObject::getId).anyMatch(n2 -> Objects.equals(n2, treeObject.getId()))) continue;
            return this.getTreeObjectById(n3);
        }
        return null;
    }

    public synchronized List<TreeObject> getTreeObjectsWithSpecificObject(ISpecificTreeObject iSpecificTreeObject) {
        this.flatTree();
        LinkedList<TreeObject> linkedList = new LinkedList<TreeObject>();
        for (Map.Entry<Integer, TreeObject> entry : this.treeObjectMap.entrySet()) {
            if (iSpecificTreeObject != entry.getValue().getSpecificObject()) continue;
            linkedList.add(entry.getValue());
        }
        return linkedList;
    }

    public synchronized boolean isProjectSaved() {
        return this.isTreeSaved() && this.getProject() != null && this.getProject().exists();
    }

    public synchronized boolean isTreeSaved() {
        return this.treeSaved;
    }

    public synchronized void setTreeSaved(boolean bl) {
        for (TreeObject treeObject : ObjectManagerModel.getInstance().getAllCluObjectList(false, false)) {
            CLU cLU = (CLU)treeObject.getSpecificObject();
            ObjectManagerModel.getInstance().checkValidConfigurationOnCLU(cLU);
        }
        this.treeSaved = bl;
    }

    public synchronized void reloadTree(File file, IWorkbenchWindow iWorkbenchWindow) throws IOException, ClassNotFoundException, ConversionException {
        this.myGrentonInterfacesRootTree = null;
        this.rootTree = (TreeObject)e.a(file);
        for (TreeObject treeObject : this.rootTree.getChildren()) {
            if (treeObject.getType() == ObjectType.VISUAL_BUILDER) {
                if (!treeObject.hasChildren()) continue;
                Display.getDefault().asyncExec(() -> {
                    int n2 = new n(iWorkbenchWindow.getShell(), Messages.common_lblWarning, Messages.vb_detected_warning, Messages.vb_detected_checkbox_lbl).open();
                });
                continue;
            }
            if (treeObject.getType() == ObjectType.OBJECT_MANAGER) {
                this.objectsRootTree = treeObject;
                this.objectManagerModel.setObjectsRootTree(this.objectsRootTree);
                continue;
            }
            if (treeObject.getType() != ObjectType.MYGRENTON_INTERFACES) continue;
            this.myGrentonInterfacesRootTree = treeObject;
        }
        this.rootTree.removeAllChildrenWithType(ObjectType.VISUAL_BUILDER);
        if (this.myGrentonInterfacesRootTree == null && r.m()) {
            this.myGrentonInterfacesRootTree = this.createMobileInterfacesNode();
        }
        this.lastSeqValue = -1;
        this.flatTree();
    }

    public synchronized void clearModels() {
        this.treeObjectMap.clear();
        this.objectManagerModel.clearModel();
        this.treeObjectLinkMap.clear();
    }

    public synchronized Collection<TreeObject> getTreeObjectList() {
        return this.treeObjectMap.values();
    }

    private synchronized void flatTree() {
        this.clearModels();
        LinkedList<TreeObject> linkedList = new LinkedList<TreeObject>();
        if (this.rootTree != null) {
            linkedList.add(this.rootTree);
            this.checkAndUpdateLastSeqValue(this.rootTree.getId());
            while (!linkedList.isEmpty()) {
                TreeObject treeObject = (TreeObject)linkedList.remove();
                this.checkAndUpdateLastSeqValue(treeObject.getId());
                if (!S.o(treeObject)) {
                    if (treeObject.isLink()) {
                        this.addObjectLink(treeObject);
                    } else {
                        this.addObject(treeObject);
                    }
                }
                if (!treeObject.hasChildren()) continue;
                linkedList.addAll(treeObject.getChildren());
            }
        }
    }

    private synchronized void checkAndUpdateLastSeqValue(int n2) {
        if (this.lastSeqValue == -1) {
            this.lastSeqValue = n2;
        } else if (n2 > this.lastSeqValue) {
            this.lastSeqValue = n2;
        }
    }

    public synchronized Set<TreeObject> removeObject(TreeObject treeObject) {
        this.flatTree();
        HashSet<TreeObject> hashSet = new HashSet<TreeObject>();
        if (treeObject.isLink()) {
            this.removeObjectLink(treeObject);
        } else {
            HashSet<TreeObject> hashSet2 = new HashSet<TreeObject>();
            this.listObjectsRecursively(treeObject, hashSet2);
            for (TreeObject treeObject2 : hashSet2) {
                if (this.treeObjectMap.containsKey(treeObject2.getId())) {
                    this.treeObjectMap.remove(treeObject2.getId());
                    if (!treeObject2.isLink()) {
                        hashSet.add(treeObject2);
                    }
                }
                switch (treeObject2.getType()) {
                    case CLU: {
                        break;
                    }
                    case SCRIPT: {
                        this.objectManagerModel.removeScript(treeObject2);
                        break;
                    }
                    case INPUT: 
                    case OUTPUT: 
                    case UNKNOWN_IO: {
                        if (treeObject2.isLink()) break;
                        this.objectManagerModel.removeIO(treeObject2);
                        if (!this.treeObjectLinkMap.containsKey(treeObject2.getId())) break;
                        Set<TreeObject> set = this.treeObjectLinkMap.get(treeObject2.getId());
                        if (set != null) {
                            for (TreeObject treeObject3 : set) {
                                this.removeObjectLinkWithoutMapUpdate(treeObject3);
                            }
                            set.clear();
                        }
                        this.treeObjectLinkMap.remove(treeObject2.getId());
                        break;
                    }
                    case PROGRAMMABLE_PERIPHERY: 
                    case HARDWARE_PERIPHERY: {
                        this.objectManagerModel.removePeriphery(treeObject2);
                        break;
                    }
                    case APPLICATION: {
                        this.objectManagerModel.removeApplication(treeObject2);
                        break;
                    }
                }
            }
            if (treeObject.getParent() != null) {
                treeObject.getParent().removeChild(treeObject);
            }
        }
        return hashSet;
    }

    private synchronized void listObjectsRecursively(TreeObject treeObject, Set<TreeObject> set) {
        set.add(treeObject);
        for (TreeObject treeObject2 : treeObject.getChildren()) {
            this.listObjectsRecursively(treeObject2, set);
        }
    }

    private synchronized void removeObjectLinkWithoutMapUpdate(TreeObject treeObject) {
        treeObject.getParent().removeChild(treeObject);
    }

    private synchronized void removeObjectLink(TreeObject treeObject) {
        Set<TreeObject> set;
        if (treeObject.isLink() && (set = this.treeObjectLinkMap.get(treeObject.getId())) != null) {
            Iterator<TreeObject> iterator = set.iterator();
            while (iterator.hasNext()) {
                TreeObject treeObject2 = iterator.next();
                if (!treeObject2.getParent().equals(treeObject.getParent())) continue;
                iterator.remove();
                this.removeObjectLinkWithoutMapUpdate(treeObject);
                break;
            }
            if (set.size() == 0) {
                this.treeObjectLinkMap.remove(treeObject.getId());
            }
        }
    }

    public synchronized IProject getProject() {
        return this.project;
    }

    public synchronized void setProject(IProject iProject, File file) {
        this.project = iProject;
        this.originProjectFilePath = file;
        RecentProjectsManager.getInstance().addProject(iProject.getName(), file.getPath());
    }

    public synchronized File getOriginProjectFilePath() {
        return this.originProjectFilePath;
    }

    public synchronized TreeObject getObjectByName(String string, ObjectType objectType) {
        this.flatTree();
        for (TreeObject treeObject : this.treeObjectMap.values()) {
            if (treeObject.getType() != objectType || !treeObject.getName().equals(string)) continue;
            return treeObject;
        }
        return null;
    }

    public synchronized List<TreeObject> getObjectsWithType(ObjectType objectType) {
        LinkedList<TreeObject> linkedList = new LinkedList<TreeObject>();
        for (TreeObject treeObject : this.treeObjectMap.values()) {
            if (treeObject.getType() != objectType || treeObject.isRemoved()) continue;
            linkedList.add(treeObject);
        }
        return linkedList;
    }

    public synchronized TreeObject getObjectByName(String string) {
        this.flatTree();
        for (TreeObject treeObject : this.treeObjectMap.values()) {
            if (!treeObject.getName().equals(string)) continue;
            return treeObject;
        }
        return null;
    }

    public synchronized TreeObject getObjectByNameAndCluSerialNumberAndNameOnClu(String string, Long l2, String string2) {
        this.flatTree();
        for (TreeObject treeObject : this.treeObjectMap.values()) {
            IDeviceObject iDeviceObject;
            ISpecificTreeObject iSpecificTreeObject;
            if (!treeObject.getName().equals(string) || !((iSpecificTreeObject = treeObject.getSpecificObject()) instanceof CLU ? ((CLU)(iDeviceObject = (CLU)iSpecificTreeObject)).getSerialNumber().equals(l2) && ((CLU)iDeviceObject).getNameOnCLU().equals(string2) : (iSpecificTreeObject instanceof ModuleObject ? ((ModuleObject)(iDeviceObject = (ModuleObject)iSpecificTreeObject)).getClu().getSerialNumber().equals(l2) && ((ModuleObject)iDeviceObject).getNameOnCLU().equals(string2) : iSpecificTreeObject instanceof PeripheryCLU && ((PeripheryCLU)(iDeviceObject = (PeripheryCLU)iSpecificTreeObject)).getClu().getSerialNumber().equals(l2) && ((PeripheryCLU)iDeviceObject).getNameOnCLU().equals(string2)))) continue;
            return treeObject;
        }
        return null;
    }

    public synchronized TreeObject getObjectByName(String string, ObjectType[] objectTypeArray) {
        this.flatTree();
        for (TreeObject treeObject : this.treeObjectMap.values()) {
            if (!treeObject.getName().equals(string)) continue;
            ObjectType[] objectTypeArray2 = objectTypeArray;
            int n2 = objectTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ObjectType objectType = objectTypeArray2[n3];
                if (treeObject.getType() == objectType) {
                    return treeObject;
                }
                ++n3;
            }
        }
        return null;
    }

    public synchronized TreeObject getObjectByNameStartsWith(String string, ObjectType objectType) {
        this.flatTree();
        for (TreeObject treeObject : this.treeObjectMap.values()) {
            if (!treeObject.getName().startsWith(string) || treeObject.getType() != objectType) continue;
            return treeObject;
        }
        return null;
    }

    public synchronized ProjectProperties getProjectProperties() {
        return this.projectProperties;
    }

    public synchronized void loadProjectProperties(File file) throws IOException, ClassNotFoundException, ConversionException {
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            XStream xStream = e.a();
            fileInputStream = new FileInputStream(file);
            objectInputStream = xStream.createObjectInputStream((InputStream)fileInputStream);
            this.projectProperties = (ProjectProperties)objectInputStream.readObject();
            CipherKey cipherKey = this.projectProperties.getProjectCipherKey();
            cipherKey.a();
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {
                log.warn((Object)"Error while closing ObjectInputStream after reading project's property from file", (Throwable)iOException);
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                log.warn((Object)"Error while closing FileInputStream after reading project's property from file", (Throwable)iOException);
            }
        }
    }

    public synchronized boolean saveProjectProperties(File file) {
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            this.projectProperties.setVersionExt(d.a(null));
            this.projectProperties.setVersion(d.n());
            XStream xStream = e.a();
            fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
            objectOutputStream = xStream.createObjectOutputStream((Writer)outputStreamWriter);
            objectOutputStream.writeObject(this.projectProperties);
            return true;
        }
        catch (IOException iOException) {
            log.error((Object)"Error writing the project properties", (Throwable)iOException);
            i.b(d.a().getShell(), Messages.common_lblError, Messages.message_errorsaveprojectproperties_lblMessage);
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {
                log.warn((Object)"Error while closing output stream after saving project properties. ", (Throwable)iOException);
            }
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException) {
                log.warn((Object)"Error while closing OutputStreamWriter after saving project properties. ", (Throwable)iOException);
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                log.warn((Object)"Error while closing FileOutputStream after saving project properties. ", (Throwable)iOException);
            }
        }
        return false;
    }

    public synchronized Map<Integer, Set<TreeObject>> getTreeObjectLinkMap() {
        return this.treeObjectLinkMap;
    }

    public synchronized void updateObjectWithLinks(TreeObject treeObject) {
        Object object;
        this.flatTree();
        switch (treeObject.getType()) {
            case INPUT: 
            case OUTPUT: 
            case UNKNOWN_IO: 
            case PROGRAMMABLE_PERIPHERY: 
            case HARDWARE_PERIPHERY: {
                object = this.treeObjectLinkMap.get(treeObject.getId());
                if (object == null) break;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    TreeObject treeObject2 = (TreeObject)iterator.next();
                    treeObject2.setName(treeObject.getName());
                }
                break;
            }
        }
        object = this.treeObjectMap.get(treeObject.getId());
        ((TreeObject)object).setName(treeObject.getName());
    }

    public synchronized void transferLinkToAnotherObject(TreeObject treeObject, TreeObject treeObject2) {
        if (treeObject.getType() != treeObject2.getType()) {
            return;
        }
        switch (treeObject.getType()) {
            case INPUT: 
            case OUTPUT: 
            case UNKNOWN_IO: {
                Set<TreeObject> set = this.treeObjectLinkMap.get(treeObject.getId());
                if (set == null) break;
                for (TreeObject treeObject3 : set) {
                    treeObject3.setNewParentForLink(treeObject2);
                }
                this.treeObjectLinkMap.remove(treeObject.getId());
                this.treeObjectLinkMap.put(treeObject2.getId(), set);
                break;
            }
        }
    }

    public synchronized void reorganizeTree() {
        this.fixChildren(this.rootTree);
    }

    private synchronized void fixChildren(TreeObject treeObject) {
        if (treeObject != null && treeObject.getChildren() != null) {
            for (TreeObject treeObject2 : treeObject.getChildren()) {
                treeObject2.setParent(treeObject);
                this.fixChildren(treeObject2);
            }
        }
    }

    public synchronized List<CLU> getAllClu() {
        TreeObject treeObject = TreeModel.getInstance().getObjectsRootTree();
        List<TreeObject> list = treeObject.getChildsWithType(ObjectType.CLU);
        ArrayList<CLU> arrayList = new ArrayList<CLU>();
        for (TreeObject treeObject2 : list) {
            arrayList.add(R.a(treeObject2));
        }
        return arrayList;
    }

    public boolean isSelectionInContainers(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection == null) {
            return false;
        }
        Object[] objectArray = iStructuredSelection.toArray();
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectArray[n3];
            TreeObject treeObject = (TreeObject)object;
            if (!treeObject.isInContainer()) {
                return false;
            }
            ++n3;
        }
        return true;
    }
}

