/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model.tree.edit;

import com.grenton.Messages;
import com.grenton.om.commands.a.a;
import com.grenton.om.commands.a.f;
import com.grenton.om.commands.a.g;
import com.grenton.om.commands.a.h;
import com.grenton.om.commands.a.i;
import com.grenton.om.commands.a.j;
import com.grenton.om.editors.LuaScriptEditor;
import com.grenton.om.mobile.gui.MobileInterfaceEditor;
import com.grenton.om.mobile.gui.MobileInterfaceTreeObject;
import com.grenton.om.model.CLU;
import com.grenton.om.model.Container;
import com.grenton.om.model.Diagram;
import com.grenton.om.model.DiagramContainer;
import com.grenton.om.model.PeripheryCLU;
import com.grenton.om.model.Script;
import com.grenton.om.model.TreeObject;
import com.grenton.om.model.interfaces.ISpecificTreeObject;
import com.grenton.om.model.iomodules.ModuleObject;
import com.grenton.om.model.service.TreeModel;
import com.grenton.om.model.tree.edit.TreeObjectColumnLabelProvider;
import com.grenton.om.model.tree.edit.TreeObjectTextCellEditor;
import com.grenton.om.model.types.ObjectType;
import com.grenton.om.utils.S;
import com.grenton.om.utils.f.c;
import com.grenton.om.utils.f.d;
import com.grenton.om.views.NavigationView;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TreeEditingSupport
extends EditingSupport {
    private TreeViewer treeViewer;
    private NavigationView navigationView;
    private TreeObjectColumnLabelProvider labelProvider;
    private static Logger log = Logger.getLogger(TreeEditingSupport.class);

    public TreeEditingSupport(ColumnViewer columnViewer, TreeObjectColumnLabelProvider treeObjectColumnLabelProvider, NavigationView navigationView) {
        super(columnViewer);
        this.treeViewer = (TreeViewer)columnViewer;
        this.navigationView = navigationView;
        this.labelProvider = treeObjectColumnLabelProvider;
    }

    protected Object getValue(Object object) {
        return object.toString();
    }

    protected CellEditor getCellEditor(Object object) {
        return new TreeObjectTextCellEditor(this.treeViewer.getTree());
    }

    protected boolean canEdit(Object object) {
        if (this.navigationView.l().size() == 1 && object instanceof TreeObject) {
            TreeObject treeObject = (TreeObject)object;
            return treeObject.getSpecificObject() != null && S.e(treeObject);
        }
        return false;
    }

    protected void setValue(Object object, Object object2) {
        if (object instanceof TreeObject) {
            String string;
            TreeObject treeObject = (TreeObject)object;
            String string2 = treeObject.getName();
            if (StringUtils.equals((String)string2, (String)(string = object2.toString()))) {
                return;
            }
            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            HashSet<String> hashSet = new HashSet<String>();
            this.isNewNameValid(treeObject.getParent(), treeObject, string, hashSet);
            if (!hashSet.isEmpty()) {
                String string3 = hashSet.stream().collect(Collectors.joining("\n"));
                com.grenton.om.dialogs.customs.i.b(iWorkbenchWindow.getShell(), Messages.common_lblValidation, string3);
                this.navigationView.setFocus();
                return;
            }
            String string4 = string.trim();
            if (treeObject.getType().equals((Object)ObjectType.MYGRENTON_INTERFACE) && string2.equals(string4)) {
                this.navigationView.setFocus();
                return;
            }
            treeObject.setName(string);
            ISpecificTreeObject iSpecificTreeObject = treeObject.getSpecificObject();
            iSpecificTreeObject.setName(string);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            this.changeNameForAllReferences(string2, string, treeObject, treeObject.getParent(), shell);
            c.c(treeObject, true);
            TreeModel.getInstance().updateObjectWithLinks(treeObject);
            this.refreshMyGrentonInterfaceEditor(treeObject);
            this.refreshScriptEditor(treeObject);
            TreeModel.getInstance().setTreeSaved(false);
            this.navigationView.b(treeObject);
            this.navigationView.b(false);
            this.navigationView.a(true);
            this.navigationView.c(treeObject);
            this.navigationView.b(treeObject);
            this.navigationView.setFocus();
        } else {
            this.navigationView.a(true);
            this.navigationView.setFocus();
        }
    }

    private void isNewNameValid(TreeObject treeObject, TreeObject treeObject2, String string, Set<String> set) {
        TreeObject treeObject3;
        ISpecificTreeObject iSpecificTreeObject = treeObject.getSpecificObject();
        ISpecificTreeObject iSpecificTreeObject2 = treeObject2.getSpecificObject();
        if (iSpecificTreeObject == null) {
            if (iSpecificTreeObject2 instanceof CLU) {
                f.a((CLU)iSpecificTreeObject2, string, set);
            }
            if (iSpecificTreeObject2 instanceof Script) {
                j.a((CLU)treeObject2.getParent().getParent().getSpecificObject(), (Script)iSpecificTreeObject2, string, set);
            }
        }
        if (iSpecificTreeObject instanceof CLU && iSpecificTreeObject2 instanceof PeripheryCLU) {
            i.a((CLU)iSpecificTreeObject, (PeripheryCLU)iSpecificTreeObject2, string, set);
        }
        if (iSpecificTreeObject2 instanceof Container) {
            h.a((Container)iSpecificTreeObject2, string, set);
        }
        if (iSpecificTreeObject instanceof CLU && iSpecificTreeObject2 instanceof ModuleObject) {
            g.a((CLU)iSpecificTreeObject, (ModuleObject)iSpecificTreeObject2, string, set);
        }
        if (iSpecificTreeObject instanceof Container && iSpecificTreeObject2 instanceof ModuleObject && (treeObject3 = TreeModel.getInstance().getObjectByName(string)) != null && treeObject3.getParent().getSpecificObject() instanceof CLU) {
            TreeObject treeObject4 = treeObject3.getParent();
            g.a((CLU)treeObject4.getSpecificObject(), (ModuleObject)iSpecificTreeObject2, string, set);
        }
        if (iSpecificTreeObject2 instanceof MobileInterfaceTreeObject) {
            if (this.getExistingInterfacesNames().contains(string)) {
                set.add(Messages.common_lblErrorExistingNameObject);
            }
        } else if (iSpecificTreeObject instanceof DiagramContainer && iSpecificTreeObject2 instanceof Diagram && treeObject.hasChild(string)) {
            set.add(Messages.common_lblErrorExistingNameObject);
        }
    }

    private void changeNameForAllReferences(String string, String string2, TreeObject treeObject, TreeObject treeObject2, Shell shell) {
        a a2 = null;
        ISpecificTreeObject iSpecificTreeObject = treeObject.getSpecificObject();
        if (iSpecificTreeObject instanceof CLU) {
            a2 = new f(string, (CLU)treeObject.getSpecificObject(), shell);
        } else if (iSpecificTreeObject instanceof Script) {
            a2 = new j(string, string2, (CLU)treeObject.getParent().getParent().getSpecificObject(), treeObject, shell);
        } else if (iSpecificTreeObject instanceof PeripheryCLU) {
            a2 = new i(string, string2, treeObject2.getName(), shell, (PeripheryCLU)iSpecificTreeObject);
        } else if (iSpecificTreeObject instanceof Container) {
            a2 = new h(string, string2, treeObject.getName(), shell);
        } else if (iSpecificTreeObject instanceof ModuleObject) {
            TreeObject treeObject3;
            Object object;
            if (treeObject2.getSpecificObject() instanceof CLU) {
                a2 = new g(string, (ModuleObject)iSpecificTreeObject, treeObject2.getName(), shell);
            } else {
                object = TreeModel.getInstance().getObjectByName(string);
                if (object != null) {
                    treeObject3 = ((TreeObject)object).getParent();
                    a2 = new g(string, (ModuleObject)iSpecificTreeObject, treeObject3.getName(), shell);
                }
            }
            if (a2 != null) {
                a2.a(false);
                a2.c();
            }
            object = TreeModel.getInstance().getObjectsWithType(ObjectType.CONTAINER);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                treeObject3 = (TreeObject)iterator.next();
                g g2 = new g(string, (ModuleObject)iSpecificTreeObject, treeObject3.getName(), shell);
                g2.a(false);
                g2.c();
            }
            a2 = null;
        }
        if (a2 != null) {
            a2.a(false);
            a2.c();
        }
    }

    private Set<String> getExistingInterfacesNames() {
        HashSet<String> hashSet = new HashSet<String>();
        TreeObject treeObject = TreeModel.getInstance().getMyGrentonInterfacesRootTree();
        if (treeObject.getType() == ObjectType.MYGRENTON_INTERFACES) {
            List<TreeObject> list = treeObject.getChildren();
            for (TreeObject treeObject2 : list) {
                if (treeObject2.getType() != ObjectType.MYGRENTON_INTERFACE) continue;
                hashSet.add(treeObject2.getName());
            }
        }
        return hashSet;
    }

    private void refreshMyGrentonInterfaceEditor(TreeObject treeObject) {
        if (treeObject.getType().equals((Object)ObjectType.MYGRENTON_INTERFACE)) {
            IEditorReference[] iEditorReferenceArray;
            IEditorReference[] iEditorReferenceArray2 = iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n2 = iEditorReferenceArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IEditorReference iEditorReference = iEditorReferenceArray2[n3];
                IEditorPart iEditorPart = iEditorReference.getEditor(false);
                if (iEditorPart instanceof MobileInterfaceEditor) {
                    MobileInterfaceEditor mobileInterfaceEditor = (MobileInterfaceEditor)iEditorPart;
                    mobileInterfaceEditor.a().getDeviceRepository().updateModel();
                    mobileInterfaceEditor.a().dataChanged();
                }
                ++n3;
            }
        }
    }

    private void refreshScriptEditor(TreeObject treeObject) {
        d.k();
        if (treeObject.getType().equals((Object)ObjectType.SCRIPT)) {
            try {
                IEditorReference[] iEditorReferenceArray;
                Script script = (Script)treeObject.getSpecificObject();
                IEditorReference[] iEditorReferenceArray2 = iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n2 = iEditorReferenceArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    com.grenton.om.editors.b.a a2;
                    IEditorReference iEditorReference = iEditorReferenceArray2[n3];
                    if (iEditorReference.getId().equals("com.grenton.om.editors.LuaScriptEditor") && (a2 = (com.grenton.om.editors.b.a)iEditorReference.getEditorInput()) != null && script.getName().equals(a2.getName())) {
                        LuaScriptEditor luaScriptEditor = (LuaScriptEditor)iEditorReference.getEditor(true);
                        luaScriptEditor.a(treeObject.getName());
                        luaScriptEditor.f();
                        luaScriptEditor.e();
                        luaScriptEditor.a();
                    }
                    ++n3;
                }
            }
            catch (PartInitException partInitException) {
                log.error((Object)"Error with refreshing script editors", (Throwable)partInitException);
            }
        }
    }
}

