/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model.types;

import com.grenton.om.model.types.RestrictionTypes;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public enum ParamTypes {
    STRING,
    NUMBER,
    BOOLEAN,
    TIME_STAMP,
    TABLE,
    OTHER;


    public String toString() {
        return this.name().toLowerCase();
    }

    public static boolean isValueCorrect(String string, int n2) {
        if (n2 == TABLE.ordinal()) {
            return true;
        }
        if (n2 == -1) {
            return false;
        }
        if (n2 == STRING.ordinal() || n2 == OTHER.ordinal()) {
            return string.trim().length() > 0;
        }
        if (n2 == NUMBER.ordinal()) {
            try {
                Double.valueOf(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (n2 == BOOLEAN.ordinal()) {
            return "true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string);
        }
        if (n2 == TIME_STAMP.ordinal()) {
            try {
                Integer.valueOf(string);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static List<String> getAvailableOperators(ParamTypes paramTypes, RestrictionTypes restrictionTypes) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("==");
        arrayList.add("~=");
        if (!(paramTypes != NUMBER && paramTypes != TIME_STAMP || restrictionTypes != null && restrictionTypes == RestrictionTypes.ENUMERATE)) {
            arrayList.add("<");
            arrayList.add("<=");
            arrayList.add(">");
            arrayList.add(">=");
        }
        return arrayList;
    }

    public static ParamTypes getTypeForContent(String string) {
        ParamTypes paramTypes = STRING;
        if (ParamTypes.isValueCorrect(string, BOOLEAN.ordinal())) {
            paramTypes = BOOLEAN;
        } else if (ParamTypes.isValueCorrect(string, NUMBER.ordinal())) {
            paramTypes = NUMBER;
        }
        return paramTypes;
    }

    public static Object[] getAvailableTypes() {
        LinkedList<ParamTypes> linkedList = new LinkedList<ParamTypes>();
        ParamTypes[] paramTypesArray = ParamTypes.values();
        int n2 = paramTypesArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ParamTypes paramTypes = paramTypesArray[n3];
            if (paramTypes != TIME_STAMP && paramTypes != TABLE && paramTypes != OTHER) {
                linkedList.add(paramTypes);
            }
            ++n3;
        }
        return linkedList.toArray();
    }
}

