/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.om.model.util;

import com.grenton.om.cluInterface.CLUIOMInterface;
import com.grenton.om.cluInterface.IfFeature;
import com.grenton.om.cluInterface.IfInterface;
import com.grenton.om.cluInterface.h;
import com.grenton.om.m.f;
import com.grenton.om.model.CLU;
import com.grenton.om.model.EmbeddedFeature;
import com.grenton.om.model.Event;
import com.grenton.om.model.interfaces.IDeviceObject;
import com.grenton.om.model.interfaces.ISpecificTreeObject;
import com.grenton.om.model.iomodules.ModuleDevice;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;

public class DeviceObjects {
    private static final String CLU_PREFIX = "CLU";
    private static final String DEFAULT_PREFIX = "OBJ";
    private static int PREFIX_MAX_LENGTH = 3;
    private static final String UNDERLINE = "_";
    private static final String IO_PREFIX = "x";

    public static String generateCluName(long l2) {
        if (l2 > 0L) {
            return CLU_PREFIX + String.valueOf(l2);
        }
        return CLU_PREFIX + System.currentTimeMillis();
    }

    public static String generateObjectName(CLU cLU, String string) {
        String string2;
        while (cLU.getIoByNameOnClu(string2 = String.valueOf(DeviceObjects.getPrefix(string)) + DeviceObjects.generateRandomId()) != null) {
        }
        return string2;
    }

    private static String generateRandomId() {
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 4;
        String string = RandomStringUtils.random((int)n2, (boolean)bl, (boolean)bl2);
        return string;
    }

    private static String getPrefix(String string) {
        String string2 = DEFAULT_PREFIX;
        if (string != null) {
            int n2 = string.length();
            if (n2 > PREFIX_MAX_LENGTH) {
                string2 = string.substring(0, PREFIX_MAX_LENGTH);
                string2 = string2.replaceAll(UNDERLINE, "");
            } else {
                string2 = string;
            }
        }
        string2 = string2.toUpperCase();
        return string2;
    }

    public static String generateObjectLabel(CLU cLU, ModuleDevice moduleDevice, String string, int n2) {
        String string2 = String.format("%02d", n2 + 1);
        String string3 = IO_PREFIX + moduleDevice.getSerialNumber() + UNDERLINE + string + UNDERLINE + string2;
        int n3 = 1;
        while (DeviceObjects.isNameAlreadyUsed(cLU, string3)) {
            string3 = IO_PREFIX + moduleDevice.getSerialNumber() + UNDERLINE + string + UNDERLINE + string2 + UNDERLINE + n3;
            ++n3;
        }
        return string3;
    }

    public static String generateUnknownObjectLabel(CLU cLU, ModuleDevice moduleDevice, String string) {
        String string2;
        int n2 = 1;
        do {
            string2 = "???_" + moduleDevice.getSerialNumber() + UNDERLINE + string + n2;
            ++n2;
        } while (DeviceObjects.isNameAlreadyUsed(cLU, string2));
        return string2;
    }

    public static boolean isNameAlreadyUsed(CLU cLU, String string) {
        if (cLU.getEmbeddedFeatureByName(string) != null) {
            return true;
        }
        if (cLU.getDefinedFeatureByName(string) != null) {
            return true;
        }
        if (cLU.getScriptByName(string) != null) {
            return true;
        }
        if (cLU.getPeripheryByName(string) != null) {
            return true;
        }
        if (cLU.getIoByName(string) != null) {
            return true;
        }
        if (f.c(string)) {
            return false;
        }
        return false;
    }

    public static void updateFeaturesAndEvents(IDeviceObject iDeviceObject) {
        IfInterface ifInterface = CLUIOMInterface.getInstance().a(iDeviceObject);
        DeviceObjects.updateFeaturesAndEvents(iDeviceObject, ifInterface);
    }

    public static void updateFeaturesAndEvents(IDeviceObject iDeviceObject, IfInterface ifInterface) {
        ISpecificTreeObject iSpecificTreeObject;
        if (iDeviceObject == null || ifInterface == null) {
            iDeviceObject.setEvents(List.of());
            iDeviceObject.setEmbeddedFeatures(List.of());
            return;
        }
        ArrayList<EmbeddedFeature> arrayList = new ArrayList<EmbeddedFeature>();
        for (IfFeature ifFeature : ifInterface.getFeatures()) {
            EmbeddedFeature embeddedFeature = ifFeature.j();
            iSpecificTreeObject = iDeviceObject.getEmbeddedFeatureByIndex(ifFeature.d());
            if (iSpecificTreeObject == null) {
                iSpecificTreeObject = iDeviceObject.getEmbeddedFeatureByName(ifFeature.getName());
            }
            if (iSpecificTreeObject != null) {
                embeddedFeature.setInitValue(((EmbeddedFeature)iSpecificTreeObject).getInitValue());
            }
            arrayList.add(embeddedFeature);
        }
        iDeviceObject.setEmbeddedFeatures(arrayList);
        ArrayList<Event> arrayList2 = new ArrayList<Event>();
        for (h h2 : ifInterface.a()) {
            iSpecificTreeObject = h2.c();
            Event event = iDeviceObject.getEventByIndex(h2.b());
            if (event == null) {
                event = iDeviceObject.getEventByName(h2.a());
            }
            if (event != null) {
                ((Event)iSpecificTreeObject).setCommands(event.getCommands());
                ((Event)iSpecificTreeObject).setCustomSchemeCommands(event.getCustomSchemeCommands());
            }
            arrayList2.add((Event)iSpecificTreeObject);
        }
        iDeviceObject.setEvents(arrayList2);
    }
}

