/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.vb.model;

import com.grenton.om.model.Beacon;
import com.grenton.om.model.BeaconEvent;
import com.grenton.om.model.OMLCommand;
import com.grenton.om.utils.M;
import com.grenton.vb.model.ContainerComponent;
import com.grenton.vb.properties.model.FontProperties;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeaconComponent
extends ContainerComponent
implements Cloneable {
    private static final long serialVersionUID = -5355224834025363205L;
    private static final String MISC_ELEMENT = "misc";
    private static final String ID_ATTR = "id";
    private static final String NAME_ATTR = "name";
    private static final String GENERAL_ELEMENT = "general";
    private static final String TYPE_ATTR = "type";
    private static final String BEACONS_ELEMENT = "beacons";
    protected String type = null;
    protected FontProperties font;
    protected List<Beacon> beacons = new LinkedList<Beacon>();

    @Override
    public Image getIcon() {
        return M.b("icons/vb/oneButton16.png");
    }

    @Override
    public Element getXMLCode(Document document, Element element) {
        element.appendChild(super.getXMLCode(document, element));
        element.setAttribute(TYPE_ATTR, this.type);
        Element element2 = document.createElement(GENERAL_ELEMENT);
        element2.setAttribute(ID_ATTR, (String)this.getPropertyValue("Shape.id"));
        element.appendChild(element2);
        Element element3 = document.createElement(BEACONS_ELEMENT);
        for (Beacon object : this.beacons) {
            Element element4 = document.createElement("beacon");
            element4.setAttribute(NAME_ATTR, object.getName());
            element4.setAttribute("sn", object.getSerialNumber());
            for (BeaconEvent beaconEvent : object.getBeaconEvents()) {
                Element element5 = document.createElement("event");
                element5.setAttribute(NAME_ATTR, beaconEvent.getName().toUpperCase());
                element5.appendChild(document.createTextNode(this.changeOMcommandToCLUrequest(beaconEvent.getCommand())));
                element4.appendChild(element5);
            }
            element3.appendChild(element4);
        }
        element.appendChild(element3);
        element2 = document.createElement(MISC_ELEMENT);
        for (Map.Entry entry : this.font.d().entrySet()) {
            element2.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return element2;
    }

    @Override
    protected void generateDimensionAttributes(Element element) {
        element.setAttribute("width", (String)this.getPropertyValue("Shape.Width"));
        element.setAttribute("height", (String)this.getPropertyValue("Shape.Height"));
    }

    @Override
    public void readFromXML(Widget widget, Node node) {
        super.readFromXML(widget, node);
        Map<String, String> map = this.getGeneralAttributes(node);
        this.setPropertyValue("Shape.id", map.get(ID_ATTR));
    }

    @Override
    public String getSkinTypeName() {
        return "";
    }

    @Override
    public boolean isSkinAble() {
        return false;
    }

    public List<Beacon> getBeacons() {
        return this.beacons;
    }

    public void setBeacons(List<Beacon> list) {
        this.beacons = list;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public List<OMLCommand> getAllOMLCommands() {
        List<OMLCommand> list = super.getAllOMLCommands();
        for (Beacon beacon : this.beacons) {
            for (BeaconEvent beaconEvent : beacon.getBeaconEvents()) {
                list.add(beaconEvent.getCommand());
            }
        }
        return list;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BeaconComponent beaconComponent = new BeaconComponent();
        beaconComponent.text = this.text;
        beaconComponent.type = this.type;
        if (!this.getParent().isMain()) {
            beaconComponent.setParent(this.getParent());
        }
        beaconComponent.setClassProp(this.getClassProp());
        beaconComponent.setInitialized(this.isInitialized());
        beaconComponent.setOnline(this.isOnline());
        if (this.isCut()) {
            beaconComponent.setId(this.getId());
        }
        LinkedList<Beacon> linkedList = new LinkedList<Beacon>();
        for (Beacon beacon : this.beacons) {
            linkedList.add((Beacon)beacon.clone());
        }
        beaconComponent.beacons = linkedList;
        beaconComponent.setLocation(this.getLocation());
        beaconComponent.setSize(this.getSize());
        beaconComponent.setZ_index(this.getZ_index());
        return beaconComponent;
    }
}

