/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.vb.model;

import com.grenton.om.model.OMLCommand;
import com.grenton.om.utils.M;
import com.grenton.vb.model.ContainerComponent;
import com.grenton.vb.properties.b.d;
import com.grenton.vb.properties.b.e;
import com.grenton.vb.properties.model.FontProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Button
extends ContainerComponent
implements Cloneable {
    private static final long serialVersionUID = -1787805255304235113L;
    protected static final String TYPE = "button";
    protected static int _count = 0;
    private FontProperties font;
    private OMLCommand onClick = new OMLCommand("");
    private static transient Logger log = Logger.getLogger(Button.class);
    private transient IPropertyDescriptor[] newDescriptors;
    public static final String ON_CLICK_PROP = "ONCLICK";

    public Button() {
        ++_count;
        _count = this.generateId("Button", _count);
        this.font = new FontProperties();
        this.eventsList.add(ON_CLICK_PROP);
        this.eventTypes.put(ON_CLICK_PROP, new OMLCommand(""));
        this.newDescriptors = new IPropertyDescriptor[]{new d("Shape.Text", "Text", "General", null), new d(ON_CLICK_PROP, "onClick", "Events", null), new e("Font", "Font")};
        this.descriptorsList.addAll(Arrays.asList(this.newDescriptors));
    }

    @Override
    public Image getIcon() {
        return M.b("icons/vb/button16.png");
    }

    public OMLCommand getOnClick() {
        return this.onClick;
    }

    public void setOnClick(OMLCommand oMLCommand) {
        this.onClick = oMLCommand;
        this.firePropertyChange(ON_CLICK_PROP, null, oMLCommand);
    }

    public void setFont(FontProperties fontProperties) {
        this.font = fontProperties;
        this.firePropertyChange("Font", null, fontProperties);
    }

    public FontProperties getFont() {
        return this.font;
    }

    @Override
    public void setPropertyValue(Object object, Object object2) {
        if (ON_CLICK_PROP.equals(object)) {
            this.setOnClick((OMLCommand)object2);
        } else if ("Font".equals(object)) {
            this.setFont((FontProperties)object2);
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    @Override
    public Object getPropertyValue(Object object) {
        if (ON_CLICK_PROP.equals(object)) {
            return this.getOnClick();
        }
        if ("Font".equals(object)) {
            return this.getFont();
        }
        return super.getPropertyValue(object);
    }

    @Override
    public boolean updateCLUReferences(String string, String string2) {
        String string3 = this.onClick.getOryginal();
        boolean bl = string3.indexOf(string) != -1;
        this.onClick = new OMLCommand(string3.replaceAll(string, string2));
        return bl || super.updateCLUReferences(string, string2);
    }

    @Override
    public Element getXMLCode(Document document, Element element) {
        element.appendChild(super.getXMLCode(document, element));
        element.setAttribute("type", TYPE);
        Element element2 = document.createElement("general");
        element2.setAttribute("id", (String)this.getPropertyValue("Shape.id"));
        element.appendChild(element2);
        element2.setAttribute("text", (String)this.getPropertyValue("Shape.Text"));
        element.appendChild(element2);
        Element element3 = document.createElement("events");
        element3.setAttribute("sync", (String)this.getPropertyValue("Source sync time"));
        for (String object : this.getAvailableEvents()) {
            Element element4 = document.createElement("event");
            element4.setAttribute("name", object);
            element4.appendChild(document.createTextNode(this.changeOMcommandToCLUrequest((OMLCommand)this.getPropertyValue(object))));
            element3.appendChild(element4);
        }
        element.appendChild(element3);
        element2 = document.createElement("misc");
        for (Map.Entry entry : this.font.d().entrySet()) {
            element2.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return element2;
    }

    @Override
    public void readFromXML(Widget widget, Node node) {
        super.readFromXML(widget, node);
        Map<String, String> map = this.getGeneralAttributes(node);
        Map<String, String> map2 = this.getMiscAttributes(node);
        this.setPropertyValue("Shape.id", map.get("id"));
        this.setPropertyValue("Shape.Text", map.get("text"));
        int n2 = 0;
        try {
            n2 = Integer.valueOf(this.getEventsSyncTime(node));
        }
        catch (Exception exception) {
            log.warn((Object)("Incorrect time of refreshing the component: " + this.toString()), (Throwable)exception);
        }
        this.setPropertyValue("Source sync time", n2);
        this.getEventTypes().putAll(this.getEvents(node));
        this.font.a(map2);
    }

    @Override
    public String getSkinTypeName() {
        return TYPE;
    }

    @Override
    public boolean isSkinAble() {
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Button button = (Button)super.clone();
        button = new Button();
        if (!this.getParent().isMain()) {
            button.setParent(this.getParent());
        }
        if (this.getSkin() != null) {
            button.setSkin(this.getSkin().e());
        }
        button.setSourceSyncTime(this.getSourceSyncTime());
        button.setInlineStyle(this.getInlineStyle());
        button.setClassProp(this.getClassProp());
        button.setInitialized(this.isInitialized());
        button.setOnline(this.isOnline());
        button.setSource(this.getSource());
        if (this.isCut()) {
            button.setId(this.getId());
        }
        button.eventsList = new ArrayList();
        if (this.getAvailableEvents() != null && !this.getAvailableEvents().isEmpty()) {
            for (String string : this.getAvailableEvents()) {
                button.eventsList.add(string);
            }
        }
        button.eventTypes = new HashMap();
        if (this.getEventTypes() != null && !this.getEventTypes().isEmpty()) {
            for (String string : this.getEventTypes().keySet()) {
                button.eventTypes.put(string, this.getEventTypes().get(string));
            }
        }
        button.setText(this.getText());
        button.setOnClick(this.getOnClick());
        button.setFont(this.getFont());
        button.setLocation(this.getLocation());
        button.setSize(this.getSize());
        button.setZ_index(this.getZ_index());
        return button;
    }

    @Override
    public List<OMLCommand> getAllOMLCommands() {
        List<OMLCommand> list = super.getAllOMLCommands();
        list.add(this.getOnClick());
        return list;
    }
}

