/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.vb.model;

import com.grenton.om.model.OMLCommand;
import com.grenton.vb.i.a;
import com.grenton.vb.i.c;
import com.grenton.vb.properties.b.d;
import com.grenton.visual.base.model.VisualBaseComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class Component
extends VisualBaseComponent {
    private static final long serialVersionUID = -5991660597549933761L;
    private final int SOURCE_SYNC_TIME_CONVERSION = 1;
    public static final String ID_PROP = "Shape.id";
    private static final String Z_INDEX_PROP = "Shape.z";
    public static final String SOURCE_PROP = "Source";
    public static final String CUSTOM_NAMES_PROP = "CustomName";
    public static final String SOURCE_SYNC_TIME_PROP = "Source sync time";
    public static final String EVENTS_CATEGORY = "Events";
    protected int height;
    protected int width;
    private String inlineStyle;
    protected List<String> eventsList;
    protected Map<String, OMLCommand> eventTypes;
    private int z_index;
    private String id;
    private String classProp;
    private boolean initialized;
    private boolean online;
    private OMLCommand source;
    private String sourceSyncTime;
    private transient IPropertyDescriptor[] newDescriptors;
    private static final Logger log = Logger.getLogger(Component.class);

    public Component() {
        this.height = this.size.height;
        this.width = this.size.width;
        this.inlineStyle = "";
        this.eventsList = new ArrayList<String>();
        this.eventTypes = new HashMap<String, OMLCommand>();
        this.z_index = 0;
        this.id = "";
        this.classProp = "";
        this.initialized = false;
        this.online = false;
        this.source = new OMLCommand("");
        this.sourceSyncTime = "1000";
        this.eventsList.add(SOURCE_PROP);
        this.eventTypes.put(SOURCE_PROP, new OMLCommand(""));
        this.newDescriptors = new IPropertyDescriptor[]{new d(ID_PROP, "Id", "General", new a()), new d(SOURCE_PROP, SOURCE_PROP, EVENTS_CATEGORY, null), new d(SOURCE_SYNC_TIME_PROP, SOURCE_SYNC_TIME_PROP, EVENTS_CATEGORY, new c())};
        this.descriptorsList.addAll(Arrays.asList(this.newDescriptors));
    }

    protected int generateId(String string, int n2) {
        String string2 = String.valueOf(string) + n2;
        this.setId(string2);
        return n2;
    }

    @Override
    public Object getPropertyValue(Object object) {
        if (ID_PROP.equals(object)) {
            return String.valueOf(this.id);
        }
        if (SOURCE_PROP.equals(object)) {
            return this.getSource();
        }
        if (SOURCE_SYNC_TIME_PROP.equals(object)) {
            return this.getSourceSyncTime();
        }
        return super.getPropertyValue(object);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public void setPropertyValue(Object object, Object object2) {
        if (ID_PROP.equals(object)) {
            this.setId(String.valueOf(object2));
        } else if (SOURCE_PROP.equals(object)) {
            this.setSource((OMLCommand)object2);
        } else if (SOURCE_SYNC_TIME_PROP.equals(object)) {
            this.setSourceSyncTime(String.valueOf(object2));
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    @Override
    public boolean isPropertySet(Object object) {
        return false;
    }

    @Override
    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.height = dimension.height;
        this.width = dimension.width;
    }

    public int getZ_index() {
        return this.z_index;
    }

    public void setZ_index(int n2) {
        this.z_index = n2;
        this.firePropertyChange(Z_INDEX_PROP, null, n2);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        String string2 = new String(this.id);
        this.id = string;
        this.firePropertyChange(ID_PROP, string2, string);
    }

    public void forceSetId(String string) {
        this.id = string;
    }

    public String getInlineStyle() {
        return this.inlineStyle;
    }

    public void setInlineStyle(String string) {
        this.inlineStyle = string;
    }

    public String getClassProp() {
        return this.classProp;
    }

    public void setClassProp(String string) {
        this.classProp = string;
    }

    public abstract Image getIcon();

    public void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean bl) {
        this.online = bl;
    }

    public OMLCommand getSource() {
        return this.source;
    }

    public void setSource(OMLCommand oMLCommand) {
        this.source = oMLCommand;
        this.firePropertyChange(SOURCE_PROP, null, oMLCommand);
    }

    public List<String> getAvailableEvents() {
        return this.eventsList;
    }

    public Map<String, OMLCommand> getEventTypes() {
        return this.eventTypes;
    }

    public void setEventType(String string, OMLCommand oMLCommand) {
        this.eventTypes.put(string, oMLCommand);
    }

    public OMLCommand getEventType(String string) {
        return this.eventTypes.get(string);
    }

    public void setSourceSyncTime(String string) {
        this.sourceSyncTime = string;
    }

    public String getSourceSyncTime() {
        return this.sourceSyncTime;
    }

    public String getSourceSyncTimeInMs() {
        try {
            return String.valueOf(Integer.parseInt(this.sourceSyncTime) * 1);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn((Object)("Can't parse source sync time: '" + this.sourceSyncTime + "'. Default unknown value will be used."));
            return "-1";
        }
    }

    @Override
    public boolean updateCLUReferences(String string, String string2) {
        boolean bl = this.source.getOryginal().indexOf(string) != -1;
        this.source = new OMLCommand(this.source.getOryginal().replaceAll(string, string2));
        return bl;
    }

    public List<OMLCommand> getAllOMLCommands() {
        ArrayList<OMLCommand> arrayList = new ArrayList<OMLCommand>();
        arrayList.add(this.getSource());
        return arrayList;
    }
}

