/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.vb.model;

import com.grenton.Messages;
import com.grenton.om.m;
import com.grenton.om.utils.M;
import com.grenton.vb.model.BeaconZone;
import com.grenton.vb.model.Button;
import com.grenton.vb.model.CameraButton;
import com.grenton.vb.model.ContainerComponent;
import com.grenton.vb.model.ContainerType;
import com.grenton.vb.model.DiStateButton;
import com.grenton.vb.model.GPSComponent;
import com.grenton.vb.model.Gauge;
import com.grenton.vb.model.ImageLabel;
import com.grenton.vb.model.IntercomButton;
import com.grenton.vb.model.LinkButton;
import com.grenton.vb.model.Menu;
import com.grenton.vb.model.OneButton;
import com.grenton.vb.model.RadioButton;
import com.grenton.vb.model.SkinType;
import com.grenton.vb.model.Slider;
import com.grenton.vb.model.TextLabel;
import com.grenton.vb.model.VideoStreamComponent;
import com.grenton.vb.model.panel.StatisticPanel;
import com.grenton.vb.model.panel.ThermostatPanel;
import com.grenton.vb.properties.b.c;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DeferredAttrImpl;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Container
extends ContainerComponent
implements Cloneable {
    private static final String COMPONENT_ELEMENT = "component";
    private static final String COMPONENTS_ELEMENT = "components";
    private static final String SKIN_NAME_ATTR = "skinName";
    private static final String HEIGHT_ATTR = "height";
    private static final String WIDTH_ATTR = "width";
    private static final String BACKGROUND_ROTATE_IMAGE_ATTR = "backgroundRotateImage";
    private static final String BACKGROUND_IMAGE_ATTR = "backgroundImage";
    private static final String SCALE_BACKGROUND_ATTR = "scaleBackground";
    private static final String LAYOUT_ATTR = "layout";
    private static final String TYPE_ATTR = "type";
    private static final String SKIN_ATTR = "skin";
    private static final long serialVersionUID = -1787805255304235113L;
    private static final String TYPE = "container";
    private static Logger log = Logger.getLogger(Container.class);
    private static int _count = 0;
    public static final String HIGHLIGHT = "highlight";
    public static final String IMAGE_PROP = "Shape.BackgroundImage";
    public static final String CONTAINER_TYPE_PROP = "Shape.ContainerType";
    public static final String SHOW_CHESS_BOARD_PROP = "Show.Chess.Board";
    private transient IPropertyDescriptor[] newDescriptors;
    private static final String[] containerTypeOptions = new String[]{ContainerType.VERTICAL.toString(), ContainerType.HORIZONTAL.toString(), ContainerType.ABSOLUTE.toString(), ContainerType.GRID.toString()};
    private ContainerType containerType = ContainerType.ABSOLUTE;
    private LinkedList<ContainerComponent> childs = new LinkedList();
    private String backgroundFile = "";
    private boolean ignoreChangesToChilds;
    private boolean alreadyRefreshing;
    private int backgroundRotateAngle;
    private boolean scaleBackground;
    private final List<ContainerComponent> copiedChilds = new ArrayList<ContainerComponent>();
    private boolean isMain = true;
    private BeaconZone beaconZone;
    private String appSkinName;
    private transient Point startSelectionOrigin;
    private static final int MARGIN_GRID = 5;

    public Container() {
        this.setId("Container" + _count++);
        this.newDescriptors = new IPropertyDescriptor[]{new c(CONTAINER_TYPE_PROP, Messages.window_visualbuilder_tab_parameters_hdrTypeContainera, "Misc", containerTypeOptions)};
        this.descriptorsList.clear();
        this.descriptorsList.addAll(Arrays.asList(this.newDescriptors));
        this.setSize(new Dimension(100, 50));
    }

    @Override
    public Image getIcon() {
        return M.b("icons/vb/layout16.png");
    }

    @Override
    public void setPropertyValue(Object object, Object object2) {
        if (CONTAINER_TYPE_PROP.equals(object)) {
            this.setContainerType(ContainerType.values()[(Integer)object2]);
        } else if (IMAGE_PROP.equals(object)) {
            this.setBackgroundFile((String)object2);
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    @Override
    public Object getPropertyValue(Object object) {
        if (CONTAINER_TYPE_PROP.equals(object)) {
            return this.containerType.ordinal();
        }
        if (IMAGE_PROP.equals(object)) {
            return this.getBackgroundFile();
        }
        return super.getPropertyValue(object);
    }

    public LinkedList<ContainerComponent> getChilds() {
        return this.childs;
    }

    public void setChilds(LinkedList<ContainerComponent> linkedList) {
        this.childs = linkedList;
        this.refresh();
    }

    public void addChild(ContainerComponent containerComponent) {
        if (containerComponent instanceof Container) {
            this.childs.addFirst(containerComponent);
        } else if (containerComponent instanceof BeaconZone) {
            if (this.getTopContainer().getBeaconZone() == null) {
                this.getTopContainer().setBeaconZone((BeaconZone)containerComponent);
            }
        } else {
            this.childs.add(containerComponent);
        }
        this.refresh();
    }

    protected void removeChild(ContainerComponent containerComponent) {
        if (containerComponent instanceof BeaconZone) {
            this.getTopContainer().setBeaconZone(null);
        }
        if (!this.childs.remove(containerComponent)) {
            log.error((Object)"Container doesn't contain child to remove");
        }
        this.refresh();
    }

    private void refreshContainerSize() {
        if (this.getParent() == null) {
            return;
        }
        if (this.containerType != ContainerType.ABSOLUTE) {
            int n2 = 0;
            int n3 = 0;
            for (ContainerComponent object2 : this.childs) {
                if (object2.getWidth() > n2) {
                    n2 = object2.getWidth();
                }
                if (object2.getHeight() <= n3) continue;
                n3 = object2.getHeight();
            }
            Dimension containerComponent = this.getSize();
            if (this.getSize().width < n2) {
                containerComponent.setWidth(n2);
            }
            if (this.getSize().height < n3) {
                containerComponent.setHeight(n3);
            }
            if (!this.getSize().equals((Object)containerComponent)) {
                this.setSize(containerComponent);
            }
            return;
        }
        if (!this.getBackgroundFile().isEmpty()) {
            return;
        }
        if (this.childs.isEmpty()) {
            return;
        }
        Rectangle rectangle = new Rectangle(this.getLocation(), new Dimension(100, 50));
        int n4 = 5;
        for (ContainerComponent containerComponent : this.childs) {
            int n2;
            int n3 = containerComponent.getLocation().x + containerComponent.getWidth();
            if (n3 > rectangle.getLocation().x + rectangle.width) {
                rectangle.setWidth(n3 - rectangle.getLocation().x + n4);
            }
            if ((n2 = containerComponent.getLocation().y + containerComponent.getHeight()) <= rectangle.getLocation().y + rectangle.height) continue;
            rectangle.setHeight(n2 - rectangle.getLocation().y + n4);
        }
        if (rectangle.width > this.getSize().width || rectangle.height > this.getSize().height) {
            this.setSize(rectangle.getSize());
            this.setLocation(rectangle.getTopLeft());
        }
    }

    public boolean containsChild(ContainerComponent containerComponent) {
        if (this.childs == null || this.childs.isEmpty()) {
            return false;
        }
        return this.childs.contains(containerComponent);
    }

    private void refreshChildsSize() {
        this.refreshChildsSize(0, false, 0, 0);
    }

    private Pair<Integer, Integer> refreshChildsSize(int n2, boolean bl, int n3, int n4) {
        if (this.childs.isEmpty()) {
            return new ImmutablePair((Object)1, (Object)1);
        }
        if (this.alreadyRefreshing && n2 == 0 && !bl) {
            return new ImmutablePair((Object)1, (Object)1);
        }
        this.alreadyRefreshing = true;
        int n5 = this.getHeight();
        int n6 = this.getWidth();
        int n7 = this.childs.size();
        Menu menu = this.getMenuIfExists();
        if (menu != null) {
            n5 -= menu.getHeight();
        }
        int n8 = n5 / n7;
        int n9 = n6 / n7;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        if (bl) {
            ++n2;
        }
        if (this.containerType == ContainerType.GRID) {
            Pair<Integer, Integer> pair = this.calculateColsAndRows(this.childs, n2, n5, n6);
            n10 = (Integer)pair.getLeft();
            n11 = (Integer)pair.getRight();
            n9 = n6 / n10;
            n8 = n5 / n11;
            if (n10 == n3 && n11 == n4) {
                n9 = n6 / ++n10;
            }
        }
        int n13 = 4;
        int n14 = 4;
        for (ContainerComponent containerComponent : this.childs) {
            if (containerComponent instanceof Menu || containerComponent.getParent() == null) continue;
            n13 += containerComponent.getHeight() + 4;
            n14 += containerComponent.getWidth() + 4;
        }
        int n15 = 4;
        int n16 = 4;
        int n17 = 0;
        bl = false;
        try {
            for (ContainerComponent containerComponent : this.childs) {
                int n18;
                int n19;
                if (containerComponent instanceof Menu || containerComponent instanceof ThermostatPanel) continue;
                if (containerComponent.getParent() == null) {
                    ((Container)containerComponent).refreshChildsSize();
                } else if (this.containerType == ContainerType.VERTICAL) {
                    n19 = n6 / 2 - containerComponent.getWidth() / 2;
                    n18 = n5 / 2 - n13 / 2 + n15;
                    if (n18 < 0) {
                        n18 = 4;
                    } else if (n18 + containerComponent.getHeight() > n5) {
                        n18 = n5 - containerComponent.getHeight();
                    }
                    containerComponent.setLocation(new Point(n19 += this.getLocation().x, n18 += this.getLocation().y));
                    n15 += containerComponent.getHeight() + 4;
                } else if (this.containerType == ContainerType.HORIZONTAL) {
                    n19 = n6 / 2 - n14 / 2 + n16;
                    n18 = n5 / 2 - containerComponent.getHeight() / 2;
                    if (n19 < 0) {
                        n19 = 4;
                    } else if (n19 + containerComponent.getWidth() > n6) {
                        n19 = n6 - containerComponent.getWidth();
                    }
                    containerComponent.setLocation(new Point(n19 += this.getLocation().x, n18 += this.getLocation().y));
                    n16 += containerComponent.getWidth() + 4;
                } else if (this.containerType == ContainerType.GRID) {
                    int n20;
                    n17 = containerComponent.width >= n6 ? n10 - 1 : (containerComponent.width != n9 ? containerComponent.width / n9 : 0);
                    int n21 = n12 % n10 * n9;
                    n19 = n21 + n9 * (n17 + 1) / 2 - containerComponent.getWidth() / 2;
                    n18 = n12 / n10 * n8 + n8 / 2 - containerComponent.getHeight() / 2;
                    if (!"".equals(containerComponent.getLedRgbGroupName()) && "Pokretlo_Kolor".equals(containerComponent.getDefaultSkinName())) {
                        n20 = 0;
                        int n22 = containerComponent.height / n8 + 1;
                        n21 = 0;
                        n19 = n21 + n6 / 2 - containerComponent.getWidth() / 2;
                        int n23 = n22 * n8 / 2;
                        int n24 = n12 / n10;
                        if (n12 % n10 != 0) {
                            ++n24;
                            n20 = n10 - n12 % n10;
                        }
                        n18 = n24 * n8 + n23 - containerComponent.getHeight() / 2;
                        if (containerComponent.height > n8) {
                            n17 = (n10 - 1) * n22;
                            ++n17;
                        } else {
                            n17 = n10 - 1;
                        }
                        n17 += n20;
                    }
                    if (n19 < 0) {
                        n19 = 4;
                    } else if (n21 + containerComponent.getWidth() >= n6) {
                        n19 = n9 * (n17 + 1) / 2 - containerComponent.getWidth() / 2;
                        n18 += n8;
                        n20 = (n6 - n21) / n9;
                        n12 += n20;
                    }
                    if (n18 < 0) {
                        n18 = 4;
                    } else if (n18 + containerComponent.getHeight() + 4 > n5) {
                        n18 = n5 - containerComponent.getHeight() - 4;
                        bl = true;
                    }
                    containerComponent.setLocation(new Point(n19 += this.getLocation().x, n18 += this.getLocation().y));
                }
                ++n12;
                if (this.containerType != ContainerType.GRID || (n12 += n17) <= n10 * n11 && !bl) continue;
                this.refreshChildsSize(n2, bl, n10, n11);
                break;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.alreadyRefreshing = false;
            this.refreshChildsSize();
        }
        this.alreadyRefreshing = false;
        return new ImmutablePair((Object)n10, (Object)n11);
    }

    private Pair<Integer, Integer> calculateColsAndRows(LinkedList<ContainerComponent> linkedList, int n2, int n3, int n4) {
        Pair<Integer, Integer> n13;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeMap<String, List<ContainerComponent>> treeMap = new TreeMap<String, List<ContainerComponent>>();
        boolean bl = true;
        for (ContainerComponent object2 : linkedList) {
            if (object2 instanceof Menu || object2.getParent() == null) continue;
            if (object2 instanceof VideoStreamComponent) {
                ++n8;
                bl = false;
                continue;
            }
            n5 = object2.width < n5 ? object2.width : n5;
            int n12 = n6 = object2.width < n6 ? object2.height : n6;
            if (!"".equals(object2.getGroupName())) {
                if (!"".equals(object2.getLedRgbGroupName())) {
                    treeSet.add(object2.getGroupName());
                    LinkedList<ContainerComponent> linkedList2 = (LinkedList<ContainerComponent>)treeMap.get(object2.getGroupName());
                    if (linkedList2 != null) {
                        linkedList2.add(object2);
                        treeMap.put(object2.getGroupName(), linkedList2);
                    } else {
                        linkedList2 = new LinkedList<ContainerComponent>();
                        linkedList2.add(object2);
                        treeMap.put(object2.getGroupName(), linkedList2);
                    }
                } else {
                    ++n8;
                    continue;
                }
            }
            ++n8;
            bl = false;
        }
        if (n8 == 0) {
            return new ImmutablePair((Object)1, (Object)1);
        }
        if (bl & linkedList.size() >= 3 && (n13 = this.calculateColsRowsForDIMMer(linkedList, n4)) != null) {
            return n13;
        }
        n8 += n2;
        n10 = n4 / (n5 + 5);
        if (n10 == 0) {
            n10 = 1;
        }
        if ((n11 = n8 / n10) * n10 < n8) {
            ++n11;
        }
        n7 = n4 / n10;
        for (ContainerComponent containerComponent : this.childs) {
            if (containerComponent instanceof Menu || containerComponent.getParent() == null) continue;
            if (containerComponent.width < n4) {
                if (containerComponent.width != n7) {
                    n9 += containerComponent.width / n7;
                }
            } else {
                n9 += n10;
                --n9;
            }
            ++n9;
        }
        n8 = n9 + n2;
        if (n8 > 0) {
            int n14;
            n10 = n4 / (n5 + 5);
            if (n10 == 0) {
                n10 = 1;
            }
            if (n10 > (n11 = n8 / n10) && (n11 = (n14 = n10)) * (n10 = n11) < n8) {
                ++n11;
            }
            if (n10 == 0) {
                n10 = 1;
            }
            n7 = n4 / n10;
        }
        if (n10 == 1 && n11 > 3 && (n11 = n8 / (n10 = (int)Math.sqrt(n8))) * n10 < n8) {
            ++n11;
        }
        Pair<Integer, Integer> pair = this.calculateColsAndRowsIncludeLedRGBGroup(treeMap, n5, n3, n4, n10, n11);
        n10 = (Integer)pair.getLeft();
        n11 = (Integer)pair.getRight();
        if (n11 * n10 < n8) {
            ++n11;
        }
        if ((n7 = n4 / n10) < n5) {
            int n14 = n10 * n11;
            n10 = n4 / n5;
            if (n10 == 0 || n11 == 0) {
                n10 = 1;
                n11 = 1;
            } else {
                n11 = n14 / n10;
                if (n10 * n11 < n14) {
                    ++n11;
                }
            }
            n7 = n4 / n10;
        }
        return new ImmutablePair((Object)n10, (Object)n11);
    }

    /*
     * Unable to fully structure code
     */
    private Pair<Integer, Integer> calculateColsRowsForDIMMer(LinkedList<ContainerComponent> var1_1, int var2_2) {
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = 1;
        var6_6 = 0;
        for (ContainerComponent var7_9 : var1_1) {
            if (var7_9 instanceof Menu || var7_9.getParent() == null) continue;
            if (var7_9 instanceof DiStateButton) {
                if (var7_9.getWidth() > var3_3) {
                    var3_3 = var7_9.getWidth();
                }
            } else if (var7_9 instanceof Slider && var7_9.getWidth() > var4_4) {
                var4_4 = var7_9.getWidth();
            }
            ++var6_6;
        }
        if (var6_6 % 2 != 0) {
            return null;
        }
        if (var3_3 + var4_4 + 5 <= var2_2 && var6_6 % 2 == 0) ** GOTO lbl24
        return new ImmutablePair((Object)1, (Object)var6_6);
lbl-1000:
        // 1 sources

        {
            var7_10 = var2_2 / var5_5;
            var8_8 = var3_3 / var7_10 + 1;
            if ((var8_8 += var4_4 / var7_10 + 1) <= var5_5) {
                return new ImmutablePair((Object)var5_5, (Object)(var6_6 / 2));
            }
            ++var5_5;
lbl24:
            // 2 sources

            ** while (var5_5 < var2_2)
        }
lbl25:
        // 1 sources

        return null;
    }

    private Pair<Integer, Integer> calculateColsAndRowsIncludeLedRGBGroup(Map<String, List<ContainerComponent>> map, int n2, int n3, int n4, int n5, int n6) {
        if (map == null || map.isEmpty()) {
            return new ImmutablePair((Object)n5, (Object)n6);
        }
        int n7 = n4 / n5;
        if (n7 < n2) {
            new ImmutablePair((Object)(n5 - 1), (Object)n6);
        }
        boolean bl = true;
        for (Map.Entry<String, List<ContainerComponent>> entry : map.entrySet()) {
            if (!bl) continue;
            List<ContainerComponent> list = entry.getValue();
            int n8 = n5;
            int n9 = n4 - 5;
            for (ContainerComponent containerComponent : list) {
                if ("Pokretlo_Kolor".equals(containerComponent.getDefaultSkinName())) continue;
                n8 -= containerComponent.width / n7 + 1;
                n9 -= containerComponent.width;
            }
            if (n9 < 0) {
                return new ImmutablePair((Object)1, (Object)n6);
            }
            if (n8 < 0) {
                return this.calculateColsAndRowsIncludeLedRGBGroup(map, n2, n3, n4, n5 + 1, n6);
            }
            bl = false;
        }
        return new ImmutablePair((Object)n5, (Object)n6);
    }

    private Menu getMenuIfExists() {
        for (ContainerComponent containerComponent : this.childs) {
            if (!(containerComponent instanceof Menu)) continue;
            return (Menu)containerComponent;
        }
        return null;
    }

    @Override
    public void setLocation(Point point) {
        Dimension dimension = point.getDifference(this.getLocation());
        if (dimension.equals(0, 0)) {
            return;
        }
        super.setLocation(point);
        this.ignoreChangesToChilds = true;
        for (ContainerComponent containerComponent : this.childs) {
            containerComponent.setLocation(containerComponent.getLocation().translate(dimension));
        }
        this.ignoreChangesToChilds = false;
        this.refresh();
    }

    @Override
    public void setSize(Dimension dimension) {
        if (this.getSize().equals((Object)dimension)) {
            return;
        }
        super.setSize(dimension);
        this.refresh();
    }

    public String getBackgroundFile() {
        return this.backgroundFile;
    }

    public void setBackgroundFile(String string) {
        this.backgroundFile = string;
        this.firePropertyChange(IMAGE_PROP, null, (Object)this.containerType);
    }

    public Container getTopContainer() {
        for (ContainerComponent containerComponent : this.childs) {
            if (!(containerComponent instanceof Container)) continue;
            return ((Container)containerComponent).getTopContainer();
        }
        return this;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public Container getRootContainer() {
        if (this.getParent() != null) {
            return this.getParent().getRootContainer();
        }
        return this;
    }

    public void setContainerType(ContainerType containerType) {
        this.containerType = containerType;
        this.firePropertyChange(CONTAINER_TYPE_PROP, null, (Object)containerType);
        this.refresh();
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public Element getXMLCode(Document document, Element element) {
        element.setAttribute(SKIN_ATTR, SkinType.NATIVE.toString());
        element.setAttribute(TYPE_ATTR, TYPE);
        element.setAttribute(LAYOUT_ATTR, ContainerType.values()[(Integer)this.getPropertyValue(CONTAINER_TYPE_PROP)].toString());
        element.setAttribute(BACKGROUND_IMAGE_ATTR, this.getBackgroundFile());
        element.setAttribute(BACKGROUND_ROTATE_IMAGE_ATTR, String.valueOf(this.getBackgroundRotateAngle()));
        element.setAttribute(WIDTH_ATTR, (String)this.getPropertyValue("Shape.Width"));
        element.setAttribute(HEIGHT_ATTR, (String)this.getPropertyValue("Shape.Height"));
        element.setAttribute(SCALE_BACKGROUND_ATTR, String.valueOf(this.scaleBackground));
        int n2 = this.getParent() != null ? Integer.valueOf((String)this.getParent().getPropertyValue("Shape.xPos")) : 0;
        int n3 = this.getParent() != null ? Integer.valueOf((String)this.getParent().getPropertyValue("Shape.yPos")) : 0;
        int n4 = Integer.valueOf((String)this.getPropertyValue("Shape.xPos")) - n2;
        int n5 = Integer.valueOf((String)this.getPropertyValue("Shape.yPos")) - n3;
        element.setAttribute("x", String.valueOf(n4));
        element.setAttribute("y", String.valueOf(n5));
        element.setAttribute("id", (String)this.getPropertyValue("Shape.id"));
        Element element2 = document.createElement(COMPONENTS_ELEMENT);
        for (ContainerComponent containerComponent : this.childs) {
            if (containerComponent instanceof Menu) continue;
            Element element3 = document.createElement(COMPONENT_ELEMENT);
            element2.appendChild(element3);
            element3.appendChild(containerComponent.getXMLCode(document, element3));
            element2.appendChild(element3);
        }
        return element2;
    }

    @Override
    public void readFromXML(Widget widget, Node node) {
        Map<String, String> map = Container.getAttributes((NodeList)((Object)node));
        ContainerType containerType = ContainerType.ABSOLUTE;
        if (map.get(LAYOUT_ATTR).equals(ContainerType.HORIZONTAL.toString())) {
            containerType = ContainerType.HORIZONTAL;
        } else if (map.get(LAYOUT_ATTR).equals(ContainerType.VERTICAL.toString())) {
            containerType = ContainerType.VERTICAL;
        }
        this.setContainerType(containerType);
        this.setPropertyValue(IMAGE_PROP, map.get(BACKGROUND_IMAGE_ATTR));
        this.setBackgroundRotateAngle(Integer.valueOf(map.get(BACKGROUND_ROTATE_IMAGE_ATTR)));
        this.getSkin().a(SkinType.valueOf(map.get(SKIN_ATTR).toUpperCase()));
        if (this.getSkin().a() != SkinType.NATIVE) {
            this.getSkin().a(map.get(SKIN_NAME_ATTR));
        }
        this.setPropertyValue("Shape.Width", map.get(WIDTH_ATTR));
        this.setPropertyValue("Shape.Height", map.get(HEIGHT_ATTR));
        this.setPropertyValue("Shape.xPos", map.get("x"));
        this.setPropertyValue("Shape.yPos", map.get("y"));
        String string = map.get(SCALE_BACKGROUND_ATTR);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            this.scaleBackground = Boolean.valueOf(string);
        }
        Node node2 = node.getFirstChild().getNextSibling();
        int n2 = 0;
        while (n2 < node2.getChildNodes().getLength()) {
            Node node3 = node2.getChildNodes().item(n2);
            ContainerComponent containerComponent = null;
            if (node3.getNodeType() == 1) {
                if (TYPE.equals(this.getComponentType(node3))) {
                    containerComponent = new Container();
                } else if ("button".equals(this.getComponentType(node3))) {
                    containerComponent = new Button();
                } else if ("toggleButton".equals(this.getComponentType(node3))) {
                    containerComponent = new DiStateButton();
                } else if ("radio".equals(this.getComponentType(node3))) {
                    containerComponent = new RadioButton();
                } else if ("link".equals(this.getComponentType(node3))) {
                    containerComponent = new LinkButton();
                } else if ("label".equals(this.getComponentType(node3))) {
                    containerComponent = new TextLabel();
                } else if ("slider".equals(this.getComponentType(node3))) {
                    containerComponent = new Slider();
                } else if ("gauge".equals(this.getComponentType(node3))) {
                    containerComponent = new Gauge();
                } else if ("image".equals(this.getComponentType(node3))) {
                    containerComponent = new ImageLabel();
                } else if ("camera".equals(this.getComponentType(node3))) {
                    containerComponent = new CameraButton();
                } else if ("intercom".equals(this.getComponentType(node3))) {
                    containerComponent = new IntercomButton();
                } else if ("videoStream".equals(this.getComponentType(node3))) {
                    containerComponent = new VideoStreamComponent();
                } else if ("gps".equals(this.getComponentType(node3))) {
                    containerComponent = new GPSComponent();
                } else if ("oneButton".equals(this.getComponentType(node3))) {
                    containerComponent = new OneButton();
                } else if ("beaconZone".equals(this.getComponentType(node3))) {
                    containerComponent = new BeaconZone();
                } else if ("ThermostatPanel".equals(this.getComponentType(node3))) {
                    containerComponent = new ThermostatPanel();
                } else if ("StatisticPanel".equals(this.getComponentType(node3))) {
                    containerComponent = new StatisticPanel();
                }
                if (containerComponent != null) {
                    ((ContainerComponent)containerComponent).readFromXML(widget, node3);
                    this.setIgnoreChangesToChilds(true);
                    this.addChild(containerComponent);
                }
            }
            ++n2;
        }
    }

    private String getComponentType(Node node) {
        if (node.getAttributes() == null || node.getAttributes().getNamedItem(TYPE_ATTR) == null) {
            return "";
        }
        DeferredAttrImpl deferredAttrImpl = (DeferredAttrImpl)node.getAttributes().getNamedItem(TYPE_ATTR);
        return deferredAttrImpl.getValue();
    }

    public void refresh() {
        if (this.ignoreChangesToChilds) {
            return;
        }
        this.refreshContainerSize();
        this.refreshChildsSize();
    }

    @Override
    public String getSkinTypeName() {
        return "MainContainer";
    }

    public boolean isAlreadyRefreshing() {
        return this.alreadyRefreshing;
    }

    public boolean isIgnoreChangesToChilds() {
        return this.ignoreChangesToChilds;
    }

    public void setIgnoreChangesToChilds(boolean bl) {
        this.ignoreChangesToChilds = bl;
    }

    public List<ContainerComponent> getCopiedChilds() {
        return this.copiedChilds;
    }

    public boolean isMain() {
        return this.isMain;
    }

    public void setMain(boolean bl) {
        this.isMain = bl;
    }

    public int getBackgroundRotateAngle() {
        return this.backgroundRotateAngle;
    }

    public void setBackgroundRotateAngle(int n2) {
        this.backgroundRotateAngle = n2;
    }

    public boolean isScaleBackground() {
        return this.scaleBackground;
    }

    public void setScaleBackground(boolean bl) {
        this.scaleBackground = bl;
    }

    @Override
    public boolean isSkinAble() {
        return this.isMain();
    }

    public void setShowingChessBoard(boolean bl) {
        this.firePropertyChange(SHOW_CHESS_BOARD_PROP, null, bl);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Container container = new Container();
        container.setParent(this.getParent());
        container.setSkin(this.getSkin());
        container.setSourceSyncTime(this.getSourceSyncTime());
        container.setInlineStyle(this.getInlineStyle());
        container.setClassProp(this.getClassProp());
        container.setInitialized(this.isInitialized());
        container.setOnline(this.isOnline());
        container.setSource(this.getSource());
        if (this.isCut()) {
            container.setId(this.getId());
        }
        container.eventsList = new ArrayList();
        if (this.getAvailableEvents() != null && !this.getAvailableEvents().isEmpty()) {
            for (String object : this.getAvailableEvents()) {
                container.eventsList.add(object);
            }
        }
        container.eventTypes = new HashMap();
        if (this.getEventTypes() != null && !this.getEventTypes().isEmpty()) {
            for (String string : this.getEventTypes().keySet()) {
                container.eventTypes.put(string, this.getEventTypes().get(string));
            }
        }
        for (ContainerComponent containerComponent : this.getCopiedChilds()) {
            container.getCopiedChilds().add(containerComponent);
        }
        container.setContainerType(this.getContainerType());
        container.setHighlighted(this.isHighlighted());
        container.setBackgroundFile(this.getBackgroundFile());
        container.setIgnoreChangesToChilds(this.isIgnoreChangesToChilds());
        container.setMain(this.isMain());
        container.setBackgroundRotateAngle(this.getBackgroundRotateAngle());
        container.setScaleBackground(this.isScaleBackground());
        container.setLocation(m.aX);
        container.setSize(this.getSize());
        container.setZ_index(this.getZ_index());
        return container;
    }

    public String toString() {
        return MessageFormat.format("Container [isMain={0}, containerType={1}, id={2}]", new Object[]{this.isMain, this.containerType, this.getId()});
    }

    public BeaconZone getBeaconZone() {
        return this.beaconZone;
    }

    public void setBeaconZone(BeaconZone beaconZone) {
        this.beaconZone = beaconZone;
    }

    public void setAppSkinName(String string) {
        this.appSkinName = string;
    }

    public String getAppSkinName() {
        return this.appSkinName;
    }

    public Point getStartSelectionOrigin() {
        return this.startSelectionOrigin;
    }

    public void setStartSelectionOrigin(Point point) {
        this.startSelectionOrigin = point;
    }
}

