/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.vb.model;

import com.grenton.om.exceptions.IncorrectCluCommandException;
import com.grenton.om.model.CLUCommand;
import com.grenton.om.model.OMLCommand;
import com.grenton.om.scripts.lua.preprocessing.OMLtoLUA;
import com.grenton.om.utils.Q;
import com.grenton.vb.g.b.a;
import com.grenton.vb.g.b.c;
import com.grenton.vb.h.b;
import com.grenton.vb.model.Button;
import com.grenton.vb.model.Component;
import com.grenton.vb.model.Container;
import com.grenton.vb.model.SkinType;
import com.grenton.vb.model.VBPageName;
import com.grenton.vb.model.page.VBComponentType;
import com.grenton.vb.properties.b.g;
import com.grenton.vb.properties.model.SkinProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DeferredElementImpl;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ContainerComponent
extends Component
implements Comparable<ContainerComponent> {
    private static final String GENERAL_NODE = "general";
    private static final String MISC_NODE = "misc";
    private static final String NAME_ATTR = "name";
    private static final String EVENTS_NODE = "events";
    private static final String SYNC_ATTR = "sync";
    private static final String APPEREANCE_ELEMENT = "appereance";
    protected static final String HEIGHT_ATTR = "height";
    protected static final String WIDTH_ATTR = "width";
    private static final String SKIN_NAME_ATTR = "skinName";
    private static final String SKIN_ATTR = "skin";
    private static final long serialVersionUID = -1787805255304235114L;
    public static final String SKIN_PROP = "SKIN";
    public static final String PARENT_PROP = "parent";
    public static final String FONT_PROP = "Font";
    public static final String MIN_VAL_PROP = "Shape.minValue";
    public static final String MAX_VAL_PROP = "Shape.maxValue";
    public static final String TEXT_PROP = "Shape.Text";
    private Container parent;
    private String treeObjectName;
    private VBPageName vbPageName;
    private VBComponentType vbComponentType = VBComponentType.SINGLE_OBJECT;
    private String groupName = "";
    private SkinProperties skin = new SkinProperties();
    private transient IPropertyDescriptor[] newDescriptors = new IPropertyDescriptor[]{new g("SKIN", "Skin", "Appereance", this.getSkinTypeName())};
    private transient boolean canChangeParent;
    protected boolean highlighted;
    protected String text = "";
    private String defaultSkinName = "";
    private static Logger log = Logger.getLogger(ContainerComponent.class);

    public ContainerComponent() {
        this.descriptorsList.addAll(Arrays.asList(this.newDescriptors));
    }

    @Override
    public void setPropertyValue(Object object, Object object2) {
        if (TEXT_PROP.equals(object)) {
            this.setText(String.valueOf(object2));
        } else if (SKIN_PROP.equals(object)) {
            this.setSkin((SkinProperties)object2);
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    @Override
    public Object getPropertyValue(Object object) {
        if (TEXT_PROP.equals(object)) {
            return this.getText();
        }
        if (SKIN_PROP.equals(object)) {
            return this.getSkin();
        }
        return super.getPropertyValue(object);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.firePropertyChange(TEXT_PROP, null, string);
    }

    boolean containsPoint(Point point) {
        Rectangle rectangle = new Rectangle(this.getLocation(), this.getSize());
        return rectangle.contains(point);
    }

    public boolean containsRect(Rectangle rectangle) {
        return rectangle.contains(new Rectangle(this.getLocation(), this.getSize()));
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container container) {
        if (this.parent != null && !this.parent.getChilds().isEmpty()) {
            this.parent.removeChild(this);
        }
        this.parent = container;
        if (container != null) {
            container.addChild(this);
            this.setZ_index(container.getZ_index() + 1);
        }
        this.firePropertyChange(PARENT_PROP, null, container);
    }

    public SkinProperties getSkin() {
        return this.skin;
    }

    public void setSkin(SkinProperties skinProperties) {
        this.skin = skinProperties;
        this.firePropertyChange(SKIN_PROP, null, skinProperties);
    }

    @Override
    public void setLocation(Point point) {
        Point point2 = this.getLocation();
        if (point2.equals((Object)point)) {
            return;
        }
        super.setLocation(point);
        if (this.parent != null) {
            this.parent.refresh();
        }
    }

    @Override
    public void setSize(Dimension dimension) {
        Dimension dimension2 = this.getSize();
        if (dimension2.equals((Object)dimension)) {
            return;
        }
        super.setSize(dimension);
        if (this.parent != null) {
            this.parent.refresh();
        }
    }

    public boolean isCanChangeParent() {
        return this.canChangeParent;
    }

    public void setCanChangeParent(boolean bl) {
        this.canChangeParent = bl;
    }

    public Element getXMLCode(Document document, Element element) {
        Element element2 = document.createElement(APPEREANCE_ELEMENT);
        element2.setAttribute(SKIN_ATTR, this.getSkin().a().toString());
        if (this.getSkin().a() != SkinType.NATIVE) {
            element2.setAttribute(SKIN_NAME_ATTR, this.getSkin().b());
        }
        this.generateDimensionAttributes(element2);
        int n2 = Integer.valueOf((String)this.getPropertyValue("Shape.xPos")) - (this.getParent() != null ? Integer.valueOf((String)this.getParent().getPropertyValue("Shape.xPos")) : 0);
        int n3 = Integer.valueOf((String)this.getPropertyValue("Shape.yPos")) - (this.getParent() != null ? Integer.valueOf((String)this.getParent().getPropertyValue("Shape.yPos")) : 0);
        element2.setAttribute("x", String.valueOf(n2));
        element2.setAttribute("y", String.valueOf(n3));
        element.appendChild(element2);
        return element2;
    }

    protected void generateDimensionAttributes(Element element) {
        String string;
        c c2;
        Image image = null;
        a a2 = b.d(this.getParent().getRootContainer().getAppSkinName());
        if (a2 != null && (c2 = a2.a(string = this.skin != null && this.skin.b() != null ? this.skin.b() : this.getDefaultSkinName(), this.getSkinTypeName())) != null) {
            image = b.a(a2.a(), c2.g(), c2.e());
        }
        if (image == null) {
            element.setAttribute(WIDTH_ATTR, (String)this.getPropertyValue("Shape.Width"));
            element.setAttribute(HEIGHT_ATTR, (String)this.getPropertyValue("Shape.Height"));
        } else {
            element.setAttribute(WIDTH_ATTR, String.valueOf(image.getBounds().width));
            element.setAttribute(HEIGHT_ATTR, String.valueOf(image.getBounds().height));
        }
    }

    public void readFromXML(Widget widget, Node node) {
        Map<String, String> map = this.getAppereanceAttributes(node);
        this.getSkin().a(SkinType.valueOf(map.get(SKIN_ATTR).toUpperCase()));
        if (this.getSkin().a() != SkinType.NATIVE) {
            this.getSkin().a(map.get(SKIN_NAME_ATTR));
        }
        this.setPropertyValue("Shape.Width", map.get(WIDTH_ATTR));
        this.setPropertyValue("Shape.Height", map.get(HEIGHT_ATTR));
        this.setPropertyValue("Shape.xPos", map.get("x"));
        this.setPropertyValue("Shape.yPos", map.get("y"));
    }

    public String changeOMcommandToCLUrequest(OMLCommand oMLCommand) {
        String string;
        if (oMLCommand.getOryginal().isEmpty()) {
            return "";
        }
        try {
            string = OMLtoLUA.translateExpression(oMLCommand);
        }
        catch (IncorrectCluCommandException incorrectCluCommandException) {
            log.warn((Object)"Can't change OM command to command for CLU. ", (Throwable)incorrectCluCommandException);
            return "";
        }
        CLUCommand cLUCommand = new CLUCommand(string);
        String string2 = new String(cLUCommand.getCommand());
        string2 = string2.replace(Q.a(), "local_ip");
        String string3 = String.valueOf(oMLCommand.getCLU().getIpAddress()) + " " + string2;
        return string3;
    }

    public abstract String getSkinTypeName();

    public abstract boolean isSkinAble();

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
        this.firePropertyChange("highlight", null, bl);
    }

    protected Map<String, String> getGeneralAttributes(Node node) {
        int n2 = 0;
        while (n2 < node.getChildNodes().getLength()) {
            String string;
            NodeList nodeList = (NodeList)((Object)node.getChildNodes().item(n2));
            if (nodeList instanceof DeferredElementImpl && GENERAL_NODE.equals(string = ((DeferredElementImpl)nodeList).getTagName())) {
                return ContainerComponent.getAttributes(nodeList);
            }
            nodeList.toString();
            ++n2;
        }
        return null;
    }

    protected Map<String, String> getMiscAttributes(Node node) {
        int n2 = 0;
        while (n2 < node.getChildNodes().getLength()) {
            String string;
            NodeList nodeList = (NodeList)((Object)node.getChildNodes().item(n2));
            if (nodeList instanceof DeferredElementImpl && MISC_NODE.equals(string = ((DeferredElementImpl)nodeList).getTagName())) {
                return ContainerComponent.getAttributes(nodeList);
            }
            nodeList.toString();
            ++n2;
        }
        return null;
    }

    protected Map<String, String> getAppereanceAttributes(Node node) {
        int n2 = 0;
        while (n2 < node.getChildNodes().getLength()) {
            String string;
            NodeList nodeList = (NodeList)((Object)node.getChildNodes().item(n2));
            if (nodeList instanceof DeferredElementImpl && APPEREANCE_ELEMENT.equals(string = ((DeferredElementImpl)nodeList).getTagName())) {
                return ContainerComponent.getAttributes(nodeList);
            }
            nodeList.toString();
            ++n2;
        }
        return null;
    }

    protected Map<String, OMLCommand> getEvents(Node node) {
        HashMap<String, OMLCommand> hashMap = new HashMap<String, OMLCommand>();
        int n2 = 0;
        while (n2 < node.getChildNodes().getLength()) {
            String string;
            Node node2 = node.getChildNodes().item(n2);
            if (node2.getNodeType() == 1 && EVENTS_NODE.equals(string = ((DeferredElementImpl)node2).getTagName())) {
                int n3 = 0;
                while (n3 < node2.getChildNodes().getLength()) {
                    NodeList nodeList = (NodeList)((Object)node2.getChildNodes().item(n3));
                    if (nodeList instanceof DeferredElementImpl) {
                        String string2 = ((DeferredElementImpl)nodeList).getFirstChild() != null ? ((DeferredElementImpl)nodeList).getFirstChild().getTextContent() : "";
                        string2 = this.prepareCmd(string2);
                        String string3 = ((DeferredElementImpl)nodeList).getAttribute(NAME_ATTR);
                        hashMap.put(string3, new OMLCommand(string2));
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return hashMap;
    }

    protected static Map<String, String> getAttributes(NodeList nodeList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = ((DeferredElementImpl)nodeList).getAttributes();
        int n2 = 0;
        while (n2 < namedNodeMap.getLength()) {
            Node node = namedNodeMap.item(n2);
            hashMap.put(node.getNodeName(), node.getNodeValue());
            ++n2;
        }
        return hashMap;
    }

    private String prepareCmd(String string) {
        String string2 = string;
        Pattern pattern = Pattern.compile("local_ip");
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            string2 = matcher.replaceFirst(Q.a());
        }
        return string2;
    }

    protected String getEventsSyncTime(Node node) {
        int n2 = 0;
        while (n2 < node.getChildNodes().getLength()) {
            String string;
            Node node2 = node.getChildNodes().item(n2);
            if (node2.getNodeType() == 1 && EVENTS_NODE.equals(string = ((DeferredElementImpl)node2).getTagName())) {
                return node2.getAttributes().getNamedItem(SYNC_ATTR).getNodeValue();
            }
            ++n2;
        }
        return "";
    }

    @Override
    public int compareTo(ContainerComponent containerComponent) {
        return this.text.compareTo(containerComponent.getText());
    }

    public String getTreeObjectName() {
        return this.treeObjectName;
    }

    public void setTreeObjectName(String string) {
        this.treeObjectName = string;
    }

    public String getDefaultSkinName() {
        return this.defaultSkinName;
    }

    public void setDefaultSkinName(String string) {
        this.defaultSkinName = this.getClass().equals(Button.class) && string.endsWith("_Toggle") ? (string = string.replaceAll("_Toggle", "")) : string;
    }

    public VBPageName getVbPageName() {
        return this.vbPageName;
    }

    public void setVbPageName(VBPageName vBPageName) {
        this.vbPageName = vBPageName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getLedRgbGroupName() {
        if (!"".equals(this.groupName) && this.groupName.startsWith("LED")) {
            return this.groupName;
        }
        return "";
    }

    public void setGroupName(String string) {
        if (string != null) {
            this.groupName = string;
        }
    }

    public VBComponentType getVbComponentType() {
        return this.vbComponentType;
    }

    public void setVbComponentType(VBComponentType vBComponentType) {
        this.vbComponentType = vBComponentType;
    }
}

