/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.vb.model;

import com.grenton.om.model.OMLCommand;
import com.grenton.om.utils.M;
import com.grenton.vb.i.b;
import com.grenton.vb.i.d;
import com.grenton.vb.model.ContainerComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Gauge
extends ContainerComponent
implements Cloneable {
    private static final long serialVersionUID = 7966418768481535063L;
    protected static final String TYPE = "gauge";
    private static int _count = 0;
    private static final String MAX_RANGE_NAME = "max";
    private static final String MIN_RANGE_NAME = "min";
    private List<String> graphicsList = new LinkedList<String>();
    private float maxValue = 100.0f;
    private float minValue = 0.0f;
    private boolean edited = false;
    private static transient Logger log = Logger.getLogger(Gauge.class);
    private transient IPropertyDescriptor[] newDescriptors;

    public Gauge() {
        ++_count;
        _count = this.generateId("Gauge", _count);
        this.newDescriptors = new IPropertyDescriptor[]{new com.grenton.vb.properties.b.d("Shape.Text", "Text", "General", null), new com.grenton.vb.properties.b.d(MAX_RANGE_NAME, "Max value", "General", new d()), new com.grenton.vb.properties.b.d(MIN_RANGE_NAME, "Min value", "General", new b())};
        this.descriptorsList.addAll(Arrays.asList(this.newDescriptors));
        this.size = new Dimension(120, 20);
    }

    @Override
    public Image getIcon() {
        return M.b("icons/vb/gauge16.png");
    }

    @Override
    public void setPropertyValue(Object object, Object object2) {
        if (MAX_RANGE_NAME.equals(object)) {
            this.setMaxValue(Float.valueOf(object2.toString()).floatValue());
        } else if (MIN_RANGE_NAME.equals(object)) {
            this.setMinValue(Float.valueOf(object2.toString()).floatValue());
        } else if ("Source".equals(object)) {
            OMLCommand oMLCommand = new OMLCommand(object2.toString());
            String[] stringArray = OMLCommand.getFeatureRangeInCommandIfExists(oMLCommand);
            if (stringArray != null && !this.edited) {
                this.setPropertyValue(MIN_RANGE_NAME, stringArray[0]);
                this.setPropertyValue(MAX_RANGE_NAME, stringArray[1]);
            }
            super.setPropertyValue(object, object2);
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    @Override
    public Object getPropertyValue(Object object) {
        if (MAX_RANGE_NAME.equals(object)) {
            return String.valueOf(this.getMaxValue());
        }
        if (MIN_RANGE_NAME.equals(object)) {
            return String.valueOf(this.getMinValue());
        }
        return super.getPropertyValue(object);
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float f2) {
        this.edited = true;
        this.minValue = f2;
        this.firePropertyChange("Shape.minValue", null, Float.valueOf(f2));
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float f2) {
        this.edited = true;
        this.maxValue = f2;
        this.firePropertyChange("Shape.maxValue", null, Float.valueOf(f2));
    }

    public List<String> getGraphicsList() {
        return this.graphicsList;
    }

    public void setGraphicsList(List<String> list) {
        this.graphicsList = list;
    }

    @Override
    public Element getXMLCode(Document document, Element element) {
        Element element2;
        element.appendChild(super.getXMLCode(document, element));
        element.setAttribute("type", TYPE);
        Element element3 = document.createElement("general");
        element3.setAttribute("id", (String)this.getPropertyValue("Shape.id"));
        element.appendChild(element3);
        element3.setAttribute("text", (String)this.getPropertyValue("Shape.Text"));
        element.appendChild(element3);
        Element element4 = document.createElement("events");
        element4.setAttribute("sync", (String)this.getPropertyValue("Source sync time"));
        for (String string : this.getAvailableEvents()) {
            element2 = document.createElement("event");
            element2.setAttribute("name", string);
            element2.appendChild(document.createTextNode(this.changeOMcommandToCLUrequest((OMLCommand)this.getPropertyValue(string))));
            element4.appendChild(element2);
        }
        element.appendChild(element4);
        element3 = document.createElement("misc");
        element3.setAttribute(MAX_RANGE_NAME, String.valueOf(this.getPropertyValue(MAX_RANGE_NAME)));
        element3.setAttribute(MIN_RANGE_NAME, String.valueOf(this.getPropertyValue(MIN_RANGE_NAME)));
        element.appendChild(element3);
        for (String string : this.graphicsList) {
            element2 = document.createElement("image");
            element2.appendChild(document.createTextNode(string));
            element4.appendChild(element2);
        }
        element.appendChild(element4);
        return element3;
    }

    @Override
    public void readFromXML(Widget widget, Node node) {
        super.readFromXML(widget, node);
        Map<String, String> map = this.getGeneralAttributes(node);
        Map<String, String> map2 = this.getMiscAttributes(node);
        this.setPropertyValue("Shape.Text", map.get("text"));
        this.setPropertyValue("Shape.id", map.get("id"));
        int n2 = 0;
        try {
            n2 = Integer.valueOf(this.getEventsSyncTime(node));
        }
        catch (Exception exception) {
            log.warn((Object)("Incorrect time of refreshing the component: " + this.toString()), (Throwable)exception);
        }
        this.setPropertyValue("Source sync time", n2);
        this.getEventTypes().putAll(this.getEvents(node));
        this.setPropertyValue(MAX_RANGE_NAME, map2.get(MAX_RANGE_NAME));
        this.setPropertyValue(MIN_RANGE_NAME, map2.get(MIN_RANGE_NAME));
    }

    @Override
    public String getSkinTypeName() {
        return TYPE;
    }

    @Override
    public boolean isSkinAble() {
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Gauge gauge = new Gauge();
        if (!this.getParent().isMain()) {
            gauge.setParent(this.getParent());
        }
        if (this.getSkin() != null) {
            gauge.setSkin(this.getSkin().e());
        }
        gauge.setSourceSyncTime(this.getSourceSyncTime());
        gauge.setInlineStyle(this.getInlineStyle());
        gauge.setClassProp(this.getClassProp());
        gauge.setInitialized(this.isInitialized());
        gauge.setOnline(this.isOnline());
        gauge.setSource(this.getSource());
        if (this.isCut()) {
            gauge.setId(this.getId());
        }
        gauge.eventsList = new ArrayList();
        if (this.getAvailableEvents() != null && !this.getAvailableEvents().isEmpty()) {
            for (String string : this.getAvailableEvents()) {
                gauge.eventsList.add(string);
            }
        }
        gauge.eventTypes = new HashMap();
        if (this.getEventTypes() != null && !this.getEventTypes().isEmpty()) {
            for (String string : this.getEventTypes().keySet()) {
                gauge.eventTypes.put(string, this.getEventTypes().get(string));
            }
        }
        gauge.setText(this.getText());
        gauge.setMaxValue(this.getMaxValue());
        gauge.setMinValue(this.getMinValue());
        gauge.graphicsList = new ArrayList<String>();
        if (this.getGraphicsList() != null && !this.getGraphicsList().isEmpty()) {
            for (String string : this.getGraphicsList()) {
                gauge.graphicsList.add(string);
            }
        }
        gauge.setLocation(this.getLocation());
        gauge.setSize(this.getSize());
        gauge.setZ_index(this.getZ_index());
        return gauge;
    }
}

