/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.vb.model;

import com.grenton.om.utils.M;
import com.grenton.vb.model.ContainerComponent;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImageLabel
extends ContainerComponent
implements Cloneable {
    private static final String IMG_ATTR = "img";
    private static final String MISC_ELEMENT = "misc";
    private static final String ID_ATTR = "id";
    private static final String GENERAL_ELEMENT = "general";
    private static final String TYPE_ATTR = "type";
    private static final long serialVersionUID = -1853735671634051227L;
    public static final String TYPE = "image";
    private static int _count = 0;
    private String fileName;
    private Dimension dimensions;

    public Dimension getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimension dimension) {
        this.dimensions = dimension;
    }

    public ImageLabel() {
        ++_count;
        _count = this.generateId("Image", _count);
    }

    @Override
    public Image getIcon() {
        return M.b("icons/vb/image16.png");
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    @Override
    public Element getXMLCode(Document document, Element element) {
        element.appendChild(super.getXMLCode(document, element));
        element.setAttribute(TYPE_ATTR, TYPE);
        Element element2 = document.createElement(GENERAL_ELEMENT);
        element2.setAttribute(ID_ATTR, (String)this.getPropertyValue("Shape.id"));
        element.appendChild(element2);
        element2 = document.createElement(MISC_ELEMENT);
        element2.setAttribute(IMG_ATTR, this.fileName);
        return element2;
    }

    @Override
    protected void generateDimensionAttributes(Element element) {
        element.setAttribute("width", String.valueOf(this.dimensions.width));
        element.setAttribute("height", String.valueOf(this.dimensions.height));
    }

    @Override
    public void readFromXML(Widget widget, Node node) {
        super.readFromXML(widget, node);
        Map<String, String> map = this.getGeneralAttributes(node);
        Map<String, String> map2 = this.getMiscAttributes(node);
        this.setPropertyValue("Shape.id", map.get(ID_ATTR));
        this.setFileName(map2.get(IMG_ATTR));
    }

    @Override
    public String getSkinTypeName() {
        return "";
    }

    @Override
    public boolean isSkinAble() {
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ImageLabel imageLabel = new ImageLabel();
        if (!this.getParent().isMain()) {
            imageLabel.setParent(this.getParent());
        }
        if (this.getSkin() != null) {
            imageLabel.setSkin(this.getSkin().e());
        }
        imageLabel.setSourceSyncTime(this.getSourceSyncTime());
        imageLabel.setInlineStyle(this.getInlineStyle());
        imageLabel.setClassProp(this.getClassProp());
        imageLabel.setInitialized(this.isInitialized());
        imageLabel.setOnline(this.isOnline());
        imageLabel.setSource(this.getSource());
        if (this.isCut()) {
            imageLabel.setId(this.getId());
        }
        imageLabel.eventsList = new ArrayList();
        if (this.getAvailableEvents() != null && !this.getAvailableEvents().isEmpty()) {
            for (String string : this.getAvailableEvents()) {
                imageLabel.eventsList.add(string);
            }
        }
        imageLabel.eventTypes = new HashMap();
        if (this.getEventTypes() != null && !this.getEventTypes().isEmpty()) {
            for (String string : this.getEventTypes().keySet()) {
                imageLabel.eventTypes.put(string, this.getEventTypes().get(string));
            }
        }
        imageLabel.setFileName(this.getFileName());
        imageLabel.setLocation(this.getLocation());
        imageLabel.setSize(this.getSize());
        imageLabel.setZ_index(this.getZ_index());
        imageLabel.dimensions = new Dimension(this.dimensions);
        return imageLabel;
    }
}

