/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.vb.model;

import com.grenton.om.model.OMLCommand;
import com.grenton.om.utils.M;
import com.grenton.vb.model.ContainerComponent;
import com.grenton.vb.properties.b.d;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RadioButton
extends ContainerComponent
implements Cloneable {
    private static final String ID_ATTR = "id";
    private static final long serialVersionUID = -1787805255304235113L;
    protected static final String TYPE = "radio";
    public static final int DefaultSize = 28;
    private static transient Logger log = Logger.getLogger(RadioButton.class);
    private static int _count = 0;

    public RadioButton() {
        ++_count;
        _count = this.generateId("RadioButton", _count);
        this.setSize(new Dimension(28, 28));
        IPropertyDescriptor[] iPropertyDescriptorArray = new IPropertyDescriptor[]{new d("Shape.Text", "Text", "General", null)};
        this.descriptorsList.addAll(Arrays.asList(iPropertyDescriptorArray));
    }

    @Override
    public Image getIcon() {
        return M.b("icons/vb/radio16.png");
    }

    @Override
    public boolean updateCLUReferences(String string, String string2) {
        return true;
    }

    @Override
    public Element getXMLCode(Document document, Element element) {
        element.appendChild(super.getXMLCode(document, element));
        element.setAttribute("type", TYPE);
        Element element2 = document.createElement("general");
        element2.setAttribute(ID_ATTR, (String)this.getPropertyValue("Shape.id"));
        element.appendChild(element2);
        element2.setAttribute("text", (String)this.getPropertyValue("Shape.Text"));
        element.appendChild(element2);
        Element element3 = document.createElement("events");
        element3.setAttribute("sync", (String)this.getPropertyValue("Source sync time"));
        for (String string : this.getAvailableEvents()) {
            Element element4 = document.createElement("event");
            element4.setAttribute("name", string);
            element4.appendChild(document.createTextNode(this.changeOMcommandToCLUrequest((OMLCommand)this.getPropertyValue(string))));
            element3.appendChild(element4);
        }
        element.appendChild(element3);
        return element2;
    }

    @Override
    public void readFromXML(Widget widget, Node node) {
        super.readFromXML(widget, node);
        Map<String, String> map = this.getGeneralAttributes(node);
        this.setPropertyValue("Shape.id", map.get(ID_ATTR));
        this.setPropertyValue("Shape.Text", map.get("text"));
        int n2 = 0;
        try {
            n2 = Integer.valueOf(this.getEventsSyncTime(node));
        }
        catch (Exception exception) {
            log.warn((Object)("Incorrect time of refreshing the component " + this.toString()), (Throwable)exception);
        }
        this.setPropertyValue("Source sync time", n2);
        this.getEventTypes().putAll(this.getEvents(node));
    }

    @Override
    public String getSkinTypeName() {
        return TYPE;
    }

    @Override
    public boolean isSkinAble() {
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RadioButton radioButton = new RadioButton();
        if (!this.getParent().isMain()) {
            radioButton.setParent(this.getParent());
        }
        if (this.getSkin() != null) {
            radioButton.setSkin(this.getSkin().e());
        }
        radioButton.setSourceSyncTime(this.getSourceSyncTime());
        radioButton.setInlineStyle(this.getInlineStyle());
        radioButton.setClassProp(this.getClassProp());
        radioButton.setInitialized(this.isInitialized());
        radioButton.setOnline(this.isOnline());
        radioButton.setSource(this.getSource());
        if (this.isCut()) {
            radioButton.setId(this.getId());
        }
        radioButton.eventsList = new ArrayList();
        if (this.getAvailableEvents() != null && !this.getAvailableEvents().isEmpty()) {
            for (String string : this.getAvailableEvents()) {
                radioButton.eventsList.add(string);
            }
        }
        radioButton.eventTypes = new HashMap();
        if (this.getEventTypes() != null && !this.getEventTypes().isEmpty()) {
            for (String string : this.getEventTypes().keySet()) {
                radioButton.eventTypes.put(string, this.getEventTypes().get(string));
            }
        }
        radioButton.setText(this.getText());
        radioButton.setLocation(this.getLocation());
        radioButton.setSize(this.getSize());
        radioButton.setZ_index(this.getZ_index());
        return radioButton;
    }
}

