/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.vb.model;

import com.grenton.om.model.OMLCommand;
import com.grenton.om.utils.M;
import com.grenton.vb.i.b;
import com.grenton.vb.i.d;
import com.grenton.vb.model.ContainerComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Slider
extends ContainerComponent
implements Cloneable {
    private static final String VALUE_ATTR = "value";
    private static final String MIN_ATTR = "min";
    private static final String MAX_ATTR = "max";
    private static final String NAME_ATTR = "name";
    private static final String SYNC_ATTR = "sync";
    private static final String ID_ATTR = "id";
    private static final String TYPE_ATTR = "type";
    private static final long serialVersionUID = 7966418768481535063L;
    protected static final String TYPE = "slider";
    private static int _count = 0;
    public static final int HORIZONTAL_ORIENTATION = 0;
    public static final int VERTICAL_ORIENTATION = 1;
    public static final String ON_SLIDE_PROP = "ONSLIDE";
    private static final String HORIZONTAL_ORIENTATION_NAME = "horizontal";
    private static final String VERTICAL_ORIENTATION_NAME = "vertical";
    private static final String CIRCLE_ORIENTATION_NAME = "vertical";
    private static final String ORIENTATION_PROP = "Shape.orientation";
    private static final String VALUE_PROP = "Shape.value";
    private float minValue = 0.0f;
    private float maxValue = 100.0f;
    private float value = 0.0f;
    private int orientation = 0;
    private boolean edited = false;
    private OMLCommand onSlide = new OMLCommand("");
    private transient IPropertyDescriptor[] newDescriptors;
    private static Logger log = Logger.getLogger(Slider.class);

    public Slider() {
        ++_count;
        _count = this.generateId("Slider", _count);
        this.eventsList.add(ON_SLIDE_PROP);
        this.eventTypes.put(ON_SLIDE_PROP, new OMLCommand(""));
        this.newDescriptors = new IPropertyDescriptor[]{new com.grenton.vb.properties.b.d(VALUE_PROP, "Value", "General", new d()), new com.grenton.vb.properties.b.d("Shape.minValue", "Min value", "General", new b()), new com.grenton.vb.properties.b.d("Shape.maxValue", "Max value", "General", new d()), new com.grenton.vb.properties.b.d("Shape.Text", "Text", "General", null), new com.grenton.vb.properties.b.d(ON_SLIDE_PROP, "onSlide", "Events", null)};
        this.descriptorsList.addAll(Arrays.asList(this.newDescriptors));
        this.size = new Dimension(120, 28);
        this.width = 150;
        this.height = 15;
    }

    public void setOnSlide(OMLCommand oMLCommand) {
        this.onSlide = oMLCommand;
        this.firePropertyChange(ON_SLIDE_PROP, null, oMLCommand);
    }

    public OMLCommand getOnSlide() {
        return this.onSlide;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float f2) {
        this.edited = true;
        this.minValue = f2;
        this.firePropertyChange("Shape.minValue", null, Float.valueOf(f2));
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float f2) {
        this.edited = true;
        this.maxValue = f2;
        this.firePropertyChange("Shape.maxValue", null, Float.valueOf(f2));
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n2) {
        int n3 = this.orientation;
        this.orientation = n2;
        this.firePropertyChange(ORIENTATION_PROP, null, n2);
        if (n3 == 1 && n2 == 0 || n3 == 0 && n2 == 1) {
            this.setSize(new Dimension(this.getSize().height, this.getSize().width));
        }
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float f2) {
        this.value = f2;
        this.firePropertyChange(VALUE_ATTR, null, Float.valueOf(f2));
    }

    @Override
    public Image getIcon() {
        return M.b("icons/vb/slider16.png");
    }

    @Override
    public void setPropertyValue(Object object, Object object2) {
        if ("Shape.minValue".equals(object)) {
            this.setMinValue(Float.valueOf(object2.toString()).floatValue());
        } else if ("Shape.maxValue".equals(object)) {
            this.setMaxValue(Float.valueOf(object2.toString()).floatValue());
        } else if (ORIENTATION_PROP.equals(object)) {
            this.setOrientation(Integer.valueOf(object2.toString()));
        } else if (VALUE_PROP.equals(object)) {
            this.setValue(Float.valueOf(object2.toString()).floatValue());
        } else if (ON_SLIDE_PROP.equals(object)) {
            this.setOnSlide((OMLCommand)object2);
            OMLCommand oMLCommand = new OMLCommand(object2.toString());
            String[] stringArray = OMLCommand.getFeatureRangeInCommandIfExists(oMLCommand);
            if (stringArray != null && !this.edited) {
                this.setPropertyValue("Shape.minValue", stringArray[0]);
                this.setPropertyValue("Shape.maxValue", stringArray[1]);
            }
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    @Override
    public Object getPropertyValue(Object object) {
        if (VALUE_PROP.equals(object)) {
            return String.valueOf(this.value);
        }
        if ("Shape.minValue".equals(object)) {
            return String.valueOf(this.minValue);
        }
        if ("Shape.maxValue".equals(object)) {
            return String.valueOf(this.maxValue);
        }
        if (ORIENTATION_PROP.equals(object)) {
            return this.orientation;
        }
        if (ON_SLIDE_PROP.equals(object)) {
            return this.getOnSlide();
        }
        return super.getPropertyValue(object);
    }

    public String getOrientationName() {
        if (this.orientation == 0) {
            return HORIZONTAL_ORIENTATION_NAME;
        }
        if (this.orientation == 1) {
            return "vertical";
        }
        return "vertical";
    }

    @Override
    public boolean updateCLUReferences(String string, String string2) {
        String string3 = this.onSlide.getOryginal();
        boolean bl = string3.indexOf(string) != -1;
        this.onSlide = new OMLCommand(string3.replaceAll(string, string2));
        return bl || super.updateCLUReferences(string, string2);
    }

    @Override
    public Element getXMLCode(Document document, Element element) {
        Element element2 = super.getXMLCode(document, element);
        element.appendChild(element2);
        element.setAttribute(TYPE_ATTR, TYPE);
        Element element3 = document.createElement("general");
        element3.setAttribute(ID_ATTR, (String)this.getPropertyValue("Shape.id"));
        element.appendChild(element3);
        element3.setAttribute("text", (String)this.getPropertyValue("Shape.Text"));
        element.appendChild(element3);
        Element element4 = document.createElement("events");
        element4.setAttribute(SYNC_ATTR, (String)this.getPropertyValue("Source sync time"));
        for (String string : this.getAvailableEvents()) {
            Element element5 = document.createElement("event");
            element5.setAttribute(NAME_ATTR, string);
            element5.appendChild(document.createTextNode(this.changeOMcommandToCLUrequest((OMLCommand)this.getPropertyValue(string))));
            element4.appendChild(element5);
        }
        element.appendChild(element4);
        element3 = document.createElement("misc");
        element3.setAttribute(MAX_ATTR, String.valueOf(this.getPropertyValue("Shape.maxValue")));
        element.appendChild(element3);
        element3.setAttribute(MIN_ATTR, String.valueOf(this.getPropertyValue("Shape.minValue")));
        element.appendChild(element3);
        element3.setAttribute(VALUE_ATTR, String.valueOf(this.getPropertyValue(VALUE_PROP)));
        element.appendChild(element3);
        return element3;
    }

    @Override
    public void readFromXML(Widget widget, Node node) {
        super.readFromXML(widget, node);
        Map<String, String> map = this.getGeneralAttributes(node);
        Map<String, String> map2 = this.getMiscAttributes(node);
        this.setPropertyValue("Shape.Text", map.get("text"));
        this.setPropertyValue("Shape.id", map.get(ID_ATTR));
        int n2 = 0;
        try {
            n2 = Integer.valueOf(this.getEventsSyncTime(node));
        }
        catch (Exception exception) {
            log.warn((Object)("Incorrect time of refreshing the component " + this.toString()), (Throwable)exception);
        }
        this.setPropertyValue("Source sync time", n2);
        this.getEventTypes().putAll(this.getEvents(node));
        this.setPropertyValue("Shape.maxValue", map2.get(MAX_ATTR));
        this.setPropertyValue("Shape.minValue", map2.get(MIN_ATTR));
        this.setPropertyValue(VALUE_PROP, map2.get(VALUE_ATTR));
    }

    @Override
    public String getSkinTypeName() {
        return TYPE;
    }

    @Override
    public boolean isSkinAble() {
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Slider slider = new Slider();
        if (!this.getParent().isMain()) {
            slider.setParent(this.getParent());
        }
        if (this.getSkin() != null) {
            slider.setSkin(this.getSkin().e());
        }
        slider.setSourceSyncTime(this.getSourceSyncTime());
        slider.setInlineStyle(this.getInlineStyle());
        slider.setClassProp(this.getClassProp());
        slider.setInitialized(this.isInitialized());
        slider.setOnline(this.isOnline());
        slider.setSource(this.getSource());
        if (this.isCut()) {
            slider.setId(this.getId());
        }
        slider.eventsList = new ArrayList();
        if (this.getAvailableEvents() != null && !this.getAvailableEvents().isEmpty()) {
            for (String string : this.getAvailableEvents()) {
                slider.eventsList.add(string);
            }
        }
        slider.eventTypes = new HashMap();
        if (this.getEventTypes() != null && !this.getEventTypes().isEmpty()) {
            for (String string : this.getEventTypes().keySet()) {
                slider.eventTypes.put(string, this.getEventTypes().get(string));
            }
        }
        slider.setText(this.getText());
        slider.setMinValue(this.getMinValue());
        slider.setMaxValue(this.getMaxValue());
        slider.setValue(this.getValue());
        slider.setOrientation(this.getOrientation());
        slider.setOnSlide(this.getOnSlide());
        slider.setLocation(this.getLocation());
        slider.setSize(this.getSize());
        slider.setZ_index(this.getZ_index());
        return slider;
    }

    @Override
    public List<OMLCommand> getAllOMLCommands() {
        List<OMLCommand> list = super.getAllOMLCommands();
        list.add(this.getOnSlide());
        return list;
    }
}

