/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.vb.model;

import com.grenton.om.model.OMLCommand;
import com.grenton.om.utils.M;
import com.grenton.vb.model.ContainerComponent;
import com.grenton.vb.model.TextLabel$1;
import com.grenton.vb.properties.b.a;
import com.grenton.vb.properties.b.e;
import com.grenton.vb.properties.model.BackgroundProperty;
import com.grenton.vb.properties.model.BackgroundProperty$Value;
import com.grenton.vb.properties.model.FontProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TextLabel
extends ContainerComponent
implements Cloneable {
    private static final String DEFAULT_TEXT = "Text $value$";
    private static final String NAME_ATTR = "name";
    private static final String SYNC_ATTR = "sync";
    private static final String ID_ATTR = "id";
    private static final String TEXT_ATTR = "text";
    private static final String TYPE_ATTR = "type";
    private static final String TEXT_WIDTH = "width";
    private static final long serialVersionUID = -6658418475865647569L;
    protected static final String TYPE = "label";
    private static int _count = 0;
    private static final String TEXT_PROP = "Shape.Text";
    public static final String BACK_PROP = "BackColor";
    private static final String TRANSPARENT_FLAG = "TRANSPARENT";
    private static transient Logger log = Logger.getLogger(TextLabel.class);
    private transient IPropertyDescriptor[] newDescriptors;
    private String value = "";
    private FontProperties font;
    private BackgroundProperty backgroundProperties = new BackgroundProperty((Object)BackgroundProperty$Value.TRANSPARENT);

    public TextLabel() {
        this.font = new FontProperties();
        ++_count;
        _count = this.generateId("Label", _count);
        this.newDescriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)TEXT_PROP, "Text"), new e("Font", "Font"), new a(BACK_PROP, "Background")};
        this.descriptorsList.addAll(Arrays.asList(this.newDescriptors));
        this.setText(DEFAULT_TEXT);
        Dimension dimension = this.getSize();
        dimension.width = 74;
        this.setSize(dimension);
    }

    @Override
    public Image getIcon() {
        return M.b("icons/vb/txt16.png");
    }

    public void setFont(FontProperties fontProperties) {
        this.font = fontProperties;
        this.firePropertyChange("Font", null, fontProperties);
    }

    public FontProperties getFont() {
        return this.font;
    }

    public BackgroundProperty getBackgroundProperties() {
        return this.backgroundProperties;
    }

    public void setBackgroundProperties(BackgroundProperty backgroundProperty) {
        this.backgroundProperties = backgroundProperty;
        this.firePropertyChange(BACK_PROP, null, backgroundProperty);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    @Override
    public void setPropertyValue(Object object, Object object2) {
        if (TEXT_PROP.equals(object)) {
            this.setText(String.valueOf(object2));
        } else if ("Font".equals(object)) {
            this.setFont((FontProperties)object2);
        } else if (BACK_PROP.equals(object)) {
            this.setBackgroundProperties((BackgroundProperty)object2);
        } else if ("SKIN".equals(object)) {
            super.setPropertyValue(object, object2);
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    @Override
    public Object getPropertyValue(Object object) {
        if (TEXT_PROP.equals(object)) {
            return this.text;
        }
        if ("Font".equals(object)) {
            return this.font;
        }
        if (BACK_PROP.equals(object)) {
            return this.backgroundProperties;
        }
        return super.getPropertyValue(object);
    }

    public String getDataParams() {
        return "value=" + this.value;
    }

    @Override
    public Element getXMLCode(Document document, Element element) {
        element.appendChild(super.getXMLCode(document, element));
        element.setAttribute(TYPE_ATTR, TYPE);
        Element element2 = document.createElement("general");
        element2.setAttribute(TEXT_ATTR, (String)this.getPropertyValue(TEXT_PROP));
        element2.setAttribute(ID_ATTR, (String)this.getPropertyValue("Shape.id"));
        element.appendChild(element2);
        Element element3 = document.createElement("events");
        element3.setAttribute(SYNC_ATTR, (String)this.getPropertyValue("Source sync time"));
        for (String string : this.getAvailableEvents()) {
            Element element4 = document.createElement("event");
            element4.setAttribute(NAME_ATTR, string);
            element4.appendChild(document.createTextNode(this.changeOMcommandToCLUrequest((OMLCommand)this.getPropertyValue(string))));
            element3.appendChild(element4);
        }
        element.appendChild(element3);
        element2 = document.createElement("misc");
        BackgroundProperty backgroundProperty = this.getBackgroundProperties();
        if (backgroundProperty != null && backgroundProperty.a() == BackgroundProperty$Value.TRANSPARENT) {
            element2.setAttribute("backgroundColor", TRANSPARENT_FLAG);
        } else if (backgroundProperty != null && backgroundProperty.a() instanceof RGB) {
            RGB rGB = (RGB)backgroundProperty.a();
            element2.setAttribute("backgroundColor", String.format("RGB {%1$d, %2$d, %3$d}", rGB.red, rGB.green, rGB.blue));
        }
        for (Map.Entry entry : this.font.d().entrySet()) {
            element2.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        element2.setAttribute(TEXT_WIDTH, String.valueOf(this.getTextWidth()));
        element.appendChild(element2);
        return element2;
    }

    private int getTextWidth() {
        AtomicInteger atomicInteger = new AtomicInteger();
        Display display = Display.getDefault();
        display.syncExec((Runnable)new TextLabel$1(this, display, atomicInteger));
        return atomicInteger.get();
    }

    @Override
    protected void generateDimensionAttributes(Element element) {
        element.setAttribute(TEXT_WIDTH, (String)this.getPropertyValue("Shape.Width"));
        element.setAttribute("height", (String)this.getPropertyValue("Shape.Height"));
    }

    @Override
    public void readFromXML(Widget widget, Node node) {
        super.readFromXML(widget, node);
        Map<String, String> map = this.getGeneralAttributes(node);
        Map<String, String> map2 = this.getMiscAttributes(node);
        this.setPropertyValue(TEXT_PROP, map.get(TEXT_ATTR));
        this.setPropertyValue("Shape.id", map.get(ID_ATTR));
        int n2 = 0;
        try {
            n2 = Integer.valueOf(this.getEventsSyncTime(node));
        }
        catch (Exception exception) {
            log.warn((Object)("Incorrect time of refreshing the component: " + this.toString()), (Throwable)exception);
        }
        this.setPropertyValue("Source sync time", n2);
        this.getEventTypes().putAll(this.getEvents(node));
        this.font.a(map2);
        this.setPropertyValue(BACK_PROP, map.get("backgroundColor"));
    }

    @Override
    public String getSkinTypeName() {
        return "";
    }

    @Override
    public boolean isSkinAble() {
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TextLabel textLabel = new TextLabel();
        if (!this.getParent().isMain()) {
            textLabel.setParent(this.getParent());
        }
        if (this.getSkin() != null) {
            textLabel.setSkin(this.getSkin().e());
        }
        textLabel.setSourceSyncTime(this.getSourceSyncTime());
        textLabel.setInlineStyle(this.getInlineStyle());
        textLabel.setClassProp(this.getClassProp());
        textLabel.setInitialized(this.isInitialized());
        textLabel.setOnline(this.isOnline());
        textLabel.setSource(this.getSource());
        if (this.isCut()) {
            textLabel.setId(this.getId());
        }
        textLabel.eventsList = new ArrayList();
        if (this.getAvailableEvents() != null && !this.getAvailableEvents().isEmpty()) {
            for (String string : this.getAvailableEvents()) {
                textLabel.eventsList.add(string);
            }
        }
        textLabel.eventTypes = new HashMap();
        if (this.getEventTypes() != null && !this.getEventTypes().isEmpty()) {
            for (String string : this.getEventTypes().keySet()) {
                textLabel.eventTypes.put(string, this.getEventTypes().get(string));
            }
        }
        textLabel.setText(this.getText());
        textLabel.setValue(this.getValue());
        textLabel.setFont(this.getFont());
        textLabel.setBackgroundProperties(this.getBackgroundProperties());
        textLabel.setLocation(this.getLocation());
        textLabel.setSize(this.getSize());
        textLabel.setZ_index(this.getZ_index());
        return textLabel;
    }
}

