/*
 * Decompiled with CFR 0.152.
 */
package com.grenton.vb.model.panel;

import com.grenton.om.model.OMLCommand;
import com.grenton.om.utils.M;
import com.grenton.vb.model.ContainerComponent;
import com.grenton.vb.properties.model.FontProperties;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class VBPanel
extends ContainerComponent
implements Cloneable {
    private static final long serialVersionUID = 2859000248441805141L;
    protected static final String ID_ATTR = "id";
    protected static final String TEXT_ATTR = "text";
    private static final String TYPE_ATTR = "type";
    private static final String GENERAL_ELEMENT = "general";
    private static final String MISC_ELEMENT = "misc";
    protected static int _count = 0;
    private FontProperties font;
    private Map<String, String> customNames = new TreeMap<String, String>();

    public VBPanel() {
        this.setId("ThermostatPanel" + _count++);
        this.font = new FontProperties();
        this.font.a(ColorConstants.blue.getRGB());
        this.font.b().setStyle(2);
        this.descriptorsList.clear();
    }

    public FontProperties getFont() {
        return this.font;
    }

    public abstract String getName();

    @Override
    public void setPropertyValue(Object object, Object object2) {
        if ("Shape.Text".equals(object)) {
            this.setText(String.valueOf(object2));
        } else if ("Font".equals(object)) {
            this.setFont((FontProperties)object2);
        } else if ("CustomName".equals(object)) {
            Map map = (Map)object2;
            this.setCustomNames(map);
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    @Override
    public Object getPropertyValue(Object object) {
        if ("Shape.Text".equals(object)) {
            return this.text;
        }
        if ("Font".equals(object)) {
            return this.getFont();
        }
        if ("CustomName".equals(object)) {
            return this.getCustomNames();
        }
        return super.getPropertyValue(object);
    }

    @Override
    public boolean updateCLUReferences(String string, String string2) {
        return false;
    }

    public void setFont(FontProperties fontProperties) {
        this.font = fontProperties;
        this.firePropertyChange("Font", null, fontProperties);
    }

    @Override
    public String getSkinTypeName() {
        return "";
    }

    @Override
    public boolean isSkinAble() {
        return false;
    }

    @Override
    public Image getIcon() {
        return M.b("icons/vb/button16.png");
    }

    @Override
    public Element getXMLCode(Document document, Element element) {
        element.appendChild(super.getXMLCode(document, element));
        element.setAttribute(TYPE_ATTR, this.getType());
        Element element2 = document.createElement(GENERAL_ELEMENT);
        element2.setAttribute(TEXT_ATTR, (String)this.getPropertyValue("Shape.Text"));
        element.appendChild(element2);
        element2.setAttribute(ID_ATTR, (String)this.getPropertyValue("Shape.id"));
        element.appendChild(element2);
        Element element3 = document.createElement("objects");
        OMLCommand oMLCommand = (OMLCommand)this.getPropertyValue("Source");
        String string = oMLCommand.toString();
        String[] stringArray = string.split("\\|");
        for (String object : Arrays.asList(stringArray)) {
            OMLCommand oMLCommand2 = new OMLCommand(object);
            Element element4 = document.createElement("object");
            element4.setAttribute("clu", oMLCommand2.getCluName());
            element4.setAttribute("name", oMLCommand2.getFeatureName());
            element4.setAttribute("customName", this.customNames.get(oMLCommand2.getFeatureName()));
            element3.appendChild(element4);
        }
        element.appendChild(element3);
        element2 = document.createElement(MISC_ELEMENT);
        for (Map.Entry entry : this.getFont().d().entrySet()) {
            element2.setAttribute((String)entry.getKey(), (String)entry.getValue());
        }
        return element2;
    }

    public abstract String getType();

    public Map<String, String> getCustomNames() {
        return this.customNames;
    }

    public void setCustomNames(Map<String, String> map) {
        this.customNames = map;
    }
}

