package mygrenton.templates

import com.grenton.om.mobile.dto.VirtualObjectDto
import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetAudioRemoteControl
import com.grenton.om.mobile.entity.widget.objects.WidgetAudioRemoteControlObject
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetAudioRemoteControl emptyWidget = createWidget()

def getWidgetType() {
    return "AUDIO_REMOTE_CONTROL"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 18
}

WidgetAudioRemoteControl createWidget(){
    WidgetAudioRemoteControl widget = new WidgetAudioRemoteControl();
    widget.setType("AUDIO_REMOTE_CONTROL")
    widget.setId(0)
    widget.setIcon("speaker")
    WidgetAudioRemoteControlObject object = new WidgetAudioRemoteControlObject()
    widget.setObject(object)
    return widget;
}

def setObjectValuesForEmptyWidget(WidgetAudioRemoteControlObject object){
    object.setTrackTitle(GroovyUtils.createEmptyStateEntity())
    object.setArtistName(GroovyUtils.createEmptyStateEntity())
    object.setInitAction(GroovyUtils.createEmptyAbstractAction())
    object.setOnAction(GroovyUtils.createEmptyAbstractAction())
    object.setOffAction(GroovyUtils.createEmptyAbstractAction())
    object.setPreviousAction(GroovyUtils.createEmptyAbstractAction())
    object.setPauseAction(GroovyUtils.createEmptyAbstractAction())
    object.setPlayAction(GroovyUtils.createEmptyAbstractAction())
    object.setNextAction(GroovyUtils.createEmptyAbstractAction())
    object.setVolumeDownAction(GroovyUtils.createEmptyAbstractAction())
    object.setVolumeUpAction(GroovyUtils.createEmptyAbstractAction())
    object.setMuteAction(GroovyUtils.createEmptyAbstractAction())
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setLabel(textResources.getString("audioRemoteControl"))
    setObjectValuesForEmptyWidget(emptyWidget.getObject())
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetAudioRemoteControl widget = createWidget()
    widget.setLabel(projectElementDto.getLabel())
    if(projectElementDto instanceof VirtualObjectDto){
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if(virtualObjectDto.getObjectTypeId() == 260) {
            widget.setObject(createSonosWidgetObjectFromDto(virtualObjectDto))
        } else if (virtualObjectDto.getObjectTypeId() == 261) {
            widget.setObject(createMusicCastWidgetObjectFromDto(virtualObjectDto))
        } else if (virtualObjectDto.getObjectTypeId() == 262) {
            widget.setObject(createHeosWidgetObjectFromDto(virtualObjectDto))
        } else if (virtualObjectDto.getObjectTypeId() == 264) {
            widget.setObject(createDenonMaranzWidgetObjectFromDto(virtualObjectDto))
        }
    }
    return widget;
}

def isSupported(ProjectElementDto projectElementDto) {
    if (projectElementDto instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if (virtualObjectDto.getObjectTypeId() == 260
                || virtualObjectDto.getObjectTypeId() == 261
                || virtualObjectDto.getObjectTypeId() == 262
                || virtualObjectDto.getObjectTypeId() == 264) {
            return true
        }
    }
    return false
}

def createSonosWidgetObjectFromDto(VirtualObjectDto virtualObjectDto) {
    WidgetAudioRemoteControlObject widgetAudioRemoteControlObject = new WidgetAudioRemoteControlObject()

    widgetAudioRemoteControlObject.setArtistName(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "6"))
    widgetAudioRemoteControlObject.setTrackTitle(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "7"))

    widgetAudioRemoteControlObject.setPlayAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "0"))
    widgetAudioRemoteControlObject.setPauseAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "1"))
    widgetAudioRemoteControlObject.setNextAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "3"))
    widgetAudioRemoteControlObject.setPreviousAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "4"))
    widgetAudioRemoteControlObject.setVolumeUpAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "5", "5"))
    widgetAudioRemoteControlObject.setVolumeDownAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "5", "6"))
    widgetAudioRemoteControlObject.setMuteAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "7"))
    widgetAudioRemoteControlObject.setInitAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "8"))

    return widgetAudioRemoteControlObject
}

def createMusicCastWidgetObjectFromDto(VirtualObjectDto virtualObjectDto) {
    WidgetAudioRemoteControlObject widgetAudioRemoteControlObject = new WidgetAudioRemoteControlObject()

    widgetAudioRemoteControlObject.setArtistName(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "6"))
    widgetAudioRemoteControlObject.setTrackTitle(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "7"))

    widgetAudioRemoteControlObject.setPlayAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "0"))
    widgetAudioRemoteControlObject.setPauseAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "1"))
    widgetAudioRemoteControlObject.setNextAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "3"))
    widgetAudioRemoteControlObject.setPreviousAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "4"))
    widgetAudioRemoteControlObject.setVolumeUpAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "5", "5"))
    widgetAudioRemoteControlObject.setVolumeDownAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "5", "6"))
    widgetAudioRemoteControlObject.setMuteAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "7"))
    widgetAudioRemoteControlObject.setInitAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "8"))

    widgetAudioRemoteControlObject.setOnAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "1", "11"))
    widgetAudioRemoteControlObject.setOffAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "0", "11"))

    return widgetAudioRemoteControlObject
}

def createHeosWidgetObjectFromDto(VirtualObjectDto virtualObjectDto) {
    WidgetAudioRemoteControlObject widgetAudioRemoteControlObject = new WidgetAudioRemoteControlObject()

    widgetAudioRemoteControlObject.setArtistName(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "7"))
    widgetAudioRemoteControlObject.setTrackTitle(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "8"))

    widgetAudioRemoteControlObject.setPlayAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "0"))
    widgetAudioRemoteControlObject.setPauseAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "1"))
    widgetAudioRemoteControlObject.setNextAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "3"))
    widgetAudioRemoteControlObject.setPreviousAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "4"))
    widgetAudioRemoteControlObject.setVolumeUpAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "5", "5"))
    widgetAudioRemoteControlObject.setVolumeDownAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "5", "6"))
    widgetAudioRemoteControlObject.setMuteAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "7"))
    widgetAudioRemoteControlObject.setInitAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "8"))

    return widgetAudioRemoteControlObject
}

def createDenonMaranzWidgetObjectFromDto(VirtualObjectDto virtualObjectDto) {
    WidgetAudioRemoteControlObject widgetAudioRemoteControlObject = new WidgetAudioRemoteControlObject()


    widgetAudioRemoteControlObject.setOnAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "1", "3"))
    widgetAudioRemoteControlObject.setOffAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "0", "3"))
    widgetAudioRemoteControlObject.setVolumeUpAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "5", "0"))
    widgetAudioRemoteControlObject.setVolumeDownAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "5", "1"))
    widgetAudioRemoteControlObject.setMuteAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "2"))


    return widgetAudioRemoteControlObject
}