package mygrenton.templates

import com.grenton.om.mobile.entity.component.ComponentCameraStream
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetCamera
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetCamera emptyWidget = createWidget()

def getWidgetType() {
    return "CAMERA"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 12
}

WidgetCamera createWidget(){
    WidgetCamera widget = new WidgetCamera();
    widget.setType("CAMERA")
    widget.setCameraStream(createComponentCameraStream())
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.getCameraStream().setLabel(textResources.getString("camera"))
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetCamera widget = createWidget()
    widget.getCameraStream().setLabel(projectElementDto.getLabel())
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    return false
}

private ComponentCameraStream createComponentCameraStream(){
    ComponentCameraStream cameraStream = new ComponentCameraStream()
    cameraStream.setType("CAMERA_STREAM")
    cameraStream.setRowId(0)
    cameraStream.setImage("camera")
    cameraStream.setUrl("")
    return cameraStream;
}



