package mygrenton.templates

import com.grenton.om.mobile.dto.DeviceObjectDto
import com.grenton.om.mobile.dto.VirtualObjectDto
import com.grenton.om.mobile.entity.utils.GroovyIconDescriptor
import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetContactSensor
import com.grenton.om.mobile.entity.widget.objects.WidgetContactSensorObject
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetContactSensor emptyWidget = createWidget()

def getWidgetType() {
    return "CONTACT_SENSOR"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 19
}

WidgetContactSensor createWidget(){
    WidgetContactSensor widget = new WidgetContactSensor();
    widget.setType("CONTACT_SENSOR")
    widget.setIcon("lock")
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setOnIndication(textResources.getString("on_indication"))
    emptyWidget.setOffIndication(textResources.getString("off_indication"))
    emptyWidget.setLabel(textResources.getString("contact_sensor"))
    emptyWidget.setObject(createEmptyWidgetContactSensorObject())
    emptyWidget.setReverseState(false)
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetContactSensor widget = createWidget()
    widget.setLabel(projectElementDto.getLabel())
    widget.setOnIndication(textResources.getString("on_indication"))
    widget.setOffIndication(textResources.getString("off_indication"))
    widget.setReverseState(false)
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if (deviceObjectDto.getObjectTypeId() == 3
                || deviceObjectDto.getObjectTypeId() == 53
                || deviceObjectDto.getObjectTypeId() == 25
                || deviceObjectDto.getObjectTypeId() == 56) {
            widget.setObject(createObjectForDin(deviceObjectDto))
        }
        widget.setIcon(GroovyIconDescriptor.getIconNameBasedOnSourceReceiverType("lock", projectElementDto.getSourceReceiverType()))
    } else if (projectElementDto instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if (virtualObjectDto.getObjectTypeId() == 153 || virtualObjectDto.getObjectTypeId() == 101 && virtualObjectDto.getTypeVersion() == 1) {
            widget.setObject(createObjectForVO(virtualObjectDto))
        }
    }
    return widget;
}

def isSupported(ProjectElementDto projectElementDto) {
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if (deviceObjectDto.getObjectTypeId() == 3
                || deviceObjectDto.getObjectTypeId() == 53
                || deviceObjectDto.getObjectTypeId() == 25
                || deviceObjectDto.getObjectTypeId() == 56) {
            return true
        }
    } else if (projectElementDto instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if (virtualObjectDto.getObjectTypeId() == 101 && virtualObjectDto.getTypeVersion() == 1) {
           return true
        } else if (virtualObjectDto.getObjectTypeId() == 153) {
            return true
        }
    }
    return false
}

WidgetContactSensorObject createEmptyWidgetContactSensorObject(){
    WidgetContactSensorObject contactSensorObject = new WidgetContactSensorObject()
    contactSensorObject.setValue(GroovyUtils.createEmptyStateEntity())
    contactSensorObject.setClickAction(GroovyUtils.createEmptyAbstractAction())
    return contactSensorObject;
}

WidgetContactSensorObject createObjectForDin(DeviceObjectDto deviceObjectDto){
    WidgetContactSensorObject contactSensorObject = new WidgetContactSensorObject()
    contactSensorObject.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
    contactSensorObject.setClickAction(GroovyUtils.createEmptyAbstractAction())
    return contactSensorObject;
}

WidgetContactSensorObject createObjectForVO(VirtualObjectDto virtualObjectDto){
    WidgetContactSensorObject contactSensorObject = new WidgetContactSensorObject()
    contactSensorObject.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "0"))
    contactSensorObject.setClickAction(GroovyUtils.createEmptyAbstractAction())
    return contactSensorObject
}


