package mygrenton.templates

import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetContactSensorDouble
import com.grenton.om.mobile.entity.widget.objects.WidgetComponentContactSensor
import com.grenton.om.mobile.entity.widget.objects.WidgetContactSensorObject
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetContactSensorDouble emptyWidget = createWidget()

def getWidgetType() {
    return "CONTACT_SENSOR_DOUBLE"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 20
}

WidgetContactSensorDouble createWidget(){
    WidgetContactSensorDouble widget = new WidgetContactSensorDouble();
    widget.setType("CONTACT_SENSOR_DOUBLE")
    widget.setComponentLeft(createWidgetContactSensorComponent())
    widget.setComponentRight(createWidgetContactSensorComponent())
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.getComponentLeft().setOnIndication(textResources.getString("on_indication"))
    emptyWidget.getComponentLeft().setOffIndication(textResources.getString("off_indication"))
    emptyWidget.getComponentRight().setOnIndication(textResources.getString("on_indication"))
    emptyWidget.getComponentRight().setOffIndication(textResources.getString("off_indication"))
    emptyWidget.getComponentLeft().setLabel(textResources.getString("contact_sensor"))
    emptyWidget.getComponentRight().setLabel(textResources.getString("contact_sensor"))
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetContactSensorDouble widget = createWidget()
    return widget
}

def isSupported(ProjectElementDto projectObject) {
    return false
}

WidgetComponentContactSensor createWidgetContactSensorComponent(){
    WidgetComponentContactSensor component = new WidgetComponentContactSensor();
    component.setIcon("lock")
    component.setObject(createEmptyWidgetContactSensorObject())
    component.setReverseState(false)
    return component;
}

WidgetContactSensorObject createEmptyWidgetContactSensorObject(){
    WidgetContactSensorObject contactSensorObject = new WidgetContactSensorObject()
    contactSensorObject.setValue(GroovyUtils.createEmptyStateEntity())
    contactSensorObject.setClickAction(GroovyUtils.createEmptyAbstractAction())
    return contactSensorObject;
}



