package mygrenton.templates

import com.grenton.om.mobile.dto.VirtualObjectDto
import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetCoolMaster
import com.grenton.om.mobile.entity.widget.objects.WidgetCoolMasterObject
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetCoolMaster emptyWidget = createWidget()

def getWidgetType() {
    return "COOL_MASTER"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 22
}

WidgetCoolMaster createWidget(){
    WidgetCoolMaster widget = new WidgetCoolMaster();
    widget.setType("COOL_MASTER")
    widget.setIcon("ac")
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setLabel(textResources.getString("cool_master"))
    emptyWidget.setObject(createEmptyWidgetSliderObject())
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetCoolMaster widget = createWidget()
    widget.setLabel(projectElementDto.getLabel())
    if(projectElementDto instanceof VirtualObjectDto){
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if(virtualObjectDto.getObjectTypeId() == 252 && virtualObjectDto.getTypeVersion() == 1){
            widget.setObject(createWidgetSliderObjectFromDto(virtualObjectDto))
        }
    }
    return widget;
}

def isSupported(ProjectElementDto projectElementDto) {
    if (projectElementDto instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if(virtualObjectDto.getObjectTypeId() == 252 && virtualObjectDto.getTypeVersion() == 1){
            return true
        }
    }
    return false
}

WidgetCoolMasterObject createEmptyWidgetSliderObject(){
    WidgetCoolMasterObject widgetCoolMasterObject = new WidgetCoolMasterObject()
    widgetCoolMasterObject.setCoolMasterID(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setUids(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setSupportedModes(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setSupportedFanSpeeds(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setSupportedLouverPositions(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setStatus(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setState(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setMode(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setTargetTemp(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setFanSpeed(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setLouverPosition(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setAmbientTemp(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setFailureCode(GroovyUtils.createEmptyStateEntity())
    widgetCoolMasterObject.setSetSupportedModes(GroovyUtils.createEmptyAbstractAction())
    widgetCoolMasterObject.setSetSupportedFanSpeeds(GroovyUtils.createEmptyAbstractAction())
    widgetCoolMasterObject.setSetSupportedLouverPositions(GroovyUtils.createEmptyAbstractAction())
    widgetCoolMasterObject.setSetStateAction(GroovyUtils.createEmptyAbstractAction())
    widgetCoolMasterObject.setSetModeAction(GroovyUtils.createEmptyAbstractAction())
    widgetCoolMasterObject.setSetTargetTempAction(GroovyUtils.createEmptyAbstractAction())
    widgetCoolMasterObject.setSetFanSpeedAction(GroovyUtils.createEmptyAbstractAction())
    widgetCoolMasterObject.setSetLouverPosition(GroovyUtils.createEmptyAbstractAction())
    widgetCoolMasterObject.setTurnOnAction(GroovyUtils.createEmptyAbstractAction())
    widgetCoolMasterObject.setTurnOffAction(GroovyUtils.createEmptyAbstractAction())
    widgetCoolMasterObject.setSwitchModeAction(GroovyUtils.createEmptyAbstractAction())
    return widgetCoolMasterObject;
}

def createWidgetSliderObjectFromDto(VirtualObjectDto virtualObjectDto){
    WidgetCoolMasterObject widgetCoolMasterObject = new WidgetCoolMasterObject()
    widgetCoolMasterObject.setCoolMasterID(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "0"))
    widgetCoolMasterObject.setUids(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "1"))
    widgetCoolMasterObject.setSupportedModes(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "2"))
    widgetCoolMasterObject.setSupportedFanSpeeds(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "3"))
    widgetCoolMasterObject.setSupportedLouverPositions(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "4"))
    widgetCoolMasterObject.setStatus(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "5"))
    widgetCoolMasterObject.setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "6"))
    widgetCoolMasterObject.setMode(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "7"))
    widgetCoolMasterObject.setTargetTemp(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "8"))
    widgetCoolMasterObject.setFanSpeed(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "9"))
    widgetCoolMasterObject.setLouverPosition(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "10"))
    widgetCoolMasterObject.setAmbientTemp(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "11"))
    widgetCoolMasterObject.setFailureCode(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "12"))
    widgetCoolMasterObject.setSetSupportedModes(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "2"))
    widgetCoolMasterObject.setSetSupportedFanSpeeds(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "3"))
    widgetCoolMasterObject.setSetSupportedLouverPositions(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "4"))
    widgetCoolMasterObject.setSetStateAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "6"))
    widgetCoolMasterObject.setSetModeAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "7"))
    widgetCoolMasterObject.setSetTargetTempAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "8"))
    widgetCoolMasterObject.setSetFanSpeedAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "9"))
    widgetCoolMasterObject.setSetLouverPosition(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "10"))
    widgetCoolMasterObject.setTurnOnAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "0"))
    widgetCoolMasterObject.setTurnOffAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "1"))
    widgetCoolMasterObject.setSwitchModeAction(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "2"))
    return widgetCoolMasterObject;
}


