package mygrenton.templates

import com.grenton.om.mobile.dto.DeviceObjectDto
import com.grenton.om.mobile.entity.action.AbstractAction
import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetDimmerV2
import com.grenton.om.mobile.entity.widget.objects.WidgetDimmerV2Object
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetDimmerV2 emptyWidget = createWidget()


/** * Supported object types:
 * 5 - DIMMER
 * 9 - LED
 * 35 - DALI_GEAR_DT8
 * 49 - LED_CHANNEL
 * 60 - SHUTTER
 * 70 - ZWAVE_LEDRGB
 * 71 - ZWAVE_LED
 */
static List<Long> getSupported() {
    return [5L, 9L, 35L, 49L, 60L, 70L, 71L]
}

static def getWidgetType() {
    return "DIMMER_V2"
}

static def getOrderIndex(ProjectElementDto projectElementDto) {
    if (projectElementDto instanceof DeviceObjectDto) {
        def id = projectElementDto.getObjectTypeId()
        if ([5, 60].contains(id)) {
            return 0
        } else if ([9, 35, 49, 70].contains(id)) {
            return 1
        }
    }

    return 7
}

static WidgetDimmerV2 createWidget(){
    WidgetDimmerV2 widget = new WidgetDimmerV2();
    widget.setType("DIMMER_V2")
    widget.setIcon("dimmer")
    widget.setMin(0.0)
    widget.setMax(1.0)
    widget.setPrecision(2)
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setLabel(textResources.getString("dimmer"))
    emptyWidget.setObject(createEmptyWidgetSliderObject())
    return emptyWidget;
}

static AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetDimmerV2 widget = createWidget()
    widget.setLabel(projectElementDto.getLabel())
    if(projectElementDto instanceof DeviceObjectDto){
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto

        def id = projectElementDto.getObjectTypeId().intValue()

        if(id == 5){
            widget.setObject(createObjectForDimmerTemplate(deviceObjectDto))
        } else if([70, 9].contains(id)){
            widget.setObject(createObjectForLedTemplate(deviceObjectDto))
        } else if(id == 60){
            widget.setObject(createObjectForDimmerTemplate(deviceObjectDto))
        } else if(id == 35){
            // DALI_GEAR_DT8
            widget.setObject(createObjectForGrentonDaliGearDt8(deviceObjectDto))
            widget.setMax(255)
            widget.setPrecision(0)
        } else if(id == 49){
            // LED_CHANNEL
            widget.setObject(createObjectForGrentonLedChannel(deviceObjectDto))
            widget.setMax(255)
            widget.setPrecision(0)
        }else if(id == 71) {
            widget.setObject(createObjectForGrentonV2LedTemplate(deviceObjectDto))
            widget.setMax(255.0)
            widget.setPrecision(0)
        }
    }
    return widget;
}

static def isSupported(ProjectElementDto projectElementDto) {
    if(projectElementDto instanceof DeviceObjectDto){
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        return getSupported().contains(deviceObjectDto.getObjectTypeId());
    }

    return false
}

static WidgetDimmerV2Object createEmptyWidgetSliderObject(){
    WidgetDimmerV2Object widgetDimmerV2Object = new WidgetDimmerV2Object()
    widgetDimmerV2Object.setValue(GroovyUtils.createEmptyStateEntity())
    widgetDimmerV2Object.setSetValueAction(GroovyUtils.createEmptyAbstractAction())
    widgetDimmerV2Object.setOnAction(GroovyUtils.createEmptyAbstractAction())
    widgetDimmerV2Object.setOffAction(GroovyUtils.createEmptyAbstractAction())
    return widgetDimmerV2Object;
}

static def createObjectForDimmerTemplate(DeviceObjectDto deviceObjectDto){
    WidgetDimmerV2Object widgetDimmerV2Object = new WidgetDimmerV2Object()
    widgetDimmerV2Object.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
    widgetDimmerV2Object.setSetValueAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "0"))
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("PSEUDO_METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "1")
    actionOn.setIndex("0")
    widgetDimmerV2Object.setOnAction(actionOn)
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("PSEUDO_METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0")
    actionOff.setIndex("0")
    widgetDimmerV2Object.setOffAction(actionOff)
    return widgetDimmerV2Object;
}

static def createObjectForLedTemplate(DeviceObjectDto deviceObjectDto){
    WidgetDimmerV2Object widgetDimmerV2Object = new WidgetDimmerV2Object()
    widgetDimmerV2Object.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
    widgetDimmerV2Object.setSetValueAction(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "0"))
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "1")
    actionOn.setIndex("0")
    widgetDimmerV2Object.setOnAction(actionOn)
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0")
    actionOff.setIndex("0")
    widgetDimmerV2Object.setOffAction(actionOff)
    return widgetDimmerV2Object;
}

static def createObjectForGrentonLedChannel(DeviceObjectDto deviceObjectDto){

    WidgetDimmerV2Object widgetDimmerV2Object = new WidgetDimmerV2Object()

    widgetDimmerV2Object.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))

    // SetValue
    widgetDimmerV2Object.setSetValueAction(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "0"))

    // SwitchOn
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0")
    actionOn.setIndex("1")
    widgetDimmerV2Object.setOnAction(actionOn)

    // SwitchOff
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0")
    actionOff.setIndex("2")
    widgetDimmerV2Object.setOffAction(actionOff)

    return widgetDimmerV2Object;
}

static def createObjectForGrentonDaliGearDt8(DeviceObjectDto deviceObjectDto){
    WidgetDimmerV2Object widgetDimmerV2Object = new WidgetDimmerV2Object()

    widgetDimmerV2Object.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "2"))

    // SetDAPCValue
    widgetDimmerV2Object.setSetValueAction(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$, 0", "1"))

    // SwitchOn
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0")
    actionOn.setIndex("3")
    widgetDimmerV2Object.setOnAction(actionOn)

    // SwitchOff
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0")
    actionOff.setIndex("4")
    widgetDimmerV2Object.setOffAction(actionOff)

    return widgetDimmerV2Object;
}

static def createObjectForGrentonV2LedTemplate(DeviceObjectDto deviceObjectDto){
    WidgetDimmerV2Object widgetDimmerV2Object = new WidgetDimmerV2Object()
    widgetDimmerV2Object.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
    widgetDimmerV2Object.setSetValueAction(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "0"))
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "255")
    actionOn.setIndex("0")
    widgetDimmerV2Object.setOnAction(actionOn)
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0")
    actionOff.setIndex("0")
    widgetDimmerV2Object.setOffAction(actionOff)
    println "objects" + widgetDimmerV2Object;
    return widgetDimmerV2Object;
}