package mygrenton.templates

import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.dto.VirtualObjectDto
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetEventScheduler
import com.grenton.om.mobile.entity.widget.objects.WidgetEventSchedulerObject
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetEventScheduler emptyWidget = createWidget()

def getWidgetType() {
    return "EVENT_SCHEDULER"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    if (projectElementDto instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if (virtualObjectDto.getObjectTypeId() == 43 && virtualObjectDto.getTypeVersion() == 1) {
            return 0
        }
    }
    return 15
}

WidgetEventScheduler createWidget(){
    WidgetEventScheduler widget = new WidgetEventScheduler();
    widget.setType("EVENT_SCHEDULER")
    widget.setId(0)
    widget.setIcon("scheduler")
    WidgetEventSchedulerObject object = new WidgetEventSchedulerObject()
    widget.setObject(object)
    return widget;
}

def setObjectValuesForEmptyWidget(WidgetEventSchedulerObject object){
    object.setRuleList(GroovyUtils.createEmptyStateEntity())
    object.setCurrentRule(GroovyUtils.createEmptyStateEntity())
    object.setNextRule(GroovyUtils.createEmptyStateEntity())
    object.setRuleCount(GroovyUtils.createEmptyStateEntity())
    object.setRuleSpace(GroovyUtils.createEmptyStateEntity())
    object.setState(GroovyUtils.createEmptyStateEntity())
    object.setStart(GroovyUtils.createEmptyAbstractAction())
    object.setStop(GroovyUtils.createEmptyAbstractAction())
    object.setAddRule(GroovyUtils.createEmptyAbstractAction())
    object.setDeleteRule(GroovyUtils.createEmptyAbstractAction())
    object.setGetRule(GroovyUtils.createEmptyAbstractAction())
    object.setEnableRule(GroovyUtils.createEmptyAbstractAction())
    object.setDisableRule(GroovyUtils.createEmptyAbstractAction())
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    setObjectValuesForEmptyWidget(emptyWidget.getObject())
    emptyWidget.setLabel(textResources.getString("eventScheduler"))
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetEventScheduler templateWidget = createWidget()
    if (projectElementDto instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if (virtualObjectDto.getObjectTypeId() == 43 && virtualObjectDto.getTypeVersion() == 1) {
            setValuesForEventScheduler(virtualObjectDto, templateWidget)
        }
    }
    return templateWidget;
}

def isSupported(ProjectElementDto projectObject) {
    if (projectObject instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectObject
        if (virtualObjectDto.getObjectTypeId() == 43 && virtualObjectDto.getTypeVersion() == 1) {
            return true
        }
    }
    return false
}

def setValuesForEventScheduler(VirtualObjectDto virtualObjectDto, WidgetEventScheduler templateWidget){
    templateWidget.setLabel(virtualObjectDto.getLabel())
    templateWidget.setIcon("scheduler")
    templateWidget.getObject().setRuleList(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "0"))
    templateWidget.getObject().setCurrentRule(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "1"))
    templateWidget.getObject().setNextRule(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "2"))
    templateWidget.getObject().setRuleCount(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "3"))
    templateWidget.getObject().setRuleSpace(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "4"))
    templateWidget.getObject().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "5"))
    templateWidget.getObject().setStart(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "0"))
    templateWidget.getObject().setStop(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "1"))
    templateWidget.getObject().setAddRule(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "2"))
    templateWidget.getObject().setDeleteRule(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "3"))
    templateWidget.getObject().setGetRule(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "4"))
    templateWidget.getObject().setEnableRule(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "5"))
    templateWidget.getObject().setDisableRule(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "6"))
}



