package mygrenton.templates

import com.grenton.om.mobile.entity.component.ComponentHeader
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetHeader
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetHeader emptyWidget = createWidget()

def getWidgetType() {
    return "HEADER"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 0
}

WidgetHeader createWidget(){
    WidgetHeader widget = new WidgetHeader();
    widget.setType("HEADER")
    widget.setText(createComponentHeader())
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.getText().setLabel(textResources.getString("header"))
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetHeader widget = createWidget()
    widget.getText().setLabel(projectElementDto.getLabel())
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    return false
}

ComponentHeader createComponentHeader(){
    ComponentHeader componentHeader = new ComponentHeader();
    componentHeader.setType("HEADER")
    componentHeader.setRowId(0)
    return componentHeader
}