package mygrenton.templates

import com.grenton.om.mobile.entity.component.ComponentIntercomButton1
import com.grenton.om.mobile.entity.component.ComponentIntercomButton2
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetIntercom
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetIntercom emptyWidget = createWidget()

def getWidgetType() {
    return "INTERCOM"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 23
}

WidgetIntercom createWidget(){
    WidgetIntercom widget = new WidgetIntercom();
    widget.setType("INTERCOM")
    widget.setIcon("intercom")
    widget.setIntercomSipNumber("0000")
    widget.setComponentIntercomButton1(createComponentButtonIntercom1())
    widget.setComponentIntercomButton2(createComponentButtonIntercom2())
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setLabel(textResources.getString("intercom"))
    emptyWidget.getComponentIntercomButton1().setLabel(textResources.getString("component_intercom_open_gate"))
    emptyWidget.getComponentIntercomButton2().setLabel(textResources.getString("component_intercom_open_drive"))
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetIntercom widget = createWidget()

    widget.setLabel(projectElementDto.getLabel())

    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    return false
}

static ComponentIntercomButton1 createComponentButtonIntercom1() {
    ComponentIntercomButton1 buttonIntercom = new ComponentIntercomButton1()
    buttonIntercom.setType("INTERCOM_BUTTON_1");
    return buttonIntercom;
}

static ComponentIntercomButton2 createComponentButtonIntercom2() {
    ComponentIntercomButton2 buttonIntercom = new ComponentIntercomButton2()
    buttonIntercom.setType("INTERCOM_BUTTON_2");
    buttonIntercom.setEnabled(true)
    return buttonIntercom;
}