package mygrenton.templates

import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.dto.DeviceObjectDto
import com.grenton.om.mobile.entity.action.AbstractAction
import com.grenton.om.mobile.entity.component.ComponentButtonBistable
import com.grenton.om.mobile.entity.component.ComponentSliderBrightness
import com.grenton.om.mobile.entity.component.ComponentSliderHue
import com.grenton.om.mobile.entity.component.ComponentSliderSaturation
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetLed
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetLed emptyWidget = createWidget()

/*** Supported object types:
 * 9 - LED
 * 35 - DALI_GEAR_DT8
 * 70 - ZWAVE_LEDRGB
 */
static def getSupported() {
    return [9L , 70L , 35L]
}

static def getWidgetType() {
    return "LED"
}

static def getOrderIndex(ProjectElementDto projectElementDto) {
    if(projectElementDto instanceof DeviceObjectDto){
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if(getSupported().contains(deviceObjectDto.getObjectTypeId())){
            return 0;
        }
    }
    return 8
}

static WidgetLed createWidget(){
    WidgetLed widget = new WidgetLed()
    widget.setType("LED")
    ComponentButtonBistable buttonBistable = GroovyUtils.createComponentButtonBistable("rgb", "METHOD")
    widget.setButtonBistable(buttonBistable)
    ComponentSliderHue hue = new ComponentSliderHue()
    GroovyUtils.setEmptyValuesForComponentSlider(hue, "SLIDER_HUE", 1, "DEGREE", 0.0, 360.0, "METHOD", "1")
    widget.setSliderHue(hue)
    ComponentSliderSaturation saturation = new ComponentSliderSaturation()
    GroovyUtils.setEmptyValuesForComponentSlider(saturation, "SLIDER_SATURATION", 2, "PERCENT", 0.0, 1.0, "METHOD", "\$value\$")
    widget.setSliderSaturation(saturation)
    ComponentSliderBrightness brightness = new ComponentSliderBrightness()
    GroovyUtils.setEmptyValuesForComponentSlider(brightness, "SLIDER_BRIGHTNESS", 3, "PERCENT", 0.0, 1.0, "METHOD", "\$value\$")
    widget.setSliderBrightness(brightness)
    return widget
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.getButtonBistable().setLabel(textResources.getString("led"))
    emptyWidget.getSliderHue().setLabel(textResources.getString("hue"))
    emptyWidget.getSliderBrightness().setLabel(textResources.getString("brightness"))
    emptyWidget.getSliderSaturation().setLabel(textResources.getString("saturation"))
    emptyWidget.getButtonBistable().setOnIndication(textResources.getString("on_indication"))
    emptyWidget.getButtonBistable().setOffIndication(textResources.getString("off_indication"))
    return emptyWidget
}

static AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetLed widget = createWidget()
    widget.getButtonBistable().setLabel(projectElementDto.getLabel())
    widget.getButtonBistable().setOnIndication(textResources.getString("on_indication"))
    widget.getButtonBistable().setOffIndication(textResources.getString("off_indication"))
    if(projectElementDto instanceof DeviceObjectDto){
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto

        def id = projectElementDto.getObjectTypeId().intValue()

        if([9, 70].contains(id)){
            setValuesForLed(deviceObjectDto, widget, textResources)
        } else if(id == 35){
            setValuesForDaliGearDt8(deviceObjectDto, widget, textResources)
        }
    }
    return widget
}

def isSupported(ProjectElementDto projectElementDto) {
    if(projectElementDto instanceof DeviceObjectDto){
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        return getSupported().contains(deviceObjectDto.getObjectTypeId());
    }

    return false
}

static def setValuesForDaliGearDt8(DeviceObjectDto deviceObjectDto, WidgetLed widget, TextResources textResources){
    widget.getButtonBistable().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "6"))

    AbstractAction actionOn = GroovyUtils.createActionOnEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "1,0")
    actionOn.setIndex("17")
    widget.getButtonBistable().setActionOn(actionOn)

    AbstractAction actionOff = GroovyUtils.createActionOffEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0,0")
    actionOff.setIndex("17")
    widget.getButtonBistable().setActionOff(actionOff)

    widget.getSliderHue().setLabel(textResources.getString("hue"))
    widget.getSliderHue().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "4"))
    widget.getSliderHue().setActionClick(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$, 0", "15"))
    widget.getSliderHue().setMin(0.0)
    widget.getSliderHue().setMax(360.0)

    widget.getSliderSaturation().setLabel(textResources.getString("saturation"))
    widget.getSliderSaturation().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "5"))
    widget.getSliderSaturation().setActionClick(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$, 0", "16"))
    widget.getSliderSaturation().setMin(0.0)
    widget.getSliderSaturation().setMax(1.0)

    widget.getSliderBrightness().setLabel(textResources.getString("brightness"))
    widget.getSliderBrightness().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "6"))
    widget.getSliderBrightness().setActionClick(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$, 0", "17"))
    widget.getSliderBrightness().setMin(0.0)
    widget.getSliderBrightness().setMax(1.0)
}

static def setValuesForLed(DeviceObjectDto deviceObjectDto, WidgetLed widget, TextResources textResources){
    widget.getButtonBistable().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "1")
    actionOn.setIndex("0")
    widget.getButtonBistable().setActionOn(actionOn)
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0")
    actionOff.setIndex("0")
    widget.getButtonBistable().setActionOff(actionOff)
    widget.getSliderHue().setLabel(textResources.getString("hue"))
    widget.getSliderHue().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "1"))
    widget.getSliderHue().setActionClick(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "1"))
    widget.getSliderHue().setMin(0.0)
    widget.getSliderHue().setMax(360.0)
    widget.getSliderSaturation().setLabel(textResources.getString("saturation"))
    widget.getSliderSaturation().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "2"))
    widget.getSliderSaturation().setActionClick(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "2"))
    widget.getSliderSaturation().setMin(0.0)
    widget.getSliderSaturation().setMax(1.0)
    widget.getSliderBrightness().setLabel(textResources.getString("brightness"))
    widget.getSliderBrightness().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
    widget.getSliderBrightness().setActionClick(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "0"))
    widget.getSliderBrightness().setMin(0.0)
    widget.getSliderBrightness().setMax(1.0)
}