package mygrenton.templates

import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.dto.DeviceObjectDto
import com.grenton.om.mobile.dto.ModuleDto
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetMultisensor
import com.grenton.om.mobile.entity.widget.objects.WidgetMultisensorObject
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetMultisensor emptyWidget = createWidget()

def getWidgetType() {
    return "MULTISENSOR"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 16
}

WidgetMultisensor createWidget(){
    WidgetMultisensor widget = new WidgetMultisensor();
    widget.setType("MULTISENSOR")
    widget.setId(0)
    widget.setIcon("multisensor")
    widget.setLabelVisible(true)
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setLabel(textResources.getString("multisensor"))
    setWidgetEmptyValues(emptyWidget)
    return emptyWidget;
}


AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetMultisensor widget = createWidget()
    widget.setLabel(projectElementDto.getLabel())
    if(projectElementDto instanceof ModuleDto){
        ModuleDto moduleDto = (ModuleDto) projectElementDto
        if(moduleDto.getModuleInfoDto().getHardwareType() == 45){
            setValuesForMultisensor(moduleDto, widget)
        }
    }
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    if(projectObject instanceof ModuleDto){
        ModuleDto moduleDto = (ModuleDto) projectObject
        if(moduleDto.getModuleInfoDto().getHardwareType() == 45){
            return true
        }
    }
    return false
}

def setWidgetEmptyValues(WidgetMultisensor widget){
    widget.setObjectTemperature(createWidgetMultisensorEmptyObject())
    widget.setObjectLight(createWidgetMultisensorEmptyObject())
    widget.setObjectHumidity(createWidgetMultisensorEmptyObject())
    widget.setObjectPressure(createWidgetMultisensorEmptyObject())
    widget.setObjectAirCo2(createWidgetMultisensorEmptyObject())
    widget.setObjectAirVco(createWidgetMultisensorEmptyObject())
    widget.setObjectSound(createWidgetMultisensorEmptyObject())
}

WidgetMultisensorObject createWidgetMultisensorEmptyObject(){
    WidgetMultisensorObject widgetMultisensorObject = new WidgetMultisensorObject()
    widgetMultisensorObject.setThreshold(GroovyUtils.createEmptyStateEntity())
    widgetMultisensorObject.setSensitivity(GroovyUtils.createEmptyStateEntity())
    widgetMultisensorObject.setMinValue(GroovyUtils.createEmptyStateEntity())
    widgetMultisensorObject.setMaxValue(GroovyUtils.createEmptyStateEntity())
    widgetMultisensorObject.setValue(GroovyUtils.createEmptyStateEntity())
    return widgetMultisensorObject
}

def setValuesForMultisensor(ModuleDto moduleDto, WidgetMultisensor widget){
    for(DeviceObjectDto deviceObjectDto : moduleDto.getDeviceObjects()){
        if(deviceObjectDto.getObjectTypeId() == 20){
            widget.setObjectTemperature(createWidgetMultisensorObject(deviceObjectDto))
        } else if(deviceObjectDto.getObjectTypeId() == 42){
            widget.setObjectLight(createWidgetMultisensorObject(deviceObjectDto))
        } else if(deviceObjectDto.getObjectTypeId() == 22){
            widget.setObjectHumidity(createWidgetMultisensorObject(deviceObjectDto))
        } else if(deviceObjectDto.getObjectTypeId() == 34){
            widget.setObjectPressure(createWidgetMultisensorObject(deviceObjectDto))
        } else if(deviceObjectDto.getObjectTypeId() == 41){
            widget.setObjectAirCo2(createWidgetMultisensorObject(deviceObjectDto))
        } else if(deviceObjectDto.getObjectTypeId() == 36){
            widget.setObjectAirVco(createWidgetMultisensorObject(deviceObjectDto))
        } else if(deviceObjectDto.getObjectTypeId() == 37){
            widget.setObjectSound(createWidgetMultisensorObject(deviceObjectDto))
        }
    }
}

WidgetMultisensorObject createWidgetMultisensorObject(DeviceObjectDto deviceObjectDto){
    WidgetMultisensorObject widgetMultisensorObject = new WidgetMultisensorObject()
    widgetMultisensorObject.setThreshold(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "1"))
    widgetMultisensorObject.setSensitivity(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "2"))
    widgetMultisensorObject.setMinValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "3"))
    widgetMultisensorObject.setMaxValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "4"))
    widgetMultisensorObject.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
    return widgetMultisensorObject
}



