package mygrenton.templates

import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.dto.DeviceObjectDto
import com.grenton.om.mobile.dto.VirtualObjectDto
import com.grenton.om.mobile.entity.action.AbstractAction
import com.grenton.om.mobile.entity.component.ComponentButtonBistable
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetOnOff
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetOnOff emptyWidget = createWidget()

def getWidgetType() {
    return "ON_OFF"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if (deviceObjectDto.getObjectTypeId() == 4) {
            return 0
        } else if(deviceObjectDto.getObjectTypeId() == 52){
            return 0
        }  else if(deviceObjectDto.getObjectTypeId() == 152) {
            return 0
        } else if(deviceObjectDto.getObjectTypeId() == 13 || deviceObjectDto.getObjectTypeId() == 32) {
            return 0
        }
    } else if(projectElementDto instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if (virtualObjectDto.getObjectTypeId() == 102 && virtualObjectDto.getTypeVersion() == 1) {
            return 0
        } else if (virtualObjectDto.getObjectTypeId() == 100 && virtualObjectDto.getTypeVersion() == 1) {
            return 0
        } else if(virtualObjectDto.getObjectTypeId() == 6 && virtualObjectDto.getTypeVersion() == 1){
            return 0
        }
    }
    return 3
}

WidgetOnOff createWidget(){
    WidgetOnOff widget = new WidgetOnOff();
    widget.setType("ON_OFF")
    ComponentButtonBistable buttonBistable = GroovyUtils.createComponentButtonBistable("bulb","METHOD")
    widget.setButtonBistable(buttonBistable)
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.getButtonBistable().setLabel(textResources.getString("on_off"))
    emptyWidget.getButtonBistable().setOnIndication(textResources.getString("on_indication"))
    emptyWidget.getButtonBistable().setOffIndication(textResources.getString("off_indication"))
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetOnOff widget = createWidget()
    widget.getButtonBistable().setLabel(projectElementDto.getLabel())
    widget.getButtonBistable().setOnIndication(textResources.getString("on_indication"))
    widget.getButtonBistable().setOffIndication(textResources.getString("off_indication"))
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if(deviceObjectDto.getObjectTypeId() == 4){
            setValuesForDout(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 52){
            setValuesForDout(deviceObjectDto, widget)
        } else if (deviceObjectDto.getObjectTypeId() == 32) {
            setValuesForDaliGear(deviceObjectDto, widget)
        } else if (deviceObjectDto.getObjectTypeId() == 13) {
            setValuesForAnalogOut(deviceObjectDto, widget)
        }
    } else if(projectElementDto instanceof VirtualObjectDto){
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if(virtualObjectDto.getObjectTypeId() == 6 && virtualObjectDto.getTypeVersion() == 1){
            setValuesForTimer(virtualObjectDto, widget)
        } else if(virtualObjectDto.getObjectTypeId() == 102 && virtualObjectDto.getTypeVersion() == 1){
            setValuesForSatelOutput(virtualObjectDto, widget)
        } else if(virtualObjectDto.getObjectTypeId() == 100 && virtualObjectDto.getTypeVersion() == 1){
            setValuesForSatelZone(virtualObjectDto, widget)
        } else if(virtualObjectDto.getObjectTypeId() == 152){
            setValuesForJablotronOutput(virtualObjectDto, widget)
        }
    }
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    if (projectObject instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectObject
        if(deviceObjectDto.getObjectTypeId() == 4){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 52){
            return true
        } else if (deviceObjectDto.getObjectTypeId() == 32) {
            return true;
        } else if (deviceObjectDto.getObjectTypeId() == 13) {
            return true;
        }
    } else if(projectObject instanceof VirtualObjectDto){
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectObject
        if(virtualObjectDto.getObjectTypeId() == 6 && virtualObjectDto.getTypeVersion() == 1){
            return true
        } else if(virtualObjectDto.getObjectTypeId() == 102 && virtualObjectDto.getTypeVersion() == 1){
            return true
        } else if(virtualObjectDto.getObjectTypeId() == 100 && virtualObjectDto.getTypeVersion() == 1){
            return true
        } else if(virtualObjectDto.getObjectTypeId() == 152){
            return true
        }
    }
    return false
}

def setValuesForDout(DeviceObjectDto deviceObjectDto, WidgetOnOff widget){
    widget.getButtonBistable().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("PSEUDO_METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "1")
    actionOn.setIndex("0")
    widget.getButtonBistable().setActionOn(actionOn)
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("PSEUDO_METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0")
    actionOff.setIndex("0")
    widget.getButtonBistable().setActionOff(actionOff)
}

def setValuesForSatelOutput(VirtualObjectDto virtualObjectDto, WidgetOnOff widget){
    widget.getButtonBistable().setImage("switch")
    widget.getButtonBistable().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "0"))
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "")
    actionOn.setIndex("0")
    widget.getButtonBistable().setActionOn(actionOn)
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "")
    actionOff.setIndex("1")
    widget.getButtonBistable().setActionOff(actionOff)
}

def setValuesForDaliGear(DeviceObjectDto deviceObjectDto, WidgetOnOff widget){
    widget.getButtonBistable().setImage("switch")
    widget.getButtonBistable().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "2"))
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "")
    actionOn.setIndex("1")
    actionOn.setValue("254,0")
    widget.getButtonBistable().setActionOn(actionOn)
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "")
    actionOff.setIndex("1")
    actionOff.setValue("0,0")
    widget.getButtonBistable().setActionOff(actionOff)
}


def setValuesForAnalogOut(DeviceObjectDto deviceObjectDto, WidgetOnOff widget){
    widget.getButtonBistable().setImage("switch")
    widget.getButtonBistable().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "")
    actionOn.setIndex("8")
    actionOn.setValue("0,0")
    widget.getButtonBistable().setActionOn(actionOn)
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "")
    actionOff.setIndex("9")
    actionOff.setValue("0,0")
    widget.getButtonBistable().setActionOff(actionOff)
}

def setValuesForTimer(VirtualObjectDto virtualObjectDto, WidgetOnOff widget){
    widget.getButtonBistable().setImage("switch")
    widget.getButtonBistable().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "2"))
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "")
    actionOn.setIndex("0")
    widget.getButtonBistable().setActionOn(actionOn)
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "")
    actionOff.setIndex("1")
    widget.getButtonBistable().setActionOff(actionOff)
}

def setValuesForSatelZone(VirtualObjectDto virtualObjectDto, WidgetOnOff widget){
    widget.getButtonBistable().setImage("lock")
    widget.getButtonBistable().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "0"))
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "")
    actionOn.setIndex("0")
    widget.getButtonBistable().setActionOn(actionOn)
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "")
    actionOff.setIndex("1")
    widget.getButtonBistable().setActionOff(actionOff)
}

def setValuesForJablotronOutput(VirtualObjectDto virtualObjectDto, WidgetOnOff widget){
    widget.getButtonBistable().setImage("switch")
    widget.getButtonBistable().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "0"))
    AbstractAction actionOn = GroovyUtils.createActionOnEntity("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "")
    actionOn.setIndex("0")
    widget.getButtonBistable().setActionOn(actionOn)
    AbstractAction actionOff = GroovyUtils.createActionOffEntity("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "")
    actionOff.setIndex("1")
    widget.getButtonBistable().setActionOff(actionOff)
}



