package mygrenton.templates

import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.component.ComponentButtonBistableV2
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetOnOffDouble
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetOnOffDouble emptyWidget = createWidget()

def getWidgetType() {
    return "ON_OFF_DOUBLE"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 3
}

WidgetOnOffDouble createWidget(){
    WidgetOnOffDouble widget = new WidgetOnOffDouble();
    widget.setType("ON_OFF_DOUBLE")
    widget.setButtonBistableFirst(createButtonBistable(0))
    widget.setButtonBistableSecond(createButtonBistable(1))
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.getButtonBistableFirst().setLabel(textResources.getString("on_off"))
    emptyWidget.getButtonBistableFirst().setOnIndication(textResources.getString("on_indication"))
    emptyWidget.getButtonBistableFirst().setOffIndication(textResources.getString("off_indication"))
    emptyWidget.getButtonBistableSecond().setLabel(textResources.getString("on_off"))
    emptyWidget.getButtonBistableSecond().setOnIndication(textResources.getString("on_indication"))
    emptyWidget.getButtonBistableSecond().setOffIndication(textResources.getString("off_indication"))
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetOnOffDouble widget = createWidget()
    widget.getButtonBistableFirst().setLabel(projectElementDto.getLabel())
    widget.getButtonBistableSecond().setLabel(projectElementDto.getLabel())
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    return false
}

private ComponentButtonBistableV2 createButtonBistable(int rowId){
    ComponentButtonBistableV2 button = new ComponentButtonBistableV2()
    button.setType("BUTTON_BISTABLE_V2")
    button.setRowId(rowId)
    button.setImage("bulb")
    button.setState(GroovyUtils.createEmptyStateEntity())
    button.setActionOn(GroovyUtils.createActionOnEntity("METHOD", null, null, "1"))
    button.setActionOff(GroovyUtils.createActionOffEntity("METHOD", null, null, "1"))
    return button
}





