package mygrenton.templates

import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.dto.DeviceObjectDto
import com.grenton.om.mobile.entity.component.ComponentButtonBistableClick
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetRollerShutter
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetRollerShutter emptyWidget = createWidget()

def getWidgetType() {
    return "ROLLER_SHUTTER"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if(deviceObjectDto.getObjectTypeId() == 11){
            return 0
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 23
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 1){
            return 1
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 32
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 1){
            return 1
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 36
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() == 1){
            return 0
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 41
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() == 1){
            return 0
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 42
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 1){
            return 1
        } else if(deviceObjectDto.getObjectTypeId() == 59){
            return 0
        }
    }
    return 10
}

WidgetRollerShutter createWidget(){
    WidgetRollerShutter widget = new WidgetRollerShutter();
    widget.setType("ROLLER_SHUTTER")
    widget.setButtonBistableClick(createButtonBistable())
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.getButtonBistableClick().setLabel(textResources.getString("roller_shutter"))
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetRollerShutter widget = createWidget()
    widget.getButtonBistableClick().setLabel(projectElementDto.getLabel())
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if(deviceObjectDto.getObjectTypeId() == 11){
            setValuesForRollerShutterVariantOne(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 23
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 1){
            setValuesForRollerShutterVariantTwo(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 32
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 1){
            setValuesForRollerShutterVariantTwo(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 36
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 1){
            setValuesForRollerShutterVariantTwo(deviceObjectDto, widget)
        }  else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 41
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 1){
            setValuesForRollerShutterVariantTwo(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 42
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 1){
            setValuesForRollerShutterVariantTwo(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 59){
            if(deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() == 0){
                setValuesForRollerShutterVariantTwo(deviceObjectDto, widget)
            } else {
                setValuesForRollerShutterVariantOne(deviceObjectDto, widget)
            }
        } else if (deviceObjectDto.getObjectTypeId() == 69) {
            setValuesForZWaveRollerShutter(deviceObjectDto, widget)
        }
    }
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    if (projectObject instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectObject
        if(deviceObjectDto.getObjectTypeId() == 11){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 23
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 1){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 32
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 1){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 36
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() == 1){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 41
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() == 1){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 42
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 1){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 59){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 69){
            return true
        }
    }
    return false
}

ComponentButtonBistableClick createButtonBistable(){
    ComponentButtonBistableClick component = new ComponentButtonBistableClick();
    component.setType("BUTTON_BISTABLE_CLICK")
    component.setRowId(0)
    component.setImage("blinds")
    component.setIndication("ON_OFF")
    component.setState(GroovyUtils.createEmptyStateEntity())
    component.setActionClick(GroovyUtils.createAbstractAction("METHOD", null, null, "\$value\$"))
    return component;
}

def setValuesForRollerShutterVariantOne(DeviceObjectDto deviceObjectDto, WidgetRollerShutter widget){
    widget.getButtonBistableClick().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "2"))
    widget.getButtonBistableClick().setActionClick(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0", "2"))
}

def setValuesForRollerShutterVariantTwo(DeviceObjectDto deviceObjectDto, WidgetRollerShutter widget){
    widget.getButtonBistableClick().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
    widget.getButtonBistableClick().setActionClick(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0", "2"))
}

def setValuesForZWaveRollerShutter(DeviceObjectDto deviceObjectDto, WidgetRollerShutter widget){
    widget.getButtonBistableClick().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "2"))
    widget.getButtonBistableClick().setActionClick(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "2"))
}



