package mygrenton.templates

import com.grenton.om.mobile.dto.DeviceObjectDto
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.entity.widget.WidgetRollerShutterV3
import com.grenton.om.mobile.entity.widget.objects.WidgetObjectRollerShutterV3
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetRollerShutterV3 emptyWidget = createWidget()

def getWidgetType() {
    return "ROLLER_SHUTTER_V3"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 23
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 2){
            return 0
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 32
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 2){
            return 0
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 42
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 2){
            return 0
        } else if (deviceObjectDto.getObjectTypeId() == 69) {
            return 0
        }
    }
    return 11
}

WidgetRollerShutterV3 createWidget(){
    WidgetRollerShutterV3 widget = new WidgetRollerShutterV3();
    widget.setType("ROLLER_SHUTTER_V3")
    widget.setId(0)
    widget.setIcon("blinds")
    WidgetObjectRollerShutterV3 object = new WidgetObjectRollerShutterV3()
    widget.setObject(object)
    return widget;
}

def setObjectValuesForEmptyWidget(WidgetObjectRollerShutterV3 object){
    object.setState(GroovyUtils.createEmptyStateEntity())
    object.setUp(GroovyUtils.createEmptyStateEntity())
    object.setDown(GroovyUtils.createEmptyStateEntity())
    object.setLoadCurrent(GroovyUtils.createEmptyStateEntity())
    object.setOvercurrent(GroovyUtils.createEmptyStateEntity())
    object.setVoltageType(GroovyUtils.createEmptyStateEntity())
    object.setPosition(GroovyUtils.createEmptyStateEntity())
    object.setLamelPosition(GroovyUtils.createEmptyStateEntity())
    object.setLamelMoveTimeout(GroovyUtils.createEmptyStateEntity())
    object.setDistributedLogicGroup(GroovyUtils.createEmptyStateEntity())
    object.setReversePosition(GroovyUtils.createEmptyStateEntity())
    object.setBlindsUpMaxTime(GroovyUtils.createEmptyStateEntity())
    object.setBlindsDownMaxTime(GroovyUtils.createEmptyStateEntity())
    object.setMechanicalOffset(GroovyUtils.createEmptyStateEntity())
    object.setSetPosition(GroovyUtils.createEmptyAbstractAction())
    object.setSetLamelPosition(GroovyUtils.createEmptyAbstractAction())
    object.setCalibration(GroovyUtils.createEmptyAbstractAction())
    object.setSetLamelMoveTimeout(GroovyUtils.createEmptyAbstractAction())
    object.setMoveUp(GroovyUtils.createEmptyAbstractAction())
    object.setMoveDown(GroovyUtils.createEmptyAbstractAction())
    object.setStart(GroovyUtils.createEmptyAbstractAction())
    object.setStop(GroovyUtils.createEmptyAbstractAction())
    object.setHold(GroovyUtils.createEmptyAbstractAction())
    object.setHoldUp(GroovyUtils.createEmptyAbstractAction())
    object.setHoldDown(GroovyUtils.createEmptyAbstractAction())
    object.setSetRollerBlocked(GroovyUtils.createEmptyAbstractAction())
    object.setLamelStart(GroovyUtils.createEmptyAbstractAction())
    object.setSetMechanicalOffset(GroovyUtils.createEmptyAbstractAction())
    object.setSetBlindsUpMaxTime(GroovyUtils.createEmptyAbstractAction())
    object.setSetBlindsDownMaxTime(GroovyUtils.createEmptyAbstractAction())
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setLabel(textResources.getString("roller_shutter"))
    setObjectValuesForEmptyWidget(emptyWidget.getObject())
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetRollerShutterV3 widget = createWidget()
    widget.setLabel(projectElementDto.getLabel())
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 23
                && deviceObjectDto.getModuleInfoDto().getFirmwareType() == 2
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 2){
            setValuesForRollerShutterWithVoltages(deviceObjectDto, widget)
            if(deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() == 2){
                setBlindsVariantOne(deviceObjectDto, widget)
            } else if(deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() == 3){
                setBlindsVariantTwo(deviceObjectDto, widget)
                setMechanicalOffsets(deviceObjectDto, widget)
            }
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 32
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 2){
            setValuesForRollerShutterWithVoltages(deviceObjectDto, widget)
            if(deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() == 2){
                setBlindsVariantOne(deviceObjectDto, widget)
            } else if(deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() == 3){
                setBlindsVariantTwo(deviceObjectDto, widget)
                setMechanicalOffsets(deviceObjectDto, widget)
            }
        }  else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 42
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 2){
            setValuesForRollerShutter(deviceObjectDto, widget)
            if(deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() == 2){
                setBlindsVariantOne(deviceObjectDto, widget)
            } else if(deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() == 3){
                setBlindsVariantTwo(deviceObjectDto, widget)
                setMechanicalOffsets(deviceObjectDto, widget)
            }
        } else if (deviceObjectDto.getObjectTypeId() == 69) {
            setValuesForRollerShutter4402341675009(deviceObjectDto, widget)
        }
    }
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    if (projectObject instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectObject
        if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 23
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 2){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 32
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 2){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 24
                && deviceObjectDto.getModuleInfoDto().getHardwareType() == 42
                && deviceObjectDto.getModuleInfoDto().getFirmwareApiVersion() >= 2){
            return true
        } else if (deviceObjectDto.getObjectTypeId() == 69) {
            return true;
        }

    }
    return false
}

def setValuesForRollerShutter(DeviceObjectDto deviceObjectDto, WidgetRollerShutterV3 widget){
    widget.getObject().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
    widget.getObject().setUp(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "3"))
    widget.getObject().setDown(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "4"))
    widget.getObject().setPosition(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "7"))
    widget.getObject().setLamelPosition(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "8"))
    widget.getObject().setLamelMoveTimeout(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "10"))
    widget.getObject().setDistributedLogicGroup(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "11"))
    widget.getObject().setSetPosition(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "10"))
    widget.getObject().setSetLamelPosition(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "9"))
    widget.getObject().setCalibration(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "1", "8"))
    widget.getObject().setSetLamelMoveTimeout(GroovyUtils.createAbstractAction("PSEUDO_METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "10"))
    widget.getObject().setMoveUp(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0", "0"))
    widget.getObject().setMoveDown(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0", "1"))
    widget.getObject().setStart(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0", "2"))
    widget.getObject().setStop(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "3"))
    widget.getObject().setHold(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "4"))
    widget.getObject().setHoldUp(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "5"))
    widget.getObject().setHoldDown(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "6"))
    widget.getObject().setSetRollerBlocked(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0", "13"))
    widget.getObject().setLamelStart(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "14"))
}

def setValuesForRollerShutter4402341675009(DeviceObjectDto deviceObjectDto, WidgetRollerShutterV3 widget){
    widget.getObject().setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "2"))
    widget.getObject().setPosition(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "4"))
    widget.getObject().setLamelPosition(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "6"))
    widget.getObject().setLamelMoveTimeout(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "7"))
    widget.getObject().setReversePosition(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "11"))
    widget.getObject().setBlindsUpMaxTime(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "9"))
    widget.getObject().setBlindsDownMaxTime(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "10"))
    widget.getObject().setMechanicalOffset(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "8"))

    widget.getObject().setSetPosition(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "7"))
    widget.getObject().setSetLamelPosition(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "9"))
    widget.getObject().setSetLamelMoveTimeout(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "10"))

    widget.getObject().setMoveUp(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "0"))
    widget.getObject().setMoveDown(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "1"))
    widget.getObject().setStart(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "2"))
    widget.getObject().setStop(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "3"))
    widget.getObject().setHold(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "4"))
    widget.getObject().setHoldUp(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "5"))
    widget.getObject().setHoldDown(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "6"))
    widget.getObject().setSetRollerBlocked(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0", "14"))
    widget.getObject().setLamelStart(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "", "15"))

    widget.getObject().setSetBlindsUpMaxTime(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "12"))
    widget.getObject().setSetBlindsDownMaxTime(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "13"))
    widget.getObject().setSetMechanicalOffset(GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "11"))
}

def setValuesForRollerShutterWithVoltages(DeviceObjectDto deviceObjectDto, WidgetRollerShutterV3 widget){
    setValuesForRollerShutter(deviceObjectDto, widget)
    widget.getObject().setLoadCurrent(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "2"))
    widget.getObject().setOvercurrent(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "5"))
    widget.getObject().setVoltageType(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "6"))
}

def setBlindsVariantOne(DeviceObjectDto deviceObjectDto, WidgetRollerShutterV3 widget){
    widget.getObject().setReversePosition(GroovyUtils.createEmptyStateEntity())
    widget.getObject().setBlindsUpMaxTime(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "9"))
    widget.getObject().setBlindsDownMaxTime(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "9"))
    widget.getObject().setSetBlindsUpMaxTime(GroovyUtils.createAbstractAction("PSEUDO_METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "9"))
    widget.getObject().setSetBlindsDownMaxTime(GroovyUtils.createAbstractAction("PSEUDO_METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "9"))
}

def setBlindsVariantTwo(DeviceObjectDto deviceObjectDto, WidgetRollerShutterV3 widget){
    widget.getObject().setReversePosition(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "13"))
    widget.getObject().setBlindsUpMaxTime(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "14"))
    widget.getObject().setBlindsDownMaxTime(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "15"))
    widget.getObject().setSetBlindsUpMaxTime(GroovyUtils.createAbstractAction("PSEUDO_METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "14"))
    widget.getObject().setSetBlindsDownMaxTime(GroovyUtils.createAbstractAction("PSEUDO_METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "15"))
}

def setMechanicalOffsets(DeviceObjectDto deviceObjectDto, WidgetRollerShutterV3 widget){
    widget.getObject().setMechanicalOffset(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "16"))
    widget.getObject().setSetMechanicalOffset(GroovyUtils.createAbstractAction("PSEUDO_METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "16"))
}
