package mygrenton.templates

import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.dto.DeviceObjectDto
import com.grenton.om.mobile.dto.ScriptDto
import com.grenton.om.mobile.entity.BackgroundEntity
import com.grenton.om.mobile.entity.action.AbstractAction
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetScene
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetScene emptyWidget = createWidget()

def getWidgetType() {
    return "SCENE"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    if(projectElementDto instanceof ScriptDto){
        return 0
    } else if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if (deviceObjectDto.getObjectTypeId() == 52) {
            return 1
        } else if (deviceObjectDto.getObjectTypeId() == 4) {
            return 1
        } else if(deviceObjectDto.getObjectTypeId() == 32) {
            return 1
        }
    }
    return 5
}

WidgetScene createWidget(){
    WidgetScene widget = new WidgetScene();
    widget.setType("SCENE")
    widget.setBackground(createBackgroundEntity())
    widget.setButtonMonostable(GroovyUtils.createButtonMonostable())
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setButtonMonostable(GroovyUtils.createButtonMonostable())
    emptyWidget.getButtonMonostable().setLabel(textResources.getString("scene"))
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetScene widget = createWidget()
    widget.getButtonMonostable().setLabel(projectElementDto.getLabel())
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if(deviceObjectDto.getObjectTypeId() == 4){
            setValuesForDout(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 52){
            setValuesForDout(deviceObjectDto, widget)
        } else if(deviceObjectDto.getObjectTypeId() == 32){
            setValuesForDaliGear(deviceObjectDto, widget)
        }
    } else if(projectElementDto instanceof ScriptDto){
        ScriptDto scriptDto = (ScriptDto) projectElementDto
        setValuesForScript(scriptDto, widget)
    }
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    if (projectObject instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectObject
        if(deviceObjectDto.getObjectTypeId() == 4){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 52){
            return true
        } else if(deviceObjectDto.getObjectTypeId() == 32){
            return true
        }
    } else if(projectObject instanceof ScriptDto){
        return true
    }
    return false
}

BackgroundEntity createBackgroundEntity(){
    BackgroundEntity backgroundEntity = new BackgroundEntity();
    backgroundEntity.setImage("holiday")
    backgroundEntity.setColor("blue")
    return backgroundEntity;
}

def setValuesForDout(DeviceObjectDto deviceObjectDto, WidgetScene widget){
    AbstractAction buttonAction = GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0")
    buttonAction.setIndex("0")
    widget.getButtonMonostable().setActionClick(buttonAction)
}

def setValuesForDaliGear(DeviceObjectDto deviceObjectDto, WidgetScene widget){
    AbstractAction buttonAction = GroovyUtils.createAbstractAction("METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "0")
    buttonAction.setIndex("2")
    widget.getButtonMonostable().setActionClick(buttonAction)
}

def setValuesForScript(ScriptDto scriptDto, WidgetScene widget){
    AbstractAction buttonAction = GroovyUtils.createAbstractAction("SCRIPT", scriptDto.getCluObjectId(),
            scriptDto.getLabel(), "")
    widget.getButtonMonostable().setActionClick(buttonAction)
}




