package mygrenton.templates

import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.dto.VirtualObjectDto
import com.grenton.om.mobile.entity.BackgroundEntity
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetSceneDouble
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetSceneDouble emptyWidget = createWidget()

def getWidgetType() {
    return "SCENE_DOUBLE"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    if(projectElementDto instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if (virtualObjectDto.getObjectTypeId() == 102 && virtualObjectDto.getTypeVersion() == 1) {
            return 1
        } else if (virtualObjectDto.getObjectTypeId() == 100 && virtualObjectDto.getTypeVersion() == 1) {
            return 1
        }
    }
    return 6
}

WidgetSceneDouble createWidget(){
    WidgetSceneDouble widget = new WidgetSceneDouble();
    widget.setType("SCENE_DOUBLE")
    widget.setBackground(createBackgroundEntity())
    widget.setButtonMonostableFirst(GroovyUtils.createButtonMonostable())
    widget.setButtonMonostableSecond(GroovyUtils.createButtonMonostable())
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.getButtonMonostableFirst().setLabel(textResources.getString("open"))
    emptyWidget.getButtonMonostableSecond().setLabel(textResources.getString("close"))
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetSceneDouble widget = createWidget()
    if(projectElementDto instanceof VirtualObjectDto){
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if(virtualObjectDto.getObjectTypeId() == 102 && virtualObjectDto.getTypeVersion() == 1){
            widget.getButtonMonostableFirst().setLabel(textResources.getString("satel_out_on"))
            widget.getButtonMonostableSecond().setLabel(textResources.getString("satel_out_off"))
            setValuesForSatelOutputAndSatelZone(virtualObjectDto, widget)
        } else if(virtualObjectDto.getObjectTypeId() == 100 && virtualObjectDto.getTypeVersion() == 1){
            widget.getBackground().setImage("alarm")
            widget.getButtonMonostableFirst().setLabel(textResources.getString("arm_zone"))
            widget.getButtonMonostableSecond().setLabel(textResources.getString("disarm_zone"))
            setValuesForSatelOutputAndSatelZone(virtualObjectDto, widget)
        } else if(virtualObjectDto.getObjectTypeId() == 151) {
            widget.getBackground().setImage("alarm")
            widget.getButtonMonostableFirst().setLabel(textResources.getString("arm_zone"))
            widget.getButtonMonostableSecond().setLabel(textResources.getString("disarm_zone"))
            setValuesForJablotronSection(virtualObjectDto, widget)
        } else if(virtualObjectDto.getObjectTypeId() == 152) {
            widget.getBackground().setImage("gate_2")
            widget.getButtonMonostableFirst().setLabel(textResources.getString("switch_on"))
            widget.getButtonMonostableSecond().setLabel(textResources.getString("switch_off"))
            setValuesForJablotronOutput(virtualObjectDto, widget)
        }
    }
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    if(projectObject instanceof VirtualObjectDto) {
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectObject
        if (virtualObjectDto.getObjectTypeId() == 102 && virtualObjectDto.getTypeVersion() == 1) {
            return true
        } else if (virtualObjectDto.getObjectTypeId() == 100 && virtualObjectDto.getTypeVersion() == 1) {
            return true
        } else if (virtualObjectDto.getObjectTypeId() == 151 || virtualObjectDto.getObjectTypeId() == 152) {
            return true
        }
    }
    return false
}

BackgroundEntity createBackgroundEntity(){
    BackgroundEntity backgroundEntity = new BackgroundEntity();
    backgroundEntity.setImage("gate_2")
    backgroundEntity.setColor("blue")
    return backgroundEntity;
}

def setValuesForSatelOutputAndSatelZone(VirtualObjectDto virtualObjectDto, WidgetSceneDouble widget){
    widget.getButtonMonostableFirst().setActionClick(GroovyUtils.createAbstractAction("METHOD",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "", "0"))
    widget.getButtonMonostableSecond().setActionClick(GroovyUtils.createAbstractAction("METHOD",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "", "1"))
}

def setValuesForJablotronSection(VirtualObjectDto virtualObjectDto, WidgetSceneDouble widget){
    widget.getButtonMonostableFirst().setActionClick(GroovyUtils.createAbstractAction("METHOD",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "", "0"))
    widget.getButtonMonostableSecond().setActionClick(GroovyUtils.createAbstractAction("METHOD",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "", "2"))
}

def setValuesForJablotronOutput(VirtualObjectDto virtualObjectDto, WidgetSceneDouble widget){
    widget.getButtonMonostableFirst().setActionClick(GroovyUtils.createAbstractAction("METHOD",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "", "0"))
    widget.getButtonMonostableSecond().setActionClick(GroovyUtils.createAbstractAction("METHOD",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "", "1"))
}





