package mygrenton.templates

import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.dto.VirtualObjectDto
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetScheduler
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetScheduler emptyWidget = createWidget()

def getWidgetType() {
    return "SCHEDULER"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    if(projectElementDto instanceof VirtualObjectDto){
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if(virtualObjectDto.getObjectTypeId() == 16 && virtualObjectDto.getTypeVersion() == 1){
            return 0
        }
    }
    return 14
}

WidgetScheduler createWidget(){
    WidgetScheduler widget = new WidgetScheduler();
    widget.setType("SCHEDULER")
    widget.setId(0)
    widget.setIcon("scheduler")
    return widget;
}

def setObjectValuesForEmptyWidget(){
    emptyWidget.setSchedule(GroovyUtils.createEmptyStateEntity())
    emptyWidget.setState(GroovyUtils.createEmptyStateEntity())
    emptyWidget.setValue(GroovyUtils.createEmptyStateEntity())
    emptyWidget.setMin(GroovyUtils.createEmptyStateEntity())
    emptyWidget.setMax(GroovyUtils.createEmptyStateEntity())
    emptyWidget.setSetSchedule(GroovyUtils.createEmptyAbstractAction())
    emptyWidget.setSetMin(GroovyUtils.createEmptyAbstractAction())
    emptyWidget.setSetMax(GroovyUtils.createEmptyAbstractAction())
    emptyWidget.setStart(GroovyUtils.createEmptyAbstractAction())
    emptyWidget.setStop(GroovyUtils.createEmptyAbstractAction())
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setLabel(textResources.getString("scheduler"))
    setObjectValuesForEmptyWidget()
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetScheduler widget = createWidget()
    widget.setLabel(projectElementDto.getLabel())
    if(projectElementDto instanceof VirtualObjectDto){
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if(virtualObjectDto.getObjectTypeId() == 16 && virtualObjectDto.getTypeVersion() == 1){
            setValuesForScheduler(virtualObjectDto, widget)
        }
    }
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    if(projectObject instanceof VirtualObjectDto){
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectObject
        if(virtualObjectDto.getObjectTypeId() == 16 && virtualObjectDto.getTypeVersion() == 1){
            return true
        }
    }
    return false
}

def setValuesForScheduler(VirtualObjectDto virtualObjectDto, WidgetScheduler widget){
    widget.setIcon("scheduler")
    widget.setSchedule(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "0"))
    widget.setState(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "1"))
    widget.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "2"))
    widget.setMin(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "3"))
    widget.setMax(GroovyUtils.createStateEntity("ATTRIBUTE",
            virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "4"))
    widget.setSetSchedule(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "0"))
    widget.setSetMin(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "3"))
    widget.setSetMax(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "\$value\$", "4"))
    widget.setStart(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "0"))
    widget.setStop(GroovyUtils.createAbstractAction("METHOD", virtualObjectDto.getCluObjectId(),
            virtualObjectDto.getObjectId(), "", "1"))
}



