package mygrenton.templates

import com.grenton.om.mobile.dto.DeviceObjectDto
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.entity.widget.WidgetSlider
import com.grenton.om.mobile.entity.widget.objects.WidgetSliderObject
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetSlider emptyWidget = createWidget()

def getWidgetType() {
    return "SLIDER"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 21
}

WidgetSlider createWidget(){
    WidgetSlider widget = new WidgetSlider();
    widget.setType("SLIDER")
    widget.setIcon("volume_circle")
    widget.setMin(0.0)
    widget.setMax(1.0)
    widget.setUnit("UNKNOWN")
    widget.setPrecision(2)
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setLabel(textResources.getString("slider"))
    emptyWidget.setObject(createEmptyWidgetSliderObject())
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetSlider widget = createWidget()
    widget.setLabel(projectElementDto.getLabel())
    widget.setObject(createEmptyWidgetSliderObject())
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        if (deviceObjectDto.getObjectTypeId() == 13) {
            setValuesForAnalogOut(deviceObjectDto, widget)
        }
    }
    return widget;
}

def isSupported(ProjectElementDto projectElementDto) {
    if (projectElementDto instanceof DeviceObjectDto) {
        DeviceObjectDto deviceObjectDto = (DeviceObjectDto) projectElementDto
        return deviceObjectDto.getObjectTypeId() == 13
    }
    return false
}

WidgetSliderObject createEmptyWidgetSliderObject(){
    WidgetSliderObject widgetSliderObject = new WidgetSliderObject()
    widgetSliderObject.setValue(GroovyUtils.createEmptyStateEntity())
    widgetSliderObject.setSetValueAction(GroovyUtils.createEmptyAbstractAction())
    widgetSliderObject.setClickAction(GroovyUtils.createEmptyAbstractAction())
    return widgetSliderObject;
}

def setValuesForAnalogOut(DeviceObjectDto deviceObjectDto, WidgetSlider widget){
    widget.setMin(0.0)
    widget.setMax(10.0)
    widget.getObject().setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
    widget.getObject().setSetValueAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", deviceObjectDto.getCluObjectId(),
            deviceObjectDto.getObjectId(), "\$value\$", "0"))
}


