package mygrenton.templates

import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetText
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetText emptyWidget = createWidget()

def getWidgetType() {
    return "TEXT"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 13
}

WidgetText createWidget(){
    WidgetText widget = new WidgetText();
    widget.setType("TEXT")
    widget.setIcon("text")
    widget.setIconVisible(true)
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setLabel(textResources.getString("text"))
    emptyWidget.setText(GroovyUtils.createEmptyStateEntity())
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetText widget = createWidget()
    widget.setLabel(projectElementDto.getLabel())
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    return false
}



