package mygrenton.templates

import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.dto.VirtualObjectDto
import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.entity.widget.WidgetThermostatV2
import com.grenton.om.mobile.entity.widget.objects.WidgetThermostatV2Object
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetThermostatV2 emptyWidget = createWidget()

def getWidgetType() {
    return "THERMOSTAT_V2"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    if(projectElementDto instanceof VirtualObjectDto){
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if(virtualObjectDto.getObjectTypeId() == 18 && virtualObjectDto.getTypeVersion() == 2
                || virtualObjectDto.getObjectTypeId() == 46 && virtualObjectDto.getTypeVersion() == 1){
            return 0
        }
    }
    return 9
}

WidgetThermostatV2 createWidget(){
    WidgetThermostatV2 widget = new WidgetThermostatV2();
    widget.setType("THERMOSTAT_V2")
    widget.setIcon("temperature")
    widget.setNoOfFanSpeeds(0)
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setLabel(textResources.getString("thermostat"))
    emptyWidget.setObject(createEmptyWidgetThermostatV2Object())
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetThermostatV2 widget = createWidget()
    widget.setLabel(projectElementDto.getLabel())
    if(projectElementDto instanceof VirtualObjectDto){
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectElementDto
        if(virtualObjectDto.getObjectTypeId() == 18 && virtualObjectDto.getTypeVersion() == 2){
            widget.setObject(createFilledWidgetThermostatV2ObjectForThermostat(virtualObjectDto))
        } else if (virtualObjectDto.getObjectTypeId() == 46 && virtualObjectDto.getTypeVersion() == 1) {
            widget.setNoOfFanSpeeds(3)
            widget.setObject(createFilledWidgetThermostatV2ObjectForMultifanThermostat(virtualObjectDto))
        }

    }
    return widget
}

def isSupported(ProjectElementDto projectObject) {
    if(projectObject instanceof VirtualObjectDto){
        VirtualObjectDto virtualObjectDto = (VirtualObjectDto) projectObject
        if(virtualObjectDto.getObjectTypeId() == 18 && virtualObjectDto.getTypeVersion() == 2
                || virtualObjectDto.getObjectTypeId() == 46 && virtualObjectDto.getTypeVersion() == 1){
            return true
        }
    }
    return false
}

WidgetThermostatV2Object createEmptyWidgetThermostatV2Object() {
    WidgetThermostatV2Object widget = new WidgetThermostatV2Object()
    widget.setState(GroovyUtils.createEmptyStateEntity())
    widget.setMode(GroovyUtils.createEmptyStateEntity())
    widget.setSetModeAction(GroovyUtils.createEmptyAbstractAction())
    widget.setSetStateAction(GroovyUtils.createEmptyAbstractAction())
    widget.setCurrentTemperature(GroovyUtils.createEmptyStateEntity())
    widget.setSetTargetTemperatureAction(GroovyUtils.createEmptyAbstractAction())
    widget.setControlOutValue(GroovyUtils.createEmptyStateEntity())
    widget.setScheduleData(GroovyUtils.createEmptyStateEntity())
    widget.setSetScheduleDataAction(GroovyUtils.createEmptyAbstractAction())
    widget.setMinTemperature(GroovyUtils.createEmptyStateEntity())
    widget.setSetMinTemperatureAction(GroovyUtils.createEmptyAbstractAction())
    widget.setMaxTemperature(GroovyUtils.createEmptyStateEntity())
    widget.setSetMaxTemperatureAction(GroovyUtils.createEmptyAbstractAction())
    widget.setControlDirection(GroovyUtils.createEmptyStateEntity())
    widget.setSetControlDirection(GroovyUtils.createEmptyAbstractAction())
    widget.setFanMode(GroovyUtils.createEmptyStateEntity())
    widget.setControlOutValue(GroovyUtils.createEmptyStateEntity())

    return widget

}

WidgetThermostatV2Object createFilledWidgetThermostatV2ObjectForThermostat(VirtualObjectDto virtualObjectDto){
    WidgetThermostatV2Object widget = new WidgetThermostatV2Object()
    widget.setState(GroovyUtils.createStateEntity("ATTRIBUTE", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "6"))
    widget.setMode(GroovyUtils.createStateEntity("ATTRIBUTE", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "8"))
    widget.setSetModeAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "\$value\$", "8"))
    widget.setSetStateAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "\$value\$", "6"))
    widget.setCurrentTemperature(GroovyUtils.createStateEntity("ATTRIBUTE", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "14"))
    widget.setTargetTemperature(GroovyUtils.createStateEntity("ATTRIBUTE", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "12"))
    widget.setSetTargetTemperatureAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "\$value\$", "3"))
    widget.setControlOutValue(GroovyUtils.createStateEntity("ATTRIBUTE", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "13"))
    widget.setScheduleData(GroovyUtils.createStateEntity("ATTRIBUTE", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "9"))
    widget.setSetScheduleDataAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "\$value\$", "9"))
    widget.setMinTemperature(GroovyUtils.createStateEntity("ATTRIBUTE", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "10"))
    widget.setSetMinTemperatureAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "\$value\$", "10"))
    widget.setMaxTemperature(GroovyUtils.createStateEntity("ATTRIBUTE", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "11"))
    widget.setSetMaxTemperatureAction(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "\$value\$", "11"))

    widget.setControlDirection(GroovyUtils.createEmptyStateEntity())
    widget.setSetControlDirection(GroovyUtils.createEmptyAbstractAction())
    widget.setSetFanMode(GroovyUtils.createEmptyAbstractAction())
    widget.setFanControlOutValue(GroovyUtils.createEmptyStateEntity())
    widget.setFanMode(GroovyUtils.createEmptyStateEntity())

    return widget
}

WidgetThermostatV2Object createFilledWidgetThermostatV2ObjectForMultifanThermostat(VirtualObjectDto virtualObjectDto){
    WidgetThermostatV2Object widget = createFilledWidgetThermostatV2ObjectForThermostat(virtualObjectDto)

    widget.setControlDirection(GroovyUtils.createStateEntity("ATTRIBUTE", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "7"))
    widget.setSetControlDirection(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "\$value\$", "7"))
    widget.setSetFanMode(GroovyUtils.createAbstractAction("PSEUDO_METHOD", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "\$value\$", "18"))
    widget.setFanMode(GroovyUtils.createStateEntity("ATTRIBUTE", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "18"))
    widget.setFanControlOutValue(GroovyUtils.createStateEntity("ATTRIBUTE", virtualObjectDto.getCluObjectId(), virtualObjectDto.getObjectId(), "22"))

    return widget
}


