package mygrenton.templates

import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.widget.WidgetTvRemoteControl
import com.grenton.om.mobile.entity.widget.objects.WidgetTvRemoteControlObject
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetTvRemoteControl emptyWidget = createWidget()

def getWidgetType() {
    return "TV_REMOTE_CONTROL"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 17
}

WidgetTvRemoteControl createWidget(){
    WidgetTvRemoteControl widget = new WidgetTvRemoteControl();
    widget.setType("TV_REMOTE_CONTROL")
    widget.setId(0)
    widget.setIcon("tv")
    WidgetTvRemoteControlObject object = new WidgetTvRemoteControlObject()
    widget.setObject(object)
    return widget;
}

def setObjectValuesForEmptyWidget(WidgetTvRemoteControlObject object){
    object.setInit(GroovyUtils.createEmptyAbstractAction())
    object.setOff(GroovyUtils.createEmptyAbstractAction())
    object.setOn(GroovyUtils.createEmptyAbstractAction())
    object.setUp(GroovyUtils.createEmptyAbstractAction())
    object.setDown(GroovyUtils.createEmptyAbstractAction())
    object.setLeft(GroovyUtils.createEmptyAbstractAction())
    object.setRight(GroovyUtils.createEmptyAbstractAction())
    object.setOk(GroovyUtils.createEmptyAbstractAction())
    object.setMute(GroovyUtils.createEmptyAbstractAction())
    object.setGuide(GroovyUtils.createEmptyAbstractAction())
    object.setVolumeUp(GroovyUtils.createEmptyAbstractAction())
    object.setVolumeDown(GroovyUtils.createEmptyAbstractAction())
    object.setBack(GroovyUtils.createEmptyAbstractAction())
    object.setMenu(GroovyUtils.createEmptyAbstractAction())
    object.setVod(GroovyUtils.createEmptyAbstractAction())
    object.setNextChannel(GroovyUtils.createEmptyAbstractAction())
    object.setPreviousChannel(GroovyUtils.createEmptyAbstractAction())
    object.setFastRewind(GroovyUtils.createEmptyAbstractAction())
    object.setPause(GroovyUtils.createEmptyAbstractAction())
    object.setPlay(GroovyUtils.createEmptyAbstractAction())
    object.setFastForward(GroovyUtils.createEmptyAbstractAction())
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.setLabel(textResources.getString("tvRemoteControl"))
    emptyWidget.setVodLabel(textResources.getString("tvVodLabel"))
    setObjectValuesForEmptyWidget(emptyWidget.getObject())
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetTvRemoteControl widget = createWidget()
    widget.setLabel(projectElementDto.getLabel())
    return widget;
}

def isSupported(ProjectElementDto projectObject) {
    return false
}



