package mygrenton.templates

import com.grenton.om.mobile.dto.DeviceObjectDto
import com.grenton.om.mobile.dto.ModuleDto
import com.grenton.om.mobile.dto.ProjectElementDto
import com.grenton.om.mobile.entity.utils.GroovyUtils
import com.grenton.om.mobile.entity.widget.AbstractWidget
import com.grenton.om.mobile.entity.widget.WidgetValueDouble
import com.grenton.om.mobile.entity.widget.objects.WidgetDoubleComponent
import com.grenton.om.mobile.gui.template.TextResources
import groovy.transform.Field

@Field WidgetValueDouble emptyWidget = createWidget()

def getWidgetType() {
    return "VALUE_DOUBLE"
}

def getOrderIndex(ProjectElementDto projectElementDto) {
    return 2
}

WidgetValueDouble createWidget(){
    WidgetValueDouble widget = new WidgetValueDouble();
    widget.setType("VALUE_DOUBLE")
    widget.setComponentLeft(createWidgetDoubleComponent())
    widget.setComponentRight(createWidgetDoubleComponent())
    return widget;
}

AbstractWidget createEmptyWidgetGui(TextResources textResources) {
    emptyWidget.getComponentLeft().setLabel(textResources.getString("value"))
    emptyWidget.getComponentRight().setLabel(textResources.getString("value"))
    return emptyWidget;
}

AbstractWidget createWidgetGui(ProjectElementDto projectElementDto, TextResources textResources) {
    WidgetValueDouble widget = createWidget()
    if(projectElementDto instanceof ModuleDto){
        ModuleDto moduleDto = (ModuleDto) projectElementDto
        long hwType = moduleDto.getModuleInfoDto().getHardwareType()
        if (hwType == 2576981427970 || hwType == 2576981427973 || hwType == 2576981428000) {
            setValuesForSensor(moduleDto, widget)
        }
    }
    return widget
}

def isSupported(ProjectElementDto projectObject) {
    if(projectObject instanceof ModuleDto){
        ModuleDto moduleDto = (ModuleDto) projectObject
        long hwType = moduleDto.getModuleInfoDto().getHardwareType()
        return hwType == 2576981427970 || hwType == 2576981427973 || hwType == 2576981428000
    }
    return false
}

WidgetDoubleComponent createWidgetDoubleComponent(){
    WidgetDoubleComponent component = new WidgetDoubleComponent();
    component.setIcon("value_double")
    component.setUnit("UNKNOWN")
    component.setValueType("STRING")
    component.setPrecision(2)
    component.setValue(GroovyUtils.createEmptyStateEntity())
    return component
}

def setValuesForSensor(ModuleDto moduleDto, WidgetValueDouble widget) {
    for (DeviceObjectDto deviceObjectDto : moduleDto.getDeviceObjects()) {
        if (deviceObjectDto.getObjectTypeId() == 25) {
            setValuesForBinarySensor(deviceObjectDto, widget.getComponentLeft())
        } else if (deviceObjectDto.getObjectTypeId() == 55) {
            setValuesForBattery(deviceObjectDto, widget.getComponentRight())
        }
    }
}

def setValuesForBinarySensor(DeviceObjectDto deviceObjectDto, WidgetDoubleComponent wdc){
    wdc.setLabel(deviceObjectDto.getLabel())
    wdc.setIcon("value")
    wdc.setUnit("UNKNOWN")
    wdc.setValueType("INTEGER")
    wdc.setPrecision(2)
    wdc.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
}

def setValuesForBattery(DeviceObjectDto deviceObjectDto, WidgetDoubleComponent wdc){
    wdc.setLabel(deviceObjectDto.getLabel())
    wdc.setIcon("battery_status_1")
    wdc.setUnit("PERCENT")
    wdc.setValueType("INTEGER")
    wdc.setPrecision(2)
    wdc.setValue(GroovyUtils.createStateEntity("ATTRIBUTE",
            deviceObjectDto.getCluObjectId(), deviceObjectDto.getObjectId(), "0"))
}



